/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class DirectPositionImpl
implements Cloneable,
DirectPosition,
Position,
Serializable {
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    private static int hashCode(double[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            long temp = Double.doubleToLongBits(array[index]);
            result = 31 * result + (int)(temp ^ temp >>> 32);
        }
        return result;
    }

    public DirectPositionImpl(int numDim) throws NegativeArraySizeException {
        this.ordinates = new double[numDim];
    }

    public DirectPositionImpl(double[] ordinates) {
        this.ordinates = (double[])ordinates.clone();
    }

    public DirectPositionImpl(double x, double y) {
        this.ordinates = new double[]{x, y};
    }

    public DirectPositionImpl(double x, double y, double z) {
        this.ordinates = new double[]{x, y, z};
    }

    public DirectPositionImpl(Point2D point) {
        this(point.getX(), point.getY());
    }

    public DirectPositionImpl(DirectPositionImpl point) {
        this.ordinates = (double[])point.ordinates.clone();
        this.crs = point.crs;
    }

    public DirectPositionImpl(DirectPosition point) {
        this.ordinates = (double[])point.getCoordinates().clone();
        this.crs = point.getCoordinateReferenceSystem();
    }

    public DirectPositionImpl(CoordinateReferenceSystem crs) {
        this.setCRS(crs);
        this.ordinates = new double[crs.getCoordinateSystem().getDimension()];
    }

    public DirectPositionImpl(CoordinateReferenceSystem crs, double[] ordinates) {
        this.setCRS(crs);
        this.ordinates = new double[crs.getCoordinateSystem().getDimension()];
        for (int i = 0; i < crs.getCoordinateSystem().getDimension(); ++i) {
            this.ordinates[i] = ordinates[i];
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("DirectPositionImpl(");
        for (int i = 0; i < this.ordinates.length; ++i) {
            buff.append(this.ordinates[i]);
            if (i >= this.ordinates.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return buff.toString();
    }

    private void setCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            throw new IllegalArgumentException("DirectPosition cannot have a null CRS");
        }
        this.crs = crs;
    }

    public int getDimension() {
        return this.ordinates.length;
    }

    public double[] getCoordinate() {
        return this.ordinates;
    }

    @Deprecated
    public double[] getCoordinates() {
        return this.getCoordinate();
    }

    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension];
    }

    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.ordinates[dimension] = value;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public DirectPositionImpl clone() {
        return new DirectPositionImpl(this);
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    @Deprecated
    public DirectPosition getPosition() {
        return this;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        result = 31 * result + DirectPositionImpl.hashCode(this.ordinates);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectPositionImpl other = (DirectPositionImpl)obj;
        if (this.crs == null ? other.crs != null : !this.crs.equals(other.crs)) {
            return false;
        }
        return Arrays.equals(this.ordinates, other.ordinates);
    }
}

