/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry;

import javax.measure.unit.NonSI;
import org.geotools.geometry.jts.GeometryUtils;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnvelopeImpl
implements Envelope {
    private DirectPosition lowerCorner;
    private DirectPosition upperCorner;

    public EnvelopeImpl(DirectPosition lowerCorner, DirectPosition upperCorner) {
        this.lowerCorner = new DirectPositionImpl(lowerCorner);
        this.upperCorner = new DirectPositionImpl(upperCorner);
    }

    public final int getDimension() {
        return this.upperCorner.getDimension();
    }

    public final double getMinimum(int dimension) {
        return this.lowerCorner.getOrdinate(dimension);
    }

    public final double getMaximum(int dimension) {
        return this.upperCorner.getOrdinate(dimension);
    }

    @Deprecated
    public final double getCenter(int dimension) {
        return 0.5 * (this.upperCorner.getOrdinate(dimension) + this.lowerCorner.getOrdinate(dimension));
    }

    public final double getMedian(int dimension) {
        return 0.5 * (this.upperCorner.getOrdinate(dimension) + this.lowerCorner.getOrdinate(dimension));
    }

    @Deprecated
    public final double getLength(int dimension) {
        return this.upperCorner.getOrdinate(dimension) - this.lowerCorner.getOrdinate(dimension);
    }

    public final double getSpan(int dimension) {
        return this.upperCorner.getOrdinate(dimension) - this.lowerCorner.getOrdinate(dimension);
    }

    public final DirectPosition getUpperCorner() {
        return new DirectPositionImpl(this.upperCorner);
    }

    public final DirectPosition getLowerCorner() {
        return new DirectPositionImpl(this.lowerCorner);
    }

    public String toString() {
        double[] bbox = GeometryUtils.getBBox(this, NonSI.DEGREE_ANGLE);
        StringBuffer returnable = new StringBuffer("Envelope[").append(bbox[0]);
        int i = 1;
        while (i < bbox.length) {
            returnable.append(",").append(bbox[i]);
            ++i;
        }
        return returnable.append("]").toString();
    }

    public boolean equals(Object obj) {
        Envelope that = (Envelope)obj;
        return GeometryUtils.equals(this, that);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getUpperCorner().getCoordinateReferenceSystem();
    }
}

