/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.geometry;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.PointGrid;

public class PointGridImpl
implements PointGrid {
    private PointArray[] pointGrid;

    public int width() {
        return this.pointGrid[0].length();
    }

    public int height() {
        return this.pointGrid.length;
    }

    public DirectPosition get(int row, int column) throws IndexOutOfBoundsException {
        return this.getInternal(row, column);
    }

    public DirectPosition get(int row, int column, DirectPosition dest) throws IndexOutOfBoundsException {
        DirectPositionImpl target = new DirectPositionImpl(this.getInternal(row, column));
        if (dest == null || !dest.getCoordinateReferenceSystem().equals(target.getCoordinateReferenceSystem())) {
            return target;
        }
        int i = 0;
        while (i < target.getDimension()) {
            dest.setOrdinate(i, target.getOrdinate(i));
            ++i;
        }
        return dest;
    }

    DirectPosition getInternal(int row, int column) {
        PointArray pointArray = this.pointGrid[row];
        return (DirectPosition)pointArray.positions().get(column);
    }

    public void set(int row, int column, DirectPosition position) throws IndexOutOfBoundsException, UnsupportedOperationException {
        DirectPositionImpl target = new DirectPositionImpl(this.getInternal(row, column));
        if (position.getCoordinateReferenceSystem().equals(target.getCoordinateReferenceSystem())) {
            int i = 0;
            while (i < position.getDimension()) {
                target.setOrdinate(i, position.getOrdinate(i));
                ++i;
            }
        }
    }

    public PointArray getRow(int row) throws IndexOutOfBoundsException {
        return this.pointGrid[row];
    }

    public List rows() {
        ArrayList<PointArray> returnable = new ArrayList<PointArray>(this.pointGrid.length);
        int i = 0;
        while (i < this.pointGrid.length) {
            returnable.add(this.pointGrid[i]);
            ++i;
        }
        return returnable;
    }
}

