/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import junit.framework.TestCase;
import org.geotools.data.FeatureReader;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureReaderTest
extends TestCase {
    private static final String FEATURE_TYPE_NAME = "testType";

    protected void setUp() throws Exception {
        super.setUp();
    }

    private MemoryDataStore createDatastore(CoordinateReferenceSystem crs, Point p) throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(crs);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        SimpleFeature[] features = new SimpleFeature[]{b.buildFeature(null)};
        return new MemoryDataStore(features);
    }

    public void testSameCRS() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore((CoordinateReferenceSystem)crs, p);
        FeatureReader original = ds.getFeatureReader(FEATURE_TYPE_NAME);
        ForceCoordinateSystemFeatureReader modified = new ForceCoordinateSystemFeatureReader(ds.getFeatureReader(FEATURE_TYPE_NAME), (CoordinateReferenceSystem)crs);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)f1, (Object)f2);
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureReaderTest.assertSame((Object)modified.builder.getFeatureType(), (Object)original.getFeatureType());
    }

    public void testDifferentCRS() throws Exception {
        DefaultGeographicCRS srcCRS = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore((CoordinateReferenceSystem)srcCRS, p);
        FeatureReader original = ds.getFeatureReader(FEATURE_TYPE_NAME);
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        ForceCoordinateSystemFeatureReader modified = new ForceCoordinateSystemFeatureReader(ds.getFeatureReader(FEATURE_TYPE_NAME), (CoordinateReferenceSystem)destCRS);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
        SimpleFeatureType f1Type = f1.getFeatureType();
        SimpleFeatureType f2Type = f2.getFeatureType();
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)f1Type.getCoordinateReferenceSystem().equals(f2Type.getCoordinateReferenceSystem()));
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)srcCRS, (Object)f1Type.getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)srcCRS, (Object)f1Type.getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureReaderTest.assertNotNull((Object)modified.builder);
    }

    public void testNullDestination() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore((CoordinateReferenceSystem)crs, p);
        try {
            new ForceCoordinateSystemFeatureReader(ds.getFeatureReader(FEATURE_TYPE_NAME), null);
            ForceCoordinateSystemFeatureReaderTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullSource() throws Exception {
        CoordinateReferenceSystem srcCRS = null;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        MemoryDataStore ds = this.createDatastore(srcCRS, p);
        FeatureReader original = ds.getFeatureReader(FEATURE_TYPE_NAME);
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        ForceCoordinateSystemFeatureReader modified = new ForceCoordinateSystemFeatureReader(ds.getFeatureReader(FEATURE_TYPE_NAME), (CoordinateReferenceSystem)destCRS);
        SimpleFeature f1 = (SimpleFeature)original.next();
        SimpleFeature f2 = modified.next();
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
        SimpleFeatureType f1Type = f1.getFeatureType();
        SimpleFeatureType f2Type = f2.getFeatureType();
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)f2Type.getCoordinateReferenceSystem().equals(f1Type.getCoordinateReferenceSystem()));
        ForceCoordinateSystemFeatureReaderTest.assertEquals(srcCRS, (Object)f1Type.getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertEquals(srcCRS, (Object)f1Type.getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getGeometryDescriptor().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)original.hasNext());
        ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)modified.hasNext());
        ForceCoordinateSystemFeatureReaderTest.assertNotNull((Object)modified.builder);
    }
}

