/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import junit.framework.TestCase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureCollectionWrapperTestSupport
extends TestCase {
    protected CoordinateReferenceSystem crs;
    protected SimpleFeatureCollection delegate;

    protected void setUp() throws Exception {
        this.crs = CRS.parseWKT((String)"GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]");
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.setNamespaceURI("test");
        typeBuilder.setCRS(this.crs);
        typeBuilder.add("defaultGeom", Point.class, this.crs);
        typeBuilder.add("someAtt", Integer.class);
        typeBuilder.add("otherGeom", LineString.class);
        typeBuilder.setDefaultGeometry("defaultGeom");
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        GeometryFactory gf = new GeometryFactory();
        this.delegate = new DefaultFeatureCollection("test", featureType){};
        double x = -140.0;
        double y = 45.0;
        int features = 5;
        int i = 0;
        while (i < 5) {
            Point point = gf.createPoint(new Coordinate(x + (double)i, y + (double)i));
            point.setUserData((Object)this.crs);
            builder.add((Object)point);
            builder.add((Object)new Integer(i));
            LineString line = gf.createLineString(new Coordinate[]{new Coordinate(x + (double)i, y + (double)i), new Coordinate(x + (double)i + 1.0, y + (double)i + 1.0)});
            line.setUserData((Object)this.crs);
            builder.add((Object)line);
            this.delegate.add((Feature)builder.buildFeature(String.valueOf(i)));
            ++i;
        }
        builder.add(null);
        builder.add((Object)new Integer(-1));
        builder.add(null);
        this.delegate.add((Feature)builder.buildFeature("6"));
    }
}

