/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class SimpleFeatureBuilderTest
extends TestCase {
    SimpleFeatureBuilder builder;

    protected void setUp() throws Exception {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("test");
        typeBuilder.add("point", Point.class);
        typeBuilder.add("integer", Integer.class);
        typeBuilder.add("float", Float.class);
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        this.builder = new SimpleFeatureBuilder(featureType);
        this.builder.setValidating(true);
    }

    public void testSanity() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)new Integer(1));
        this.builder.add((Object)new Float(2.0));
        SimpleFeature feature = this.builder.buildFeature("fid");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        SimpleFeatureBuilderTest.assertEquals((int)3, (int)feature.getAttributeCount());
        SimpleFeatureBuilderTest.assertTrue((boolean)gf.createPoint(new Coordinate(0.0, 0.0)).equals((Geometry)feature.getAttribute("point")));
        SimpleFeatureBuilderTest.assertEquals((Object)new Integer(1), (Object)feature.getAttribute("integer"));
        SimpleFeatureBuilderTest.assertEquals((Object)new Float(2.0), (Object)feature.getAttribute("float"));
    }

    public void testTooFewAttributes() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.add((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.add((Object)new Integer(1));
        SimpleFeature feature = this.builder.buildFeature("fid");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        SimpleFeatureBuilderTest.assertEquals((int)3, (int)feature.getAttributeCount());
        SimpleFeatureBuilderTest.assertTrue((boolean)gf.createPoint(new Coordinate(0.0, 0.0)).equals((Geometry)feature.getAttribute("point")));
        SimpleFeatureBuilderTest.assertEquals((Object)new Integer(1), (Object)feature.getAttribute("integer"));
        SimpleFeatureBuilderTest.assertNull((Object)feature.getAttribute("float"));
    }

    public void testSetSequential() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.set("point", (Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.set("integer", (Object)new Integer(1));
        this.builder.set("float", (Object)new Float(2.0));
        SimpleFeature feature = this.builder.buildFeature("fid");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        SimpleFeatureBuilderTest.assertEquals((int)3, (int)feature.getAttributeCount());
        SimpleFeatureBuilderTest.assertTrue((boolean)gf.createPoint(new Coordinate(0.0, 0.0)).equals((Geometry)feature.getAttribute(0)));
        SimpleFeatureBuilderTest.assertEquals((Object)new Integer(1), (Object)feature.getAttribute(1));
        SimpleFeatureBuilderTest.assertEquals((Object)new Float(2.0), (Object)feature.getAttribute(2));
    }

    public void testSetNonSequential() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        this.builder.set("float", (Object)new Float(2.0));
        this.builder.set("point", (Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        this.builder.set("integer", (Object)new Integer(1));
        SimpleFeature feature = this.builder.buildFeature("fid");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        SimpleFeatureBuilderTest.assertEquals((int)3, (int)feature.getAttributeCount());
        SimpleFeatureBuilderTest.assertTrue((boolean)gf.createPoint(new Coordinate(0.0, 0.0)).equals((Geometry)feature.getAttribute(0)));
        SimpleFeatureBuilderTest.assertEquals((Object)new Integer(1), (Object)feature.getAttribute(1));
        SimpleFeatureBuilderTest.assertEquals((Object)new Float(2.0), (Object)feature.getAttribute(2));
    }

    public void testSetTooFew() throws Exception {
        this.builder.set("integer", (Object)new Integer(1));
        SimpleFeature feature = this.builder.buildFeature("fid");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        SimpleFeatureBuilderTest.assertEquals((int)3, (int)feature.getAttributeCount());
        SimpleFeatureBuilderTest.assertNull((Object)feature.getAttribute(0));
        SimpleFeatureBuilderTest.assertEquals((Object)new Integer(1), (Object)feature.getAttribute(1));
        SimpleFeatureBuilderTest.assertNull((Object)feature.getAttribute(2));
    }

    public void testConverting() throws Exception {
        this.builder.set("integer", (Object)"1");
        SimpleFeature feature = this.builder.buildFeature("fid");
        try {
            this.builder.set("integer", (Object)"foo");
            SimpleFeatureBuilderTest.fail((String)"should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCreateFeatureWithLength() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.length(5).add("name", String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Val"}, (String)"ID");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        try {
            feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Longer Than 5"}, (String)"ID");
            feature.validate();
            SimpleFeatureBuilderTest.fail((String)"this should fail because the value is longer than 5 characters");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCreateFeatureWithRestriction() throws Exception {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        String attributeName = "string";
        PropertyIsEqualTo filter = fac.equals((Expression)fac.property("."), (Expression)fac.literal((Object)"Value"));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.restriction((Filter)filter).add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, (String)"ID");
        SimpleFeatureBuilderTest.assertNotNull((Object)feature);
        try {
            SimpleFeature sf = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"NotValue"}, (String)"ID");
            sf.validate();
            SimpleFeatureBuilderTest.fail((String)"PropertyIsEqualTo filter should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

