/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SimpleFeatureImplTest
extends TestCase {
    SimpleFeatureType schema;
    SimpleFeature feature;

    protected void setUp() throws Exception {
        super.setUp();
        this.schema = DataUtilities.createType((String)"buildings", (String)"the_geom:MultiPolygon,name:String,ADDRESS:String");
        Object[] objectArray = new Object[3];
        objectArray[1] = "ABC";
        objectArray[2] = "Random Road, 12";
        this.feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])objectArray, (String)"building.1");
    }

    public void testGetProperty() {
        SimpleFeatureImplTest.assertEquals((Object)"ABC", (Object)this.feature.getProperty("name").getValue());
        SimpleFeatureImplTest.assertNull((Object)this.feature.getProperty("NOWHERE"));
        SimpleFeatureImplTest.assertEquals((int)0, (int)this.feature.getProperties("NOWHERE").size());
    }

    public void testGetPropertyNullValue() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getProperty("the_geom"));
        SimpleFeatureImplTest.assertNull((Object)this.feature.getProperty("the_geom").getValue());
    }

    public void testGeometryPropertyType() {
        SimpleFeatureImplTest.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
    }

    public void testDefaultGeometryProperty() {
        SimpleFeatureImplTest.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getDefaultGeometryProperty());
        SimpleFeatureImplTest.assertNull((Object)this.feature.getDefaultGeometryProperty().getValue());
    }
}

