/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterTest;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class ExpressionTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.defaultcore");
    private static SimpleFeature testFeature = null;
    private static SimpleFeatureType testSchema = null;
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    boolean set = false;
    TestSuite suite = null;

    public ExpressionTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ExpressionTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ExpressionTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException, IllegalAttributeException {
        if (this.set) {
            return;
        }
        this.set = true;
        LOGGER.finer("creating flat feature...");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testZeroDouble", Double.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[10];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        attributes[0] = gf.createLineString(coords);
        attributes[1] = new Boolean(true);
        attributes[2] = new Character('t');
        attributes[3] = new Byte("10");
        attributes[4] = new Short("101");
        attributes[5] = new Integer(1002);
        attributes[6] = new Long(10003L);
        attributes[7] = new Float(10000.4);
        attributes[8] = new Double(100000.5);
        attributes[9] = "test string data";
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
        LOGGER.finer("...feature created");
    }

    public void testAttribute() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testInteger");
        LOGGER.fine("integer attribute expression equals: " + testAttribute.getValue(testFeature));
        ExpressionTest.assertEquals((Object)new Integer(1002), (Object)testAttribute.getValue(testFeature));
        testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LOGGER.fine("string attribute expression equals: " + testAttribute.getValue(testFeature));
        ExpressionTest.assertEquals((Object)"test string data", (Object)testAttribute.getValue(testFeature));
    }

    public void testAttributeObject() throws IllegalFilterException {
        FilterTest.MockDataObject testFeature = new FilterTest.MockDataObject(10, "diez");
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl("intVal");
        ExpressionTest.assertEquals((Object)new Integer(10), (Object)testAttribute.evaluate((Object)testFeature));
        testAttribute = new AttributeExpressionImpl("stringVal");
        ExpressionTest.assertEquals((Object)"diez", (Object)testAttribute.evaluate((Object)testFeature));
    }

    public void testLiteral() throws IllegalFilterException {
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl((Object)new Integer(1002));
        LOGGER.fine("integer literal expression equals: " + testLiteral.getValue(testFeature));
        ExpressionTest.assertEquals((Object)new Integer(1002), (Object)testLiteral.getValue(testFeature));
        testLiteral = new LiteralExpressionImpl("test string data");
        LOGGER.fine("string literal expression equals: " + testLiteral.getValue(testFeature));
        ExpressionTest.assertEquals((Object)"test string data", (Object)testLiteral.getValue(testFeature));
    }

    public void testLiteralObject() throws IllegalFilterException {
        FilterTest.MockDataObject testObj = new FilterTest.MockDataObject(1000, "mil");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl((Object)new Integer(1002));
        ExpressionTest.assertEquals((Object)new Integer(1002), (Object)testLiteral.evaluate((Object)testObj));
        testLiteral = new LiteralExpressionImpl("test string data");
        ExpressionTest.assertEquals((Object)"test string data", (Object)testLiteral.evaluate((Object)testObj));
    }

    public void testMinFunction() {
        PropertyName a = ff.property("testInteger");
        Literal b = ff.literal(1004.0);
        Function min = ff.function("min", new org.opengis.filter.expression.Expression[]{a, b});
    }

    public void testMinFunctionOld() throws IllegalFilterException {
        AttributeExpressionImpl a = new AttributeExpressionImpl(testSchema, "testInteger");
        LiteralExpressionImpl b = new LiteralExpressionImpl((Object)new Double(1004.0));
        Function min = ff.function("min", new org.opengis.filter.expression.Expression[]{a, b});
        Object value = min.evaluate((Object)testFeature);
        ExpressionTest.assertEquals((double)1002.0, (double)((Double)value), (double)0.0);
        b = ff.literal((Object)new Double(-100.001));
        min = ff.function("min", new org.opengis.filter.expression.Expression[]{a, b});
        value = min.evaluate((Object)testFeature);
        ExpressionTest.assertEquals((double)-100.001, (double)((Double)value), (double)0.0);
    }

    public void testNonExistentFunction() {
        try {
            Function nochance = ff.function("%$#%$%#%#$@#%@", new org.opengis.filter.expression.Expression[]{null});
            ExpressionTest.assertNull((Object)nochance);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testFunctionNameTrim() throws IllegalFilterException {
        Function min = ff.function("minFunction", new org.opengis.filter.expression.Expression[]{ff.literal(2), ff.literal(3)});
        ExpressionTest.assertTrue((min != null ? 1 : 0) != 0);
    }

    public void testMaxFunction() throws IllegalFilterException {
        AttributeExpressionImpl a = new AttributeExpressionImpl(testSchema, "testInteger");
        LiteralExpressionImpl b = new LiteralExpressionImpl((Object)new Double(1004.0));
        Function max = ff.function("max", new org.opengis.filter.expression.Expression[]{a, b});
        ExpressionTest.assertEquals((double)1004.0, (double)((Double)max.evaluate((Object)testFeature)), (double)0.0);
        b = new LiteralExpressionImpl((Object)new Double(-100.001));
        max = ff.function("max", new org.opengis.filter.expression.Expression[]{a, b});
        ExpressionTest.assertEquals((double)1002.0, (double)((Double)max.evaluate((Object)testFeature)), (double)0.0);
    }

    public void testMaxFunctionObject() throws IllegalFilterException {
        FilterTest.MockDataObject testObj = new FilterTest.MockDataObject(10, "diez");
        AttributeExpressionImpl a = new AttributeExpressionImpl("intVal");
        LiteralExpressionImpl b = new LiteralExpressionImpl((Object)new Double(1004.0));
        Function max = ff.function("max", new org.opengis.filter.expression.Expression[]{a, b});
        ExpressionTest.assertEquals((String)"max", (String)max.getName());
        Object maxValue = max.evaluate((Object)testObj);
        ExpressionTest.assertEquals((double)1004.0, (double)((Double)maxValue), (double)0.0);
        b = new LiteralExpressionImpl((Object)new Double(-100.001));
        max = ff.function("max", new org.opengis.filter.expression.Expression[]{a, b});
        maxValue = max.evaluate((Object)testObj);
        ExpressionTest.assertEquals((double)10.0, (double)((Double)maxValue), (double)0.0);
    }

    public void testIncompleteMathExpression() throws IllegalFilterException {
        LiteralExpressionImpl testAttribute1 = new LiteralExpressionImpl((Object)new Integer(4));
        AddImpl mathTest = new AddImpl(null, null);
        mathTest.addLeftValue((Expression)testAttribute1);
        try {
            mathTest.getValue(testFeature);
            ExpressionTest.fail((String)"math expressions should not work if right hand side is not set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        mathTest = new AddImpl(null, null);
        mathTest.addRightValue((Expression)testAttribute1);
        try {
            mathTest.getValue(testFeature);
            ExpressionTest.fail((String)"math expressions should not work if left hand side is not set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMath() throws IllegalFilterException {
        LiteralExpressionImpl testAttribute1 = new LiteralExpressionImpl((Object)new Integer(4));
        LiteralExpressionImpl testAttribute2 = new LiteralExpressionImpl((Object)new Integer(2));
        AddImpl mathTest = new AddImpl(null, null);
        mathTest.addLeftValue((Expression)testAttribute1);
        mathTest.addRightValue((Expression)testAttribute2);
        LOGGER.fine("math test: " + testAttribute1.getValue(testFeature) + " + " + testAttribute2.getValue(testFeature) + " = " + mathTest.getValue(testFeature));
        ExpressionTest.assertEquals((Object)new Integer(6), (Object)mathTest.evaluate((Object)testFeature, Integer.class));
        mathTest = new SubtractImpl(null, null);
        mathTest.addLeftValue((Expression)testAttribute1);
        mathTest.addRightValue((Expression)testAttribute2);
        LOGGER.fine("math test: " + testAttribute1.getValue(testFeature) + " - " + testAttribute2.getValue(testFeature) + " = " + mathTest.getValue(testFeature));
        ExpressionTest.assertEquals((Object)new Integer(2), (Object)mathTest.evaluate((Object)testFeature, Integer.class));
        mathTest = new MultiplyImpl(null, null);
        mathTest.addLeftValue((Expression)testAttribute1);
        mathTest.addRightValue((Expression)testAttribute2);
        LOGGER.fine("math test: " + testAttribute1.getValue(testFeature) + " * " + testAttribute2.getValue(testFeature) + " = " + mathTest.getValue(testFeature));
        ExpressionTest.assertEquals((Object)new Integer(8), (Object)mathTest.evaluate((Object)testFeature, Integer.class));
        mathTest = new DivideImpl(null, null);
        mathTest.addLeftValue((Expression)testAttribute1);
        mathTest.addRightValue((Expression)testAttribute2);
        LOGGER.fine("math test: " + testAttribute1.getValue(testFeature) + " / " + testAttribute2.getValue(testFeature) + " = " + mathTest.getValue(testFeature));
        ExpressionTest.assertEquals((Object)new Double(2.0), (Object)mathTest.getValue(testFeature));
    }

    public void testMathObject() throws IllegalFilterException {
        FilterTest.MockDataObject testObject = new FilterTest.MockDataObject(10, "diez");
        LiteralExpressionImpl testAttribute1 = new LiteralExpressionImpl((Object)new Integer(4));
        LiteralExpressionImpl testAttribute2 = new LiteralExpressionImpl((Object)new Integer(2));
        AddImpl mathTest = new AddImpl(null, null);
        mathTest.setExpression1((org.opengis.filter.expression.Expression)testAttribute1);
        mathTest.setExpression2((org.opengis.filter.expression.Expression)testAttribute2);
        ExpressionTest.assertEquals((Object)new Integer(6), (Object)mathTest.evaluate((Object)testObject, Integer.class));
        mathTest = new SubtractImpl(null, null);
        mathTest.setExpression1((org.opengis.filter.expression.Expression)testAttribute1);
        mathTest.setExpression2((org.opengis.filter.expression.Expression)testAttribute2);
        ExpressionTest.assertEquals((Object)new Integer(2), (Object)mathTest.evaluate((Object)testObject, Integer.class));
        mathTest = new MultiplyImpl(null, null);
        mathTest.setExpression1((org.opengis.filter.expression.Expression)testAttribute1);
        mathTest.setExpression2((org.opengis.filter.expression.Expression)testAttribute2);
        ExpressionTest.assertEquals((Object)new Integer(8), (Object)mathTest.evaluate((Object)testObject, Integer.class));
        mathTest = new DivideImpl(null, null);
        mathTest.setExpression1((org.opengis.filter.expression.Expression)testAttribute1);
        mathTest.setExpression2((org.opengis.filter.expression.Expression)testAttribute2);
        ExpressionTest.assertEquals((Object)new Double(2.0), (Object)mathTest.evaluate((Object)testObject));
    }
}

