/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;

public class EnvFunctionTest {
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @After
    public void tearDown() {
        EnvFunction.clearGlobalValues();
        EnvFunction.clearLocalValues();
    }

    @Test
    public void testSetLocalValues() throws Exception {
        System.out.println("   setLocalValues");
        String key1 = "foo";
        String key2 = "bar";
        HashMap<String, Integer> table0 = new HashMap<String, Integer>();
        table0.put("foo", 1);
        table0.put("bar", 2);
        HashMap<String, Integer> table1 = new HashMap<String, Integer>();
        table1.put("foo", 10);
        table1.put("bar", 20);
        ArrayList<HashMap<String, Integer>> tables = new ArrayList<HashMap<String, Integer>>();
        tables.add(table0);
        tables.add(table1);
        CountDownLatch latch = new CountDownLatch(2);
        class Task
        implements Runnable {
            private final int threadIndex;
            private final /* synthetic */ List val$tables;
            private final /* synthetic */ CountDownLatch val$latch;

            public Task(int threadIndex, List list, CountDownLatch countDownLatch) {
                this.val$tables = list;
                this.val$latch = countDownLatch;
                this.threadIndex = threadIndex;
            }

            public void run() {
                EnvFunction.setLocalValues((Map)((Map)this.val$tables.get(this.threadIndex)));
                this.val$latch.countDown();
                try {
                    this.val$latch.await();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                Map table = (Map)this.val$tables.get(this.threadIndex);
                for (String name : table.keySet()) {
                    Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)name)}).evaluate(null);
                    int value = ((Number)result).intValue();
                    Assert.assertEquals(table.get(name), (Object)value);
                }
            }
        }
        Future<?> f1 = this.executor.submit(new Task(0, tables, latch));
        Future<?> f2 = this.executor.submit(new Task(1, tables, latch));
        f1.get();
        f2.get();
    }

    @Test
    public void testSetLocalValue() throws Exception {
        System.out.println("   setLocalValue");
        String varName = "foo";
        int[] values = new int[]{1, 2};
        CountDownLatch latch = new CountDownLatch(2);
        class Task
        implements Runnable {
            private final int threadIndex;
            private final /* synthetic */ int[] val$values;
            private final /* synthetic */ CountDownLatch val$latch;

            public Task(int threadIndex, int[] nArray, CountDownLatch countDownLatch) {
                this.val$values = nArray;
                this.val$latch = countDownLatch;
                this.threadIndex = threadIndex;
            }

            public void run() {
                EnvFunction.setLocalValue((String)"foo", (Object)this.val$values[this.threadIndex]);
                this.val$latch.countDown();
                try {
                    this.val$latch.await();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)"foo")}).evaluate(null);
                int value = ((Number)result).intValue();
                Assert.assertEquals((long)this.val$values[this.threadIndex], (long)value);
            }
        }
        Future<?> f1 = this.executor.submit(new Task(0, values, latch));
        Future<?> f2 = this.executor.submit(new Task(1, values, latch));
        f1.get();
        f2.get();
    }

    @Test
    public void testSetGlobalValues() throws Exception {
        System.out.println("   setGlobalValues");
        HashMap<String, Integer> table = new HashMap<String, Integer>();
        table.put("foo", 1);
        table.put("bar", 2);
        EnvFunction.setGlobalValues(table);
        CountDownLatch latch = new CountDownLatch(2);
        class Task
        implements Runnable {
            final String key;
            private final /* synthetic */ Map val$table;
            private final /* synthetic */ CountDownLatch val$latch;

            Task(String key, Map map, CountDownLatch countDownLatch) {
                this.val$table = map;
                this.val$latch = countDownLatch;
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException("Invalid arg " + key);
                }
                this.key = key;
            }

            public void run() {
                EnvFunction.setGlobalValue((String)this.key, this.val$table.get(this.key));
                this.val$latch.countDown();
                try {
                    this.val$latch.await();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                for (String name : this.val$table.keySet()) {
                    Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)name)}).evaluate(null);
                    int value = ((Number)result).intValue();
                    Assert.assertEquals(this.val$table.get(name), (Object)value);
                }
            }
        }
        Future<?> f1 = this.executor.submit(new Task("foo", table, latch));
        Future<?> f2 = this.executor.submit(new Task("bar", table, latch));
        f1.get();
        f2.get();
    }

    @Test
    public void testSetGlobalValue() throws Exception {
        System.out.println("   setGlobalValue");
        String varName = "foo";
        String varValue = "a global value";
        EnvFunction.setGlobalValue((String)"foo", (Object)"a global value");
        class Task
        implements Runnable {
            Task() {
            }

            public void run() {
                Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)"foo")}).evaluate(null);
                Assert.assertEquals((Object)"a global value", (Object)result.toString());
            }
        }
        Future<?> f1 = this.executor.submit(new Task());
        Future<?> f2 = this.executor.submit(new Task());
        f1.get();
        f2.get();
    }

    @Test
    public void testCaseInsensitiveGlobalLookup() {
        System.out.println("   test case-insensitive global lookup");
        String varName = "foo";
        String altVarName = "FoO";
        String varValue = "globalCaseTest";
        EnvFunction.setGlobalValue((String)"foo", (Object)"globalCaseTest");
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"FoO")}).evaluate(null);
        Assert.assertEquals((Object)"globalCaseTest", (Object)result.toString());
    }

    @Test
    public void testCaseInsensitiveLocalLookup() {
        System.out.println("   test case-insensitive local lookup");
        String varName = "foo";
        String altVarName = "FoO";
        String varValue = "localCaseTest";
        EnvFunction.setLocalValue((String)"foo", (Object)"localCaseTest");
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"FoO")}).evaluate(null);
        Assert.assertEquals((Object)"localCaseTest", (Object)result.toString());
    }

    @Test
    public void testClearGlobal() {
        System.out.println("   clearGlobalValues");
        String varName = "foo";
        String varValue = "clearGlobal";
        EnvFunction.setGlobalValue((String)"foo", (Object)"clearGlobal");
        EnvFunction.clearGlobalValues();
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}).evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testClearLocal() {
        System.out.println("   clearLocalValues");
        String varName = "foo";
        String varValue = "clearLocal";
        EnvFunction.setLocalValue((String)"foo", (Object)"clearLocal");
        EnvFunction.clearLocalValues();
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}).evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetArgCount() {
        System.out.println("   getArgCount");
        EnvFunction fn = new EnvFunction();
        Assert.assertEquals((long)1L, (long)fn.getArgCount());
    }

    @Test
    public void testLiteralDefaultValue() {
        System.out.println("   literal default value");
        int defaultValue = 42;
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"doesnotexist"), this.ff.literal(defaultValue)}).evaluate(null);
        int value = ((Number)result).intValue();
        Assert.assertEquals((long)defaultValue, (long)value);
    }

    @Test
    public void testNonLiteralDefaultValue() {
        System.out.println("   non-literal default value");
        int x = 21;
        Add defaultExpr = this.ff.add((Expression)this.ff.literal(x), (Expression)this.ff.literal(x));
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"doesnotexist"), defaultExpr}).evaluate(null);
        int value = ((Number)result).intValue();
        Assert.assertEquals((long)(x + x), (long)value);
    }

    @Test
    public void testSetFallbackNotAllowed() {
        Logger logger = Logger.getLogger(EnvFunction.class.getName());
        SimpleFormatter formatter = new SimpleFormatter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamHandler handler = new StreamHandler(out, formatter);
        logger.addHandler(handler);
        try {
            EnvFunction function = new EnvFunction();
            function.setFallbackValue(this.ff.literal(0));
            ((Handler)handler).flush();
            String logMsg = out.toString();
            Assert.assertNotNull((Object)logMsg);
            Assert.assertTrue((boolean)logMsg.toLowerCase().contains("setfallbackvalue"));
        }
        finally {
            logger.removeHandler(handler);
        }
    }
}

