/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.JenksNaturalBreaksFunction;
import org.geotools.filter.function.RangedClassifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class JenksFunctionTest
extends FunctionTestSupport {
    public JenksFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JenksFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function equInt = this.ff.function("Jenks", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        JenksFunctionTest.assertNotNull((Object)equInt);
    }

    public void testGetName() {
        Function qInt = this.ff.function("Jenks", new Expression[]{this.ff.literal((Object)FeatureCollections.newCollection())});
        JenksFunctionTest.assertEquals((String)"Jenks", (String)qInt.getName());
    }

    public void testSetParameters() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName expr = this.ff.property("foo");
        JenksNaturalBreaksFunction func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        JenksFunctionTest.assertEquals((int)3, (int)func.getClasses());
        classes = this.ff.literal(12);
        func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        JenksFunctionTest.assertEquals((int)12, (int)func.getClasses());
        classes = this.ff.literal(5);
        func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        JenksFunctionTest.assertEquals((int)5, (int)func.getClasses());
    }

    public void testEvaluateRealData() throws Exception {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("jenks71");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.jenksCollection);
        JenksFunctionTest.assertNotNull((Object)value);
        JenksFunctionTest.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        JenksFunctionTest.assertEquals((int)5, (int)ranged.getSize());
        JenksFunctionTest.assertEquals((String)"15.57..41.2", (String)ranged.getTitle(0));
        JenksFunctionTest.assertEquals((String)"41.2..60.66", (String)ranged.getTitle(1));
        JenksFunctionTest.assertEquals((String)"60.66..77.29", (String)ranged.getTitle(2));
        JenksFunctionTest.assertEquals((String)"77.29..100.1", (String)ranged.getTitle(3));
        JenksFunctionTest.assertEquals((String)"100.1..155.3", (String)ranged.getTitle(4));
    }

    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.featureCollection);
        JenksFunctionTest.assertNotNull((Object)value);
        JenksFunctionTest.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        JenksFunctionTest.assertEquals((int)2, (int)ranged.getSize());
        JenksFunctionTest.assertEquals((String)"4..29", (String)ranged.getTitle(0));
        JenksFunctionTest.assertEquals((String)"29..90", (String)ranged.getTitle(1));
    }

    public void testSingleBin() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        int i = 0;
        while (i < iVal.length) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{new Integer(i + 1), new Integer(iVal[i])}, (String)("classification.test1" + (i + 1)));
            ++i;
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(dataType);
        store.addFeatures(myfeatures);
        SimpleFeatureCollection myFeatureCollection = store.getFeatureSource("test1").getFeatures();
        Function function = this.ff.function("Jenks", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        JenksFunctionTest.assertNotNull((Object)classifier);
        JenksFunctionTest.assertEquals(classifier.getClass(), RangedClassifier.class);
        RangedClassifier range = (RangedClassifier)classifier;
        JenksFunctionTest.assertEquals((int)5, (int)range.getSize());
        int i2 = 0;
        while (i2 < 5) {
            JenksFunctionTest.assertTrue(((double)(i2 + 1) == ((Number)range.getMin(i2)).doubleValue() ? 1 : 0) != 0);
            if (i2 != 4) {
                JenksFunctionTest.assertEquals((String)"wrong value for max", (int)(i2 + 2), (int)((Number)range.getMax(i2)).intValue());
                JenksFunctionTest.assertEquals((String)"bad title", (String)(String.valueOf(i2 + 1) + ".." + (i2 + 2)), (String)range.getTitle(i2));
            } else {
                JenksFunctionTest.assertEquals((String)"wrong value for max", (int)(i2 + 1), (int)((Number)range.getMax(i2)).intValue());
                JenksFunctionTest.assertEquals((String)"bad title", (String)(String.valueOf(i2 + 1) + ".." + (i2 + 1)), (String)range.getTitle(i2));
            }
            ++i2;
        }
    }

    public void test2() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5, 6};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        int i = 0;
        while (i < iVal.length) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{new Integer(i + 1), new Integer(iVal[i])}, (String)("classification.t" + (i + 1)));
            ++i;
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(dataType);
        store.addFeatures(myfeatures);
        SimpleFeatureCollection myFeatureCollection = store.getFeatureSource("test1").getFeatures();
        Function function = this.ff.function("Jenks", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        RangedClassifier range = (RangedClassifier)classifier;
    }

    public void xtestNullNaNHandling() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"classification.nullnan", (String)"id:0,foo:int,bar:double");
        Integer[] integerArray = new Integer[9];
        integerArray[0] = new Integer(0);
        integerArray[1] = new Integer(0);
        integerArray[2] = new Integer(0);
        integerArray[3] = new Integer(13);
        integerArray[4] = new Integer(13);
        integerArray[5] = new Integer(13);
        Integer[] iVal = integerArray;
        Double[] doubleArray = new Double[9];
        doubleArray[0] = new Double(0.0);
        doubleArray[1] = new Double(50.01);
        doubleArray[3] = new Double(0.0);
        doubleArray[4] = new Double(50.01);
        doubleArray[6] = new Double(0.0);
        doubleArray[7] = new Double(50.01);
        Double[] dVal = doubleArray;
        SimpleFeature[] testFeatures = new SimpleFeature[iVal.length];
        int i = 0;
        while (i < iVal.length) {
            testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{new Integer(i + 1), iVal[i], dVal[i]}, (String)("nantest.t" + (i + 1)));
            ++i;
        }
        MemoryDataStore store = new MemoryDataStore();
        store.createSchema(ft);
        store.addFeatures(testFeatures);
        SimpleFeatureCollection thisFC = store.getFeatureSource("nullnan").getFeatures();
        Divide divide = this.ff.divide((Expression)this.ff.property("foo"), (Expression)this.ff.property("bar"));
        JenksNaturalBreaksFunction qf = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{divide, this.ff.literal(3)});
        RangedClassifier range = (RangedClassifier)qf.evaluate((Object)thisFC);
        JenksFunctionTest.assertEquals((int)3, (int)range.getSize());
        JenksFunctionTest.assertEquals((String)"0..0", (String)range.getTitle(0));
        JenksFunctionTest.assertEquals((String)"0..0", (String)range.getTitle(1));
    }
}

