/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeometryClipperTest {
    static final double EPS = 0.001;
    static final double EPS_CORNERS = 0.1;
    GeometryClipper clipper;
    Geometry boundsPoly;
    WKTReader wkt;

    @Before
    public void setUp() throws Exception {
        this.clipper = new GeometryClipper(new Envelope(0.0, 10.0, 0.0, 10.0));
        this.wkt = new WKTReader();
        this.boundsPoly = this.wkt.read("POLYGON((0 0, 0 10, 10 10, 10 0, 0 0))");
    }

    @Test
    public void testFullyInside() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(1 1, 2 5, 9 1)");
        LineString clipped = (LineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)ls.equals((Geometry)clipped));
        this.showResult("Fully inside", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testInsideBorders() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(0 0, 2 5, 10 0)");
        LineString clipped = (LineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)ls.equals((Geometry)clipped));
        this.showResult("Inside touching borders", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testFullyOutside() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-5 0, -5 15, 15 15)");
        LineString clipped = (LineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertNull((Object)clipped);
        this.showResult("Inside touching borders", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testCross() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-5 -5, 15 15)");
        LineString clipped = (LineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("LINESTRING(0 0, 10 10)")));
        this.showResult("Cross", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testTouchLine() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(0 0, 0 10)");
        LineString clipped = (LineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)clipped.equals((Geometry)ls));
        this.showResult("Touch border", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testTouchPoint() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-5 5, 0 5)");
        Geometry clipped = this.clipper.clip((Geometry)ls, false);
        Assert.assertNull((Object)clipped);
        this.showResult("Touch point", (Geometry)ls, clipped);
    }

    @Test
    public void testMultiTouch() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-5 0, 0 1, -5 2, 0 3, -5 4, 0 5)");
        Geometry clipped = this.clipper.clip((Geometry)ls, false);
        Assert.assertNull((Object)clipped);
        this.showResult("Multitouch", (Geometry)ls, clipped);
    }

    @Test
    public void testTouchAndCross() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-5 0, 0 1, -5 2, 5 2, 5 3, -5 3, 0 4)");
        Geometry clipped = this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("LINESTRING(0 2, 5 2, 5 3, 0 3)")));
        this.showResult("Touch and cross", (Geometry)ls, clipped);
    }

    @Test
    public void testTouchAndParallel() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-5 0, 0 1, -5 2, 0 2, 0 3, -5 3, 0 4)");
        Geometry clipped = this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("LINESTRING(0 2, 0 3)")));
        this.showResult("Touch and parallel", (Geometry)ls, clipped);
    }

    @Test
    public void testInsideOut() throws Exception {
        LineString ls = (LineString)this.wkt.read("LINESTRING(-2 8, 12 8, 12 2, -2 2)");
        MultiLineString clipped = (MultiLineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("MULTILINESTRING((0 8, 10 8), (10 2, 0 2))")));
        this.showResult("Touch border", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testFullyOutsideCircle() throws Exception {
        Point p = (Point)this.wkt.read("POINT(5 5)");
        LineString ls = ((Polygon)p.buffer(10.0)).getExteriorRing();
        Geometry clipped = this.clipper.clip((Geometry)ls, false);
        Assert.assertNull((Object)clipped);
        this.showResult("Circle around", (Geometry)ls, clipped);
    }

    @Test
    public void testCrossingCircle() throws Exception {
        Point p = (Point)this.wkt.read("POINT(5 5)");
        LineString ls = ((Polygon)p.buffer(6.0)).getExteriorRing();
        MultiLineString clipped = (MultiLineString)this.clipper.clip((Geometry)ls, false);
        Assert.assertEquals((long)4L, (long)clipped.getNumGeometries());
        this.showResult("Circle around", (Geometry)ls, (Geometry)clipped);
    }

    @Test
    public void testInsidePolygon() throws Exception {
        Geometry g = this.wkt.read("POINT(5 5)").buffer(2.0);
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertTrue((boolean)g.equals(clipped));
        this.showResult("Polygon inside", g, clipped);
    }

    @Test
    public void testOutsidePolygon() throws Exception {
        Geometry g = this.wkt.read("POINT(5 5)").buffer(10.0);
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertTrue((boolean)this.boundsPoly.equals(clipped));
        this.showResult("Polygon outside", g, clipped);
    }

    @Test
    public void testPolygonCrossingSide() throws Exception {
        Geometry g = this.wkt.read("POLYGON((-2 2, 2 2, 2 4, -2 4, -2 2))");
        Geometry clipped = this.clipper.clip(g, false);
        this.showResult("Crossing side", g, clipped);
    }

    @Test
    public void testCrossingOtherSide() throws Exception {
        Geometry g = this.wkt.read("POLYGON((6 2, 12 2, 12 6, 6 6, 6 2))");
        Geometry clipped = this.clipper.clip(g, false);
        this.showResult("Donut crossing", g, clipped);
    }

    @Test
    public void testPolygonCrossingTwoSides() throws Exception {
        Geometry g = this.wkt.read("POLYGON((-2 2, 2 2, 2 12, -2 12, -2 2))");
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("POLYGON((0 2, 2 2, 2 10, 0 10, 0 2))")));
        this.showResult("Crossing two sides", g, clipped);
    }

    @Test
    public void testPolygonCrossingThreeSides() throws Exception {
        Geometry g = this.wkt.read("POLYGON((-2 2, 12 2, 12 12, -2 12, -2 2))");
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("POLYGON((0 2, 10 2, 10 10, 0 10, 0 2))")));
        this.showResult("Crossing three sides", g, clipped);
    }

    @Test
    public void testDonutCrossingInvalid() throws Exception {
        Geometry g = this.wkt.read("POLYGON((6 2, 14 2, 14 8, 6 8, 6 2), (8 4, 12 4, 12 6, 8 6, 8 4))");
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertTrue((boolean)clipped.equalsExact(this.wkt.read("POLYGON ((10 2, 10 8, 6 8, 6 2, 10 2), (10 4, 10 6, 8 6, 8 4, 10 4))")));
        this.showResult("Donut crossing, invalid geom", g, clipped);
    }

    @Test
    public void testDonutHoleOutside() throws Exception {
        Geometry g = this.wkt.read("POLYGON((6 2, 14 2, 14 8, 6 8, 6 2), (11 4, 12 4, 12 6, 11 6, 11 4))");
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertTrue((boolean)clipped.equalsExact(this.wkt.read("POLYGON ((10 2, 10 8, 6 8, 6 2, 10 2))")));
        this.showResult("Donut crossing, invalid geom", g, clipped);
    }

    @Test
    public void testDonutCrossingValid() throws Exception {
        Geometry g = this.wkt.read("POLYGON((6 2, 14 2, 14 8, 6 8, 6 2), (8 4, 12 4, 12 6, 8 6, 8 4))");
        Geometry clipped = this.clipper.clip(g, true);
        Assert.assertTrue((boolean)clipped.equals(this.wkt.read("POLYGON ((10 2, 6 2, 6 8, 10 8, 10 6, 8 6, 8 4, 10 4, 10 2))")));
        this.showResult("Donut crossing, valid geom", g, clipped);
    }

    @Test
    public void testGeotXYWZ() throws Exception {
        this.clipper = new GeometryClipper(new Envelope(-11.0, 761.0, -11.0, 611.0));
        Geometry g = this.wkt.read("POLYGON((367 -13, 459 105, 653 -42, 611 -96, 562 -60, 514 -124, 367 -13))");
        System.out.println(g.getNumPoints());
        Geometry clipped = this.clipper.clip(g, false);
        Assert.assertNotNull((Object)clipped);
        Assert.assertTrue((!clipped.isEmpty() ? 1 : 0) != 0);
    }

    public void showResult(String title, Geometry original, Geometry clipped) throws Exception {
        String headless = System.getProperty("java.awt.headless", "false");
        if (headless.equalsIgnoreCase("true") || !TestData.isInteractiveTest()) {
            return;
        }
        BufferedImage image = new BufferedImage(600, 600, 5);
        Graphics2D gr = image.createGraphics();
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setColor(Color.WHITE);
        gr.fillRect(0, 0, image.getWidth(), image.getHeight());
        gr.setColor(Color.LIGHT_GRAY);
        gr.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
        gr.draw(new Line2D.Double(0.0, 300.0, 600.0, 300.0));
        gr.draw(new Line2D.Double(300.0, 0.0, 300.0, 600.0));
        AffineTransform at = new AffineTransform();
        at.translate(300.0, 300.0);
        at.scale(10.0, -10.0);
        gr.setStroke(new BasicStroke(1.0f));
        gr.setColor(Color.LIGHT_GRAY);
        gr.draw((Shape)new LiteShape(this.boundsPoly, at, false));
        gr.setStroke(new BasicStroke(0.5f));
        gr.setColor(Color.BLUE);
        gr.draw((Shape)new LiteShape(original, at, false));
        if (clipped != null) {
            gr.setStroke(new BasicStroke(2.0f));
            if (clipped instanceof Polygon || clipped instanceof MultiPolygon) {
                gr.setColor(Color.LIGHT_GRAY);
                gr.fill((Shape)new LiteShape(clipped, at, false));
                gr.setColor(Color.BLUE);
            }
            gr.draw((Shape)new LiteShape(clipped, at, false));
        }
        gr.dispose();
        JFrame frame = new JFrame(title);
        frame.setContentPane(new JLabel(new ImageIcon(image)));
        frame.pack();
        frame.setVisible(true);
        Thread.sleep(3000L);
        frame.setVisible(false);
    }
}

