/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.io.WKTReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.GeometryCollector;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;

public class GeometryCollectorTest {
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);

    @Test
    public void testCollectNull() {
        GeometryCollector collector = new GeometryCollector();
        collector.add(null);
        GeometryCollection result = collector.collect();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testCollectNone() {
        GeometryCollector collector = new GeometryCollector();
        GeometryCollection result = collector.collect();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testTwo() throws Exception {
        WKTReader reader = new WKTReader();
        GeometryCollector collector = new GeometryCollector();
        collector.setFactory(null);
        Geometry p0 = reader.read("POINT(0 0)");
        collector.add(p0);
        Geometry p1 = reader.read("POINT(1 1)");
        collector.add(p1);
        GeometryCollection result = collector.collect();
        Assert.assertEquals((long)2L, (long)result.getNumGeometries());
        Assert.assertSame((Object)p0, (Object)result.getGeometryN(0));
        Assert.assertSame((Object)p1, (Object)result.getGeometryN(1));
    }

    @Test
    public void testTooMany() throws Exception {
        WKTReader reader = new WKTReader();
        GeometryCollector collector = new GeometryCollector();
        collector.setMaxCoordinates(1L);
        Geometry p0 = reader.read("POINT(0 0)");
        collector.add(p0);
        Geometry p1 = reader.read("POINT(1 1)");
        try {
            collector.add(p1);
            Assert.fail((String)"Should have complained about too many coordinates");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

