/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.geom.AffineTransform;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.referencing.wkt.Parser;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class JTSTest
extends TestCase {
    private static final double EPS = 1.0E-6;
    static final String UTM_ZONE_10N = "PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\",6378137,298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\",0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n    PARAMETER[\"False_Easting\",500000],\n    PARAMETER[\"False_Northing\",0],\n    PARAMETER[\"Central_Meridian\",-123],\n    PARAMETER[\"Scale_Factor\",0.9996],\n    PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]";
    static final String NAD83_BC = "PROJCS[\"NAD83 / BC Albers\",\n  GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",\n    SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],\n    TOWGS84[0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],\n    PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],\n    AUTHORITY[\"EPSG\",\"4269\"]],\n  PROJECTION[\"Albers_Conic_Equal_Area\"],\n  PARAMETER[\"standard_parallel_1\",50],\n  PARAMETER[\"standard_parallel_2\",58.5],\n  PARAMETER[\"latitude_of_center\",45],\n  PARAMETER[\"longitude_of_center\",-126],\n  PARAMETER[\"false_easting\",1000000],\n  PARAMETER[\"false_northing\",0],\n  UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],\n  AUTHORITY[\"EPSG\",\"3005\"]]";

    public static void main(String[] args) {
        Logging.GEOTOOLS.forceMonolineConsoleOutput();
        TestRunner.run((Test)JTSTest.suite());
    }

    public static Test suite() {
        return new TestSuite(JTSTest.class);
    }

    public void testJTSFactory() {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        JTSTest.assertNotNull((Object)gf);
    }

    public void testTransformCoordinate() throws FactoryException, TransformException {
        Coordinate coord = new Coordinate(10.0, 10.0);
        AffineTransform at = AffineTransform.getScaleInstance(0.5, 1.0);
        MathTransform2D t = (MathTransform2D)ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)new GeneralMatrix(at));
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t);
        JTSTest.assertEquals((Object)new Coordinate(5.0, 10.0), (Object)coord);
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t.inverse());
        JTSTest.assertEquals((Object)new Coordinate(10.0, 10.0), (Object)coord);
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(UTM_ZONE_10N);
        t = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs).getMathTransform();
        coord = new Coordinate(-123.0, 55.0);
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t);
        coord = JTS.transform((Coordinate)coord, (Coordinate)coord, (MathTransform)t.inverse());
        JTSTest.assertEquals((double)-123.0, (double)coord.x, (double)1.0E-6);
        JTSTest.assertEquals((double)55.0, (double)coord.y, (double)1.0E-6);
    }

    public void testTransformEnvelopeMathTransform() throws FactoryException, TransformException {
        Envelope envelope = new Envelope(0.0, 10.0, 0.0, 10.0);
        AffineTransform at = AffineTransform.getScaleInstance(0.5, 1.0);
        MathTransform2D t = (MathTransform2D)ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)new GeneralMatrix(at));
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t);
        JTSTest.assertEquals((Object)new Envelope(0.0, 5.0, 0.0, 10.0), (Object)envelope);
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t.inverse());
        JTSTest.assertEquals((Object)new Envelope(0.0, 10.0, 0.0, 10.0), (Object)envelope);
        envelope = JTS.transform((Envelope)envelope, null, (MathTransform)t, (int)10);
        JTSTest.assertEquals((Object)new Envelope(0.0, 5.0, 0.0, 10.0), (Object)envelope);
        envelope = JTS.transform((Envelope)envelope, null, (MathTransform)t.inverse(), (int)10);
        JTSTest.assertEquals((Object)new Envelope(0.0, 10.0, 0.0, 10.0), (Object)envelope);
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(UTM_ZONE_10N);
        t = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs).getMathTransform();
        envelope = new Envelope(-123.0, -133.0, 55.0, 60.0);
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t);
        envelope = JTS.transform((Envelope)envelope, (MathTransform)t.inverse());
        JTSTest.assertEquals((double)-133.0, (double)envelope.getMinX(), (double)1.5);
        JTSTest.assertEquals((double)-123.0, (double)envelope.getMaxX(), (double)1.0E-6);
        JTSTest.assertEquals((double)55.0, (double)envelope.getMinY(), (double)0.5);
        JTSTest.assertEquals((double)60.0, (double)envelope.getMaxY(), (double)0.5);
    }

    public void testOrthodromicDistance() throws Exception {
        Parser parser = new Parser();
        DefaultProjectedCRS crs = (DefaultProjectedCRS)parser.parseObject(NAD83_BC);
        double d = JTS.orthodromicDistance((Coordinate)new Coordinate(1402848.193853467, 651571.1729878788), (Coordinate)new Coordinate(1389481.3104009738, 641990.9430108378), (CoordinateReferenceSystem)crs);
        double realValue = 16451.33114;
        JTSTest.assertEquals((double)realValue, (double)d, (double)0.1);
    }

    public void testCheckCoordinateRange() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        JTS.checkCoordinatesRange((Geometry)JTS.toGeometry((Envelope)new Envelope(-10.0, 10.0, -10.0, 10.0)), (CoordinateReferenceSystem)crs);
        try {
            JTS.checkCoordinatesRange((Geometry)JTS.toGeometry((Envelope)new Envelope(-10.0, 10.0, -100.0, 10.0)), (CoordinateReferenceSystem)crs);
            JTSTest.fail((String)"Provided invalid coordinates, yet check did not throw an exception");
        }
        catch (PointOutsideEnvelopeException pointOutsideEnvelopeException) {
            // empty catch block
        }
        try {
            JTS.checkCoordinatesRange((Geometry)JTS.toGeometry((Envelope)new Envelope(-190.0, 10.0, -10.0, 10.0)), (CoordinateReferenceSystem)crs);
            JTSTest.fail((String)"Provided invalid coordinates, yet check did not throw an exception");
        }
        catch (PointOutsideEnvelopeException pointOutsideEnvelopeException) {
            // empty catch block
        }
    }
}

