/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import junit.framework.TestCase;
import org.geotools.gml.producer.CoordinateWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class CoordinateWriterTest
extends TestCase {
    public void test2DCoordSeq() throws Exception {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 1;
        CoordinateArraySequence coords = new CoordinateArraySequence(this.coords2D(nArray));
        CoordinateWriter writer = new CoordinateWriter(4);
        CoordinateHandler output = new CoordinateHandler();
        output.startDocument();
        writer.writeCoordinates((CoordinateSequence)coords, (ContentHandler)output);
        output.endDocument();
        CoordinateWriterTest.assertEquals((String)"<coordinates>1,1 4,4 0,4 1,1</coordinates>", (String)output.received);
    }

    public void test2D() throws Exception {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 1;
        Coordinate[] coords = this.coords2D(nArray);
        CoordinateWriterTest.assertNotNull((Object)coords);
        CoordinateWriterTest.assertEquals((int)4, (int)coords.length);
        CoordinateWriter writer = new CoordinateWriter(4);
        CoordinateHandler output = new CoordinateHandler();
        output.startDocument();
        writer.writeCoordinates(coords, (ContentHandler)output);
        output.endDocument();
        CoordinateWriterTest.assertEquals((String)"<coordinates>1,1 4,4 0,4 1,1</coordinates>", (String)output.received);
        System.out.println(output.received);
    }

    public void test2DWithDummyZ() throws Exception {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 1;
        Coordinate[] coords = this.coords2D(nArray);
        CoordinateWriterTest.assertNotNull((Object)coords);
        CoordinateWriterTest.assertEquals((int)4, (int)coords.length);
        boolean useDummyZ = true;
        double zValue = 0.0;
        CoordinateWriter writer = new CoordinateWriter(4, " ", ",", true, 0.0);
        CoordinateHandler output = new CoordinateHandler();
        output.startDocument();
        writer.writeCoordinates(coords, (ContentHandler)output);
        output.endDocument();
        System.out.println(output.received);
        CoordinateWriterTest.assertEquals((String)"<coordinates>1,1,0 4,4,0 0,4,0 1,1,0</coordinates>", (String)output.received);
    }

    public void test2DWithDummyZCoordSeq() throws Exception {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[5] = 4;
        nArray[6] = 1;
        nArray[7] = 1;
        CoordinateArraySequence coords = new CoordinateArraySequence(this.coords2D(nArray));
        boolean useDummyZ = true;
        double zValue = 0.0;
        CoordinateWriter writer = new CoordinateWriter(4, " ", ",", true, 0.0);
        CoordinateHandler output = new CoordinateHandler();
        output.startDocument();
        writer.writeCoordinates((CoordinateSequence)coords, (ContentHandler)output);
        output.endDocument();
        CoordinateWriterTest.assertEquals((String)"<coordinates>1,1,0 4,4,0 0,4,0 1,1,0</coordinates>", (String)output.received);
    }

    public void test3D() throws Exception {
        int[] nArray = new int[12];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 2;
        nArray[7] = 4;
        nArray[8] = 2;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 3;
        Coordinate[] coords = this.coords3D(nArray);
        CoordinateWriterTest.assertNotNull((Object)coords);
        CoordinateWriterTest.assertEquals((int)4, (int)coords.length);
        CoordinateWriter writer = new CoordinateWriter(4, " ", ",", true, 0.0, 3);
        CoordinateHandler output = new CoordinateHandler();
        output.startDocument();
        writer.writeCoordinates(coords, (ContentHandler)output);
        output.endDocument();
        CoordinateWriterTest.assertEquals((String)"<coordinates>1,1,3 4,4,2 0,4,2 1,1,3</coordinates>", (String)output.received);
        System.out.println(output.received);
    }

    public void test3DCoordSeq() throws Exception {
        int[] nArray = new int[12];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 2;
        nArray[7] = 4;
        nArray[8] = 2;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 3;
        CoordinateArraySequence coords = new CoordinateArraySequence(this.coords3D(nArray));
        CoordinateWriter writer = new CoordinateWriter(4, " ", ",", true, 0.0, 3);
        CoordinateHandler output = new CoordinateHandler();
        output.startDocument();
        writer.writeCoordinates((CoordinateSequence)coords, (ContentHandler)output);
        output.endDocument();
        System.out.println(output.received);
        CoordinateWriterTest.assertEquals((String)"<coordinates>1,1,3 4,4,2 0,4,2 1,1,3</coordinates>", (String)output.received);
    }

    Coordinate[] coords2D(int[] array) {
        Coordinate[] coords = new Coordinate[array.length / 2];
        int i = 0;
        while (i < coords.length) {
            int offset = i * 2;
            coords[i] = new Coordinate((double)array[offset + 0], (double)array[offset + 1]);
            ++i;
        }
        return coords;
    }

    Coordinate[] coords3D(int[] array) {
        Coordinate[] coords = new Coordinate[array.length / 3];
        int i = 0;
        while (i < coords.length) {
            int offset = i * 3;
            coords[i] = new Coordinate((double)array[offset + 0], (double)array[offset + 1], (double)array[offset + 2]);
            ++i;
        }
        return coords;
    }

    class CoordinateHandler
    implements ContentHandler {
        StringBuffer buffer;
        String received;

        CoordinateHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(new String(ch, start, length));
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.buffer.append("</");
            this.buffer.append(localName);
            this.buffer.append(">");
        }

        public void endDocument() throws SAXException {
            this.received = this.buffer.toString();
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
            this.buffer = new StringBuffer();
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.buffer.append("<");
            this.buffer.append(localName);
            this.buffer.append(">");
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

