/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;

public class SLDParserTest
extends TestCase {
    public static String SLD = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" version=\"1.0.0\"> <NamedLayer>  <Name>layer</Name>  <UserStyle>   <Name>style</Name>   <FeatureTypeStyle>    <Rule>     <PolygonSymbolizer>      <Fill>       <CssParameter name=\"fill\">#FF0000</CssParameter>      </Fill>     </PolygonSymbolizer>    </Rule>   </FeatureTypeStyle>  </UserStyle> </NamedLayer></StyledLayerDescriptor>";
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public void testBasic() throws Exception {
        SLDParser parser = new SLDParser(styleFactory, this.input());
        Style[] styles = parser.readXML();
        this.assertStyles(styles);
    }

    public void testMultipleParse() throws Exception {
        SLDParser parser = new SLDParser(styleFactory, this.input());
        Style[] styles = parser.readXML();
        this.assertStyles(styles);
        styles = parser.readDOM();
        this.assertStyles(styles);
        try {
            parser.readXML();
            SLDParserTest.fail((String)"Parsing again Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void assertStyles(Style[] styles) {
        SLDParserTest.assertEquals((int)1, (int)styles.length);
        SLDParserTest.assertEquals((String)"style", (String)styles[0].getName());
    }

    InputStream input() {
        return new ByteArrayInputStream(SLD.getBytes());
    }
}

