/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Color;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizerImpl;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.LabelPlacement;
import org.opengis.style.LineSymbolizer;
import org.opengis.style.PolygonSymbolizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UomRescaleStyleVisitorTest
extends TestCase {
    public void testConstructorOK() {
        try {
            new UomRescaleStyleVisitor(1.0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    public void testConstructorFail() {
        try {
            new UomRescaleStyleVisitor(-1.0);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"Should throw IllegalArgumentException.");
    }

    protected double computeExpectedRescaleSize(double size, double scaleMetersToPixel, Unit<Length> uom) {
        double expectedRescaledSize = size;
        if (uom != null) {
            double scaleUomToMeters = 1.0;
            if (uom.equals((Object)NonSI.FOOT)) {
                scaleUomToMeters *= 0.3048006096012;
            }
            if (!uom.equals((Object)NonSI.PIXEL)) {
                expectedRescaledSize *= scaleUomToMeters * scaleMetersToPixel;
            }
        }
        return expectedRescaledSize;
    }

    protected void visitPointSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            PointSymbolizerImpl pointSymb = (PointSymbolizerImpl)styleBuilder.createPointSymbolizer();
            pointSymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            pointSymb.getGraphic().setSize((Expression)filterFactory.literal(size));
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            pointSymb.accept((StyleVisitor)visitor);
            PointSymbolizer rescaledPointSymb = (PointSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledPointSymb.getGraphic().getSize().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledPointSymb, (Object)pointSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    protected void visitLineSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
            lineSymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            lineSymb.getStroke().setWidth((Expression)filterFactory.literal(size));
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledLineSymb.getStroke().getWidth().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    protected void visitPolygonSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            PolygonSymbolizerImpl polySymb = (PolygonSymbolizerImpl)styleBuilder.createPolygonSymbolizer();
            polySymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            polySymb.getStroke().setWidth((Expression)filterFactory.literal(size));
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            polySymb.accept((StyleVisitor)visitor);
            PolygonSymbolizer rescaledPolySymb = (PolygonSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledPolySymb.getStroke().getWidth().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledPolySymb, (Object)polySymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    protected void visitTextSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            int fontSize = 100;
            double displacementX = 13.0;
            double displacementY = 17.0;
            double expectedRescaledFontSize = this.computeExpectedRescaleSize(fontSize, scaleMetersToPixel, uom);
            double expectedRescaledDisplacementXSize = this.computeExpectedRescaleSize(displacementX, scaleMetersToPixel, uom);
            double expectedRescaledDisplacementYSize = this.computeExpectedRescaleSize(displacementY, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            TextSymbolizerImpl textSymb = (TextSymbolizerImpl)styleBuilder.createTextSymbolizer();
            textSymb.setUnitOfMeasure(uom);
            Font font = styleBuilder.createFont(new java.awt.Font("Verdana", 0, fontSize));
            textSymb.setFont((org.opengis.style.Font)font);
            PointPlacement placement = styleBuilder.createPointPlacement(0.3, 0.3, displacementX, displacementY, 10.0);
            textSymb.setLabelPlacement((LabelPlacement)placement);
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            textSymb.accept((StyleVisitor)visitor);
            TextSymbolizer rescaledTextSymb = (TextSymbolizer)visitor.getCopy();
            double rescaledFontSize = (Double)rescaledTextSymb.getFont().getSize().evaluate(null, Double.class);
            PointPlacement rescaledPlacement = (PointPlacement)rescaledTextSymb.getLabelPlacement();
            double rescaledDisplacementXSize = (Double)rescaledPlacement.getDisplacement().getDisplacementX().evaluate(null, Double.class);
            double rescaledDisplacementYSize = (Double)rescaledPlacement.getDisplacement().getDisplacementY().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledFontSize), (long)Math.round(rescaledFontSize));
            Assert.assertEquals((long)Math.round(expectedRescaledDisplacementXSize), (long)Math.round(rescaledDisplacementXSize));
            Assert.assertEquals((long)Math.round(expectedRescaledDisplacementYSize), (long)Math.round(rescaledDisplacementYSize));
            Assert.assertNotSame((Object)rescaledTextSymb, (Object)textSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    public void testVisitPointSymbolizer_ScalePixelNull() {
        this.visitPointSymbolizerTest(10.0, null);
    }

    public void testVisitPointSymbolizer_ScalePixelExplicit() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitPointSymbolizer_ScaleMeter1() {
        this.visitPointSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPointSymbolizer_ScaleMeter10() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPointSymbolizer_ScaleFoot1() {
        this.visitPointSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitPointSymbolizer_ScaleFoot10() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitLineSymbolizer_ScalePixelNull() {
        this.visitLineSymbolizerTest(10.0, null);
    }

    public void testVisitLineSymbolizer_ScalePixelExplicit() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitLineSymbolizer_ScaleMeter1() {
        this.visitLineSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitLineSymbolizer_ScaleMeter10() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitLineSymbolizer_ScaleFoot1() {
        this.visitLineSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitLineSymbolizer_ScaleFoot10() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitPolygonSymbolizer_ScalePixelNull() {
        this.visitPolygonSymbolizerTest(10.0, null);
    }

    public void testVisitPolygonSymbolizer_ScalePixelExplicit() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitPolygonSymbolizer_ScaleMeter1() {
        this.visitPolygonSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPolygonSymbolizer_ScaleMeter10() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPolygonSymbolizer_ScaleFoot1() {
        this.visitPolygonSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitPolygonSymbolizer_ScaleFoot10() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitTextSymbolizer_ScalePixelNull() {
        this.visitTextSymbolizerTest(10.0, null);
    }

    public void testVisitTextSymbolizer_ScalePixelExplicit() {
        this.visitTextSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitTextSymbolizer_ScaleMeter1() {
        this.visitTextSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitTextSymbolizer_ScaleMeter10() {
        this.visitTextSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitTextSymbolizer_ScaleFoot1() {
        this.visitTextSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitTextSymbolizer_ScaleFoot10() {
        this.visitTextSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitLineSymbolizer_NullStroke() {
        try {
            UomRescaleStyleVisitor visitor = null;
            StyleBuilder styleBuilder = new StyleBuilder();
            Stroke stroke = null;
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer(stroke);
            lineSymb.setUnitOfMeasure(SI.METER);
            visitor = new UomRescaleStyleVisitor(10.0);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            Assert.assertNull((Object)rescaledLineSymb.getStroke());
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    public void testVisitPolygonSymbolizer_NullStroke() {
        try {
            UomRescaleStyleVisitor visitor = null;
            StyleBuilder styleBuilder = new StyleBuilder();
            Fill fill = styleBuilder.createFill(Color.RED);
            PolygonSymbolizerImpl polySymb = (PolygonSymbolizerImpl)styleBuilder.createPolygonSymbolizer(null, fill);
            visitor = new UomRescaleStyleVisitor(10.0);
            polySymb.accept((StyleVisitor)visitor);
            PolygonSymbolizer rescaledPolySymb = (PolygonSymbolizer)visitor.getCopy();
            Assert.assertEquals((Object)polySymb.getFill(), (Object)rescaledPolySymb.getFill());
            Assert.assertNull((Object)rescaledPolySymb.getStroke());
            Assert.assertNotSame((Object)rescaledPolySymb, (Object)polySymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    public void testVisitTextSymbolizer_LinePlacement() {
        try {
            UomRescaleStyleVisitor visitor = null;
            Unit uom = SI.METER;
            int fontSize = 100;
            double perpOffset = 13.0;
            double gap = 7.0;
            double initialGap = 5.0;
            double scaleMetersToPixel = 17.0;
            double expectedRescaledFontSize = this.computeExpectedRescaleSize(fontSize, scaleMetersToPixel, (Unit<Length>)uom);
            double expectedRescaledPerpOffset = this.computeExpectedRescaleSize(perpOffset, scaleMetersToPixel, (Unit<Length>)uom);
            double expectedRescaledGap = this.computeExpectedRescaleSize(gap, scaleMetersToPixel, (Unit<Length>)uom);
            double expectedRescaledInitialGap = this.computeExpectedRescaleSize(initialGap, scaleMetersToPixel, (Unit<Length>)uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            TextSymbolizerImpl textSymb = (TextSymbolizerImpl)styleBuilder.createTextSymbolizer();
            textSymb.setUnitOfMeasure(uom);
            Font font = styleBuilder.createFont(new java.awt.Font("Verdana", 0, fontSize));
            textSymb.setFont((org.opengis.style.Font)font);
            LinePlacement placement = styleBuilder.createLinePlacement(perpOffset);
            placement.setGap(styleBuilder.literalExpression(gap));
            placement.setInitialGap(styleBuilder.literalExpression(initialGap));
            textSymb.setLabelPlacement((LabelPlacement)placement);
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            textSymb.accept((StyleVisitor)visitor);
            TextSymbolizer rescaledTextSymb = (TextSymbolizer)visitor.getCopy();
            double rescaledFontSize = (Double)rescaledTextSymb.getFont().getSize().evaluate(null, Double.class);
            LinePlacement rescaledPlacement = (LinePlacement)rescaledTextSymb.getLabelPlacement();
            double rescaledPerpOffset = (Double)rescaledPlacement.getPerpendicularOffset().evaluate(null, Double.class);
            double rescaledGap = (Double)rescaledPlacement.getGap().evaluate(null, Double.class);
            double rescaledInitialGap = (Double)rescaledPlacement.getInitialGap().evaluate(null, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledFontSize), (long)Math.round(rescaledFontSize));
            Assert.assertEquals((long)Math.round(expectedRescaledPerpOffset), (long)Math.round(rescaledPerpOffset));
            Assert.assertEquals((long)Math.round(expectedRescaledGap), (long)Math.round(rescaledGap));
            Assert.assertEquals((long)Math.round(expectedRescaledInitialGap), (long)Math.round(rescaledInitialGap));
            Assert.assertNotSame((Object)rescaledTextSymb, (Object)textSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }

    public void testVisitLineSymbolizer_ExpressionWithFeatureAttribute() {
        try {
            double widthValue = 13.0;
            double scaleMetersToPixel = 17.0;
            Unit uom = SI.METER;
            StyleBuilder styleBuilder = new StyleBuilder();
            UomRescaleStyleVisitor visitor = null;
            SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
            featureTypeBuilder.setName("TestType");
            featureTypeBuilder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            featureTypeBuilder.add("width", Double.class);
            SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
            GeometryFactory geomFactory = new GeometryFactory();
            LineString geom = geomFactory.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)});
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            featureBuilder.set("geom", (Object)geom);
            featureBuilder.set("width", (Object)widthValue);
            SimpleFeature feature = featureBuilder.buildFeature("1");
            Expression color = styleBuilder.colorExpression(Color.RED);
            Expression width = styleBuilder.attributeExpression("width");
            Stroke stroke = styleBuilder.createStroke(color, width);
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer(stroke);
            lineSymb.setUnitOfMeasure(uom);
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            org.opengis.style.Stroke rescaledStroke = rescaledLineSymb.getStroke();
            Expression rescaledWidth = rescaledStroke.getWidth();
            double rescaledWidthValue = (Double)rescaledWidth.evaluate((Object)feature, Double.class);
            double expectedRescaledWidthValue = this.computeExpectedRescaleSize(widthValue, scaleMetersToPixel, (Unit<Length>)uom);
            Assert.assertEquals((Object)stroke.getColor(), (Object)rescaledStroke.getColor());
            Assert.assertEquals((Object)expectedRescaledWidthValue, (Object)rescaledWidthValue);
            Assert.assertNotSame((Object)SI.METER, (Object)rescaledLineSymb.getUnitOfMeasure());
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(String.valueOf(e2.getClass().getSimpleName()) + " should not be thrown."));
        }
    }
}

