/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Iterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    static void accept(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, FeatureVisitor visitor) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            visitor.visit(feature);
        }
        collection.close(iterator);
    }

    static void accept(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, FeatureVisitor[] visitors) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iterator.next();
            for (int i = 0; i < visitors.length; ++i) {
                FeatureVisitor visitor = visitors[i];
                visitor.visit(feature);
            }
        }
        collection.close(iterator);
    }

    public static Object calc(FeatureCollection<SimpleFeatureType, SimpleFeature> collection, FeatureCalc calculator) {
        CollectionUtil.accept(collection, calculator);
        return calculator.getResult();
    }
}

