/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;

public class SimpleFeatureTypeImplTest
extends TestCase {
    public void testConsistentIterationOrder() {
        SimpleFeatureType type = this.buildLocationCountType();
        SimpleFeatureTypeImplTest.assertEquals((String)"FeatureType and SimpleFeatureType APIs must return the same descriptors in the same order", new ArrayList(type.getAttributeDescriptors()), new ArrayList(type.getDescriptors()));
    }

    public void testOrderSignificantEquals() {
        SimpleFeatureType type1 = this.buildLocationCountType();
        SimpleFeatureType type2 = this.buildCountLocationType();
        SimpleFeatureTypeImplTest.assertFalse((String)"Simple feature types with properties in a different order must not be equal", (boolean)type1.equals(type2));
    }

    public void testLocationCountEquals() {
        SimpleFeatureTypeImplTest.assertEquals((String)"Identical simple feature types must be equal", (Object)this.buildLocationCountType(), (Object)this.buildLocationCountType());
    }

    public void testCountLocationEquals() {
        SimpleFeatureTypeImplTest.assertEquals((String)"Identical simple feature types must be equal", (Object)this.buildCountLocationType(), (Object)this.buildCountLocationType());
    }

    private SimpleFeatureType buildLocationCountType() {
        SimpleFeatureTypeBuilder builder = this.buildPartialBuilder();
        builder.add("location", Point.class);
        builder.add("count", Integer.class);
        return builder.buildFeatureType();
    }

    private SimpleFeatureType buildCountLocationType() {
        SimpleFeatureTypeBuilder builder = this.buildPartialBuilder();
        builder.add("count", Integer.class);
        builder.add("location", Point.class);
        return builder.buildFeatureType();
    }

    private SimpleFeatureTypeBuilder buildPartialBuilder() {
        String uri = "http://example.org/things";
        FeatureTypeFactoryImpl typeFactory = new FeatureTypeFactoryImpl();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder((FeatureTypeFactory)typeFactory);
        builder.addBinding((AttributeType)typeFactory.createGeometryType((Name)new NameImpl(uri, "description"), String.class, null, false, false, Collections.EMPTY_LIST, null, null));
        builder.addBinding((AttributeType)typeFactory.createGeometryType((Name)new NameImpl(uri, "location"), Point.class, null, false, false, Collections.EMPTY_LIST, null, null));
        builder.addBinding(typeFactory.createAttributeType((Name)new NameImpl(uri, "count"), Integer.class, false, false, Collections.EMPTY_LIST, null, null));
        builder.setName("ThingsType");
        builder.setNamespaceURI(uri);
        builder.add("description", String.class);
        return builder;
    }
}

