/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Within;

public class FilterTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private static SimpleFeature testFeature = null;
    private static SimpleFeatureType testSchema = null;
    boolean set = false;
    FilterFactory2 fac = CommonFactoryFinder.getFilterFactory2(null);
    TestSuite suite = null;
    private Calendar calDateTime;
    private Calendar calTime;
    private Calendar calDate;

    public FilterTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FilterTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException {
        if (this.set) {
            return;
        }
        this.set = true;
        this.fac = CommonFactoryFinder.getFilterFactory2(null);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testString2", String.class);
        ftb.add("date", Date.class);
        ftb.add("time", Time.class);
        ftb.add("datetime1", java.util.Date.class);
        ftb.add("datetime2", Timestamp.class);
        testSchema = ftb.buildFeatureType();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[15];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        attributes[0] = gf.createLineString(coords);
        attributes[1] = new Boolean(true);
        attributes[2] = new Character('t');
        attributes[3] = new Byte("10");
        attributes[4] = new Short("101");
        attributes[5] = new Integer(1002);
        attributes[6] = new Long(10003L);
        attributes[7] = new Float(10000.4);
        attributes[8] = new Double(100000.5);
        attributes[9] = "test string data";
        attributes[10] = "cow $10";
        this.calDate = Calendar.getInstance();
        this.calDate.clear();
        this.calDate.set(2007, 7, 15);
        this.calTime = Calendar.getInstance();
        this.calTime.clear();
        this.calTime.set(11, 12);
        this.calDateTime = Calendar.getInstance();
        this.calDateTime.clear();
        this.calDateTime.set(2007, 7, 15, 12, 0, 0);
        attributes[11] = new Date(this.calDate.getTimeInMillis());
        attributes[12] = new Time(this.calTime.getTimeInMillis());
        attributes[13] = this.calDateTime.getTime();
        attributes[14] = new Timestamp(this.calDateTime.getTimeInMillis());
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
    }

    public void testLikeToSQL() {
        FilterTest.assertTrue((boolean)"BroadWay%".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"BroadWay*")));
        FilterTest.assertTrue((boolean)"broad#ay".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broad#ay")));
        FilterTest.assertTrue((boolean)"broadway".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway")));
        FilterTest.assertTrue((boolean)"broad_ay".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broad.ay")));
        FilterTest.assertTrue((boolean)"broad.ay".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broad!.ay")));
        FilterTest.assertTrue((boolean)"broa''dway".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broa'dway")));
        FilterTest.assertTrue((boolean)"broa''''dway".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broa''dway")));
        FilterTest.assertTrue((boolean)"broadway_".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway.")));
        FilterTest.assertTrue((boolean)"broadway".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway!")));
        FilterTest.assertTrue((boolean)"broadway!".equals(LikeFilterImpl.convertToSQL92((char)'!', (char)'*', (char)'.', (boolean)true, (String)"broadway!!")));
    }

    public void testCompare() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testInteger");
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareNumberRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        testAttribute = new AttributeExpressionImpl(testSchema, "date");
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareSqlDateRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        testAttribute = new AttributeExpressionImpl(testSchema, "time");
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsEqualTo.class, false, true, false);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsGreaterThan.class, true, false, false);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsLessThan.class, false, false, true);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsGreaterThanOrEqualTo.class, true, true, false);
        this.compareSqlTimeRunner((PropertyName)testAttribute, PropertyIsLessThanOrEqualTo.class, false, true, true);
        testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("test string data");
        Filter filter = this.compare(PropertyIsEqualTo.class, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl("incorrect test string data");
        filter = this.compare(PropertyIsEqualTo.class, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertTrue((!filter.evaluate((Object)testFeature) ? 1 : 0) != 0);
        testLiteral = new LiteralExpressionImpl("zebra");
        filter = this.compare(PropertyIsLessThan.class, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl("blorg");
        filter = this.compare(PropertyIsLessThan.class, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertTrue((!filter.evaluate((Object)testFeature) ? 1 : 0) != 0);
    }

    public void compareNumberRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl((Object)new Integer(1001));
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test1);
        testLiteral = new LiteralExpressionImpl((Object)new Integer(1002));
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test2);
        testLiteral = new LiteralExpressionImpl((Object)new Integer(1003));
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test3);
    }

    public void compareSqlDateRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        Calendar calLocal = Calendar.getInstance();
        calLocal.setTime(this.calDate.getTime());
        calLocal.set(5, this.calDateTime.get(5) - 1);
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl(new Date(calLocal.getTimeInMillis()).toString());
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)test1, (boolean)filter.evaluate((Object)testFeature));
        testLiteral = new LiteralExpressionImpl(new Date(this.calDate.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)test2, (boolean)filter.evaluate((Object)testFeature));
        calLocal.set(5, this.calDateTime.get(5) + 1);
        testLiteral = new LiteralExpressionImpl(new Date(calLocal.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test3);
    }

    Filter compare(Class filterType, Expression a, Expression b) {
        if (filterType == PropertyIsLessThan.class) {
            return this.fac.less(a, b);
        }
        if (filterType == PropertyIsLessThanOrEqualTo.class) {
            return this.fac.lessOrEqual(a, b);
        }
        if (filterType == PropertyIsEqualTo.class) {
            return this.fac.equals(a, b);
        }
        if (filterType == PropertyIsGreaterThanOrEqualTo.class) {
            return this.fac.greaterOrEqual(a, b);
        }
        if (filterType == PropertyIsGreaterThan.class) {
            return this.fac.greater(a, b);
        }
        throw new IllegalArgumentException("Uknown compare filter type " + filterType);
    }

    public void compareSqlTimeRunner(PropertyName testAttribute, Class filterType, boolean test1, boolean test2, boolean test3) throws IllegalFilterException {
        Calendar calLocal = Calendar.getInstance();
        calLocal.setTime(this.calTime.getTime());
        calLocal.set(11, this.calTime.get(11) - 1);
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl(new Time(calLocal.getTimeInMillis()).toString());
        Filter filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test1);
        testLiteral = new LiteralExpressionImpl(new Time(this.calTime.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test2);
        calLocal.set(11, this.calTime.get(11) + 1);
        testLiteral = new LiteralExpressionImpl(new Time(calLocal.getTimeInMillis()).toString());
        filter = this.compare(filterType, (Expression)testAttribute, (Expression)testLiteral);
        FilterTest.assertEquals((boolean)filter.evaluate((Object)testFeature), (boolean)test3);
    }

    public void testLike() throws IllegalFilterException {
        Pattern compPattern = Pattern.compile("test.*");
        Matcher matcher = compPattern.matcher("test string");
        FilterTest.assertTrue((boolean)matcher.matches());
        AttributeExpressionImpl testAttribute = null;
        testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        PropertyIsLike filter = this.fac.like((Expression)testAttribute, "test*", "*", ".", "!");
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "cows*", "*", ".", "!");
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "test*a.", "*", ".", "!");
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.like((Expression)testAttribute, "test*dat.", "*", ".", "!");
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
    }

    public void testNull() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        PropertyIsNull filter = this.fac.isNull(Expression.NIL);
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.isNull((Expression)testAttribute);
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testCompareShortCircuit() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsNull nullFilter = this.fac.isNull((Expression)testAttribute);
        Not notNullFilter = this.fac.not((Filter)nullFilter);
        PropertyIsEqualTo compareFilter = this.fac.equals((Expression)testAttribute, (Expression)this.fac.literal(10));
        testFeature.setAttribute("testInteger", null);
        FilterTest.assertEquals((boolean)false, (boolean)compareFilter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)nullFilter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)notNullFilter.evaluate((Object)testFeature));
        And finalFilter = this.fac.and((Filter)notNullFilter, (Filter)compareFilter);
        try {
            FilterTest.assertFalse((boolean)finalFilter.evaluate((Object)testFeature));
        }
        catch (NullPointerException e) {
            FilterTest.fail((String)("Short-circuit evaluation was not performed by LogicFilter: " + e.getMessage()));
        }
        finalFilter = this.fac.or((Filter)nullFilter, (Filter)compareFilter);
        try {
            FilterTest.assertTrue((boolean)finalFilter.evaluate((Object)testFeature));
        }
        catch (NullPointerException e) {
            FilterTest.fail((String)("Short-circuit evaluation was not performed by LogicFilter: " + e.getMessage()));
        }
    }

    public void testBetween() throws IllegalFilterException {
        Literal testLiteralLower = this.fac.literal(1001);
        PropertyName testAttribute = this.fac.property("testInteger");
        Literal testLiteralUpper = this.fac.literal(1003);
        PropertyIsBetween filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteralLower = this.fac.literal(1);
        testLiteralUpper = this.fac.literal(1000);
        filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testBetweenStrings() throws IllegalFilterException {
        LiteralExpressionImpl testLiteralLower = new LiteralExpressionImpl("blorg");
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteralUpper = new LiteralExpressionImpl("tron");
        PropertyIsBetween filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        testLiteralLower = new LiteralExpressionImpl("zebra");
        testLiteralUpper = new LiteralExpressionImpl("zikes");
        filter = this.fac.between((Expression)testAttribute, (Expression)testLiteralLower, (Expression)testLiteralUpper);
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testGeometryEquals() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LineString geom = gf.createLineString(coords);
        LiteralExpressionImpl right = new LiteralExpressionImpl((Object)geom);
        Equals filter = this.fac.equal((Expression)left, (Expression)right);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        filter = this.fac.equal((Expression)left, (Expression)function);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        coords[0] = new Coordinate(0.0, 0.0);
        right = new LiteralExpressionImpl((Object)geom);
        filter = this.fac.equal((Expression)left, (Expression)right);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.equal((Expression)left, (Expression)new LiteralExpressionImpl(null));
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testContains() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Polygon geom = gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]);
        LiteralExpressionImpl expr1 = new LiteralExpressionImpl((Object)geom);
        AttributeExpressionImpl expr2 = new AttributeExpressionImpl(testSchema, "testGeometry");
        Contains filter = this.fac.contains((Expression)expr1, (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        filter = this.fac.contains((Expression)expr1, (Expression)function);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.contains((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        coords = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        geom = gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]);
        expr1 = new LiteralExpressionImpl((Object)geom);
        filter = this.fac.contains((Expression)expr1, (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.contains((Expression)new LiteralExpressionImpl(null), (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testWithin() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Polygon geom = gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]);
        LiteralExpressionImpl expr2 = new LiteralExpressionImpl((Object)geom);
        AttributeExpressionImpl expr1 = new AttributeExpressionImpl(testSchema, "testGeometry");
        Within filter = this.fac.within((Expression)expr1, (Expression)expr2);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        filter = this.fac.within((Expression)expr1, (Expression)function);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.within((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        coords = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        expr2 = new LiteralExpressionImpl((Object)gf.createPolygon(gf.createLinearRing(coords), new LinearRing[0]));
        filter = this.fac.within((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        expr2 = new LiteralExpressionImpl(null);
        filter = this.fac.within((Expression)expr2, (Expression)expr1);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testDisjoint() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(3.0, 0.0), new Coordinate(6.0, 0.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        AttributeExpressionImpl expr1 = new AttributeExpressionImpl(testSchema, "testGeometry");
        LineString geom = gf.createLineString(coords);
        LiteralExpressionImpl expr2 = new LiteralExpressionImpl((Object)geom);
        Disjoint disjoint = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)disjoint.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        disjoint = this.fac.disjoint((Expression)expr1, (Expression)function);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)disjoint.evaluate((Object)testFeature));
        disjoint = this.fac.disjoint((Expression)expr2, (Expression)expr1);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)disjoint.evaluate((Object)testFeature));
        coords[0] = new Coordinate(1.0, 2.0);
        coords[1] = new Coordinate(3.0, 0.0);
        coords[2] = new Coordinate(6.0, 0.0);
        geom = gf.createLineString(coords);
        expr2 = new LiteralExpressionImpl((Object)geom);
        disjoint = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        FilterTest.assertTrue((!disjoint.evaluate((Object)testFeature) ? 1 : 0) != 0);
        expr2 = new LiteralExpressionImpl(null);
        disjoint = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        LOGGER.finer(disjoint.toString());
        LOGGER.finer("contains feature: " + disjoint.evaluate((Object)testFeature));
        FilterTest.assertTrue((!disjoint.evaluate((Object)testFeature) ? 1 : 0) != 0);
    }

    public void testIntersects() throws Exception {
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 5.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 1.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        AttributeExpressionImpl expr1 = new AttributeExpressionImpl(testSchema, "testGeometry");
        LineString geom = gf.createLineString(coords);
        LiteralExpressionImpl expr2 = new LiteralExpressionImpl((Object)geom);
        Intersects intersects = this.fac.intersects((Expression)expr1, (Expression)expr2);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        intersects = this.fac.intersects((Expression)expr2, (Expression)expr1);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        GeometryFunction function = new GeometryFunction((Geometry)geom);
        intersects = this.fac.intersects((Expression)expr1, (Expression)function);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)intersects.evaluate((Object)testFeature));
        coords[0] = new Coordinate(0.0, 0.0);
        coords[1] = new Coordinate(3.0, 0.0);
        coords[2] = new Coordinate(6.0, 0.0);
        expr2 = new LiteralExpressionImpl((Object)gf.createLineString(coords));
        intersects = this.fac.intersects((Expression)expr1, (Expression)expr2);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        FilterTest.assertTrue((!intersects.evaluate((Object)testFeature) ? 1 : 0) != 0);
        expr2 = new LiteralExpressionImpl(null);
        intersects = this.fac.intersects((Expression)expr1, (Expression)expr2);
        LOGGER.finer(intersects.toString());
        LOGGER.finer("contains feature: " + intersects.evaluate((Object)testFeature));
        FilterTest.assertTrue((!intersects.evaluate((Object)testFeature) ? 1 : 0) != 0);
    }

    public void testBBOX() throws IllegalFilterException {
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        BBOX bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 10.0, 10.0, null);
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)bbox.evaluate((Object)testFeature));
        bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 1.0, 1.0, null);
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        FilterTest.assertTrue((!bbox.evaluate((Object)testFeature) ? 1 : 0) != 0);
        bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 10.0, 10.0, "EPSG:4326");
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)bbox.evaluate((Object)testFeature));
        bbox = this.fac.bbox((Expression)left, 0.0, 0.0, 10.0, 10.0, "");
        LOGGER.finer(bbox.toString());
        LOGGER.finer("contains feature: " + bbox.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)bbox.evaluate((Object)testFeature));
    }

    public void testDWithin() throws Exception {
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(10.0, 10.0), new Coordinate(15.0, 10.0), new Coordinate(15.0, 15.0), new Coordinate(10.0, 15.0), new Coordinate(10.0, 10.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LiteralExpressionImpl right = new LiteralExpressionImpl((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        DWithin filter = this.fac.dwithin((Expression)left, (Expression)right, 20.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.dwithin((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        right = new LiteralExpressionImpl(null);
        filter = this.fac.dwithin((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testBeyond() throws Exception {
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(10.0, 10.0), new Coordinate(15.0, 10.0), new Coordinate(15.0, 15.0), new Coordinate(10.0, 15.0), new Coordinate(10.0, 10.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LiteralExpressionImpl right = new LiteralExpressionImpl((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        Beyond filter = this.fac.beyond((Expression)left, (Expression)right, 20.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.beyond((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        coords2[0] = new Coordinate(20.0, 20.0);
        coords2[1] = new Coordinate(21.0, 20.0);
        coords2[2] = new Coordinate(21.0, 21.0);
        coords2[3] = new Coordinate(20.0, 21.0);
        coords2[4] = new Coordinate(20.0, 20.0);
        right = this.fac.literal((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        filter = this.fac.beyond((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        right = new LiteralExpressionImpl(null);
        filter = this.fac.beyond((Expression)left, (Expression)right, 2.0, "m");
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testFid() {
        Id ff = this.fac.id(new HashSet());
        FilterTest.assertFalse((boolean)ff.evaluate((Object)testFeature));
        ff = this.fac.id(Collections.singleton(this.fac.featureId(testFeature.getID())));
        FilterTest.assertTrue((boolean)ff.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)ff.evaluate(null));
    }

    public void testOrFilter() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("test string data");
        PropertyIsEqualTo filterTrue = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        testLiteral = new LiteralExpressionImpl("incorrect test string data");
        PropertyIsEqualTo filterFalse = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        Or filter = this.fac.or((Filter)filterFalse, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.or((Filter)filterTrue, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        filter = this.fac.or((Filter)filterFalse, (Filter)filterFalse);
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)filter.evaluate((Object)testFeature));
    }

    public void testAndFilter() throws IllegalFilterException {
        AttributeExpressionImpl testAttribute = new AttributeExpressionImpl(testSchema, "testString");
        LiteralExpressionImpl testLiteral = new LiteralExpressionImpl("test string data");
        PropertyIsEqualTo filterTrue = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        testLiteral = new LiteralExpressionImpl("incorrect test string data");
        PropertyIsEqualTo filterFalse = this.fac.equals((Expression)testAttribute, (Expression)testLiteral);
        And filter = this.fac.and((Filter)filterFalse, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((!filter.evaluate((Object)testFeature) ? 1 : 0) != 0);
        filter = this.fac.and((Filter)filterTrue, (Filter)filterFalse);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((!filter.evaluate((Object)testFeature) ? 1 : 0) != 0);
        filter = this.fac.and((Filter)filterTrue, (Filter)filterTrue);
        LOGGER.finer(filter.toString());
        LOGGER.finer("contains feature: " + filter.evaluate((Object)testFeature));
        FilterTest.assertTrue((boolean)filter.evaluate((Object)testFeature));
        FilterTest.assertFalse((boolean)this.fac.not((Filter)filter).evaluate((Object)testFeature));
    }

    public void testLiteralExpression() {
        LiteralExpressionImpl literal = new LiteralExpressionImpl(1.0);
        FilterTest.assertEquals((short)101, (short)literal.getType());
        FilterTest.assertEquals((Object)new Double(1.0), (Object)literal.evaluate((Object)null));
        GeometryFactory gf = new GeometryFactory();
        literal = new LiteralExpressionImpl((Object)gf.createPoint(new Coordinate(0.0, 0.0)));
        FilterTest.assertEquals((short)104, (short)literal.getType());
        Geometry value = (Geometry)literal.evaluate((Object)null);
        FilterTest.assertTrue((boolean)gf.createPoint(new Coordinate(0.0, 0.0)).equalsExact(value));
        literal = new LiteralExpressionImpl(1);
        FilterTest.assertEquals((short)102, (short)literal.getType());
        FilterTest.assertEquals((Object)new Integer(1), (Object)literal.evaluate((Object)null));
        literal = new LiteralExpressionImpl(1L);
        FilterTest.assertEquals((short)100, (short)literal.getType());
        FilterTest.assertEquals((Object)new Long(1L), (Object)literal.evaluate((Object)null));
        literal = new LiteralExpressionImpl("string value");
        FilterTest.assertEquals((short)103, (short)literal.getType());
        FilterTest.assertEquals((Object)"string value", (Object)literal.evaluate((Object)null));
        literal = new LiteralExpressionImpl((Object)new java.util.Date(0L));
        FilterTest.assertEquals((short)115, (short)literal.getType());
        FilterTest.assertEquals((Object)new java.util.Date(0L), (Object)literal.evaluate((Object)null));
        literal = new LiteralExpressionImpl(null);
        FilterTest.assertEquals((short)115, (short)literal.getType());
        FilterTest.assertNull((Object)literal.evaluate((Object)null));
    }

    public void testEvaluateNonFeatureObject() {
        MockDataObject object = new MockDataObject();
        object.intVal = 5;
        object.stringVal = "cinco";
        PropertyIsGreaterThan f = this.fac.greater((Expression)this.fac.property("intVal"), (Expression)this.fac.literal(3));
        FilterTest.assertTrue((boolean)f.evaluate((Object)object));
        And f2 = this.fac.and((Filter)f, (Filter)this.fac.equals((Expression)this.fac.property("stringVal"), (Expression)this.fac.literal((Object)"cinco")));
        FilterTest.assertTrue((boolean)f2.evaluate((Object)object));
        And f3 = this.fac.and((Filter)f, (Filter)this.fac.equals((Expression)this.fac.property("stringVal"), (Expression)this.fac.literal((Object)"seis")));
        FilterTest.assertFalse((boolean)f3.evaluate((Object)object));
        Not f4 = this.fac.not((Filter)this.fac.and((Filter)f, (Filter)this.fac.equals((Expression)this.fac.property("stringVal"), (Expression)this.fac.literal((Object)"cinco"))));
        FilterTest.assertFalse((boolean)f4.evaluate((Object)object));
    }

    public void testSafeConversions() {
        Literal d = this.fac.literal(1.1);
        Literal i = this.fac.literal(1);
        PropertyIsGreaterThan f1 = this.fac.greater((Expression)d, (Expression)i);
        FilterTest.assertTrue((boolean)f1.evaluate(null));
        PropertyIsLessThan f2 = this.fac.less((Expression)i, (Expression)d);
        FilterTest.assertTrue((boolean)f2.evaluate(null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GeometryFunction
    implements Function {
        final Geometry ls;

        public GeometryFunction(Geometry geom) throws Exception {
            this.ls = geom;
        }

        public String getName() {
            return "function";
        }

        public List<Expression> getParameters() {
            return Collections.emptyList();
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return visitor.visit((Function)this, extraData);
        }

        public Object evaluate(Object object) {
            return this.ls;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            return context.cast(this.ls);
        }

        public Literal getFallbackValue() {
            return null;
        }
    }

    public static class MockPropertyAccessorFactory
    implements PropertyAccessorFactory {
        public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
            if (!MockDataObject.class.equals((Object)type)) {
                return null;
            }
            return new PropertyAccessor(){

                public boolean canHandle(Object object, String xpath, Class target) {
                    return object instanceof MockDataObject;
                }

                public Object get(Object object, String xpath, Class target) throws IllegalArgumentException {
                    if (object == null) {
                        return null;
                    }
                    try {
                        Field field = MockDataObject.class.getField(xpath);
                        Object value = field.get(object);
                        return value;
                    }
                    catch (Exception e) {
                        throw (IllegalArgumentException)new IllegalArgumentException("Illegal property name: " + xpath).initCause(e);
                    }
                }

                public void set(Object object, String xpath, Object value, Class target) throws IllegalArgumentException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class MockDataObject {
        public int intVal;
        public String stringVal;

        public MockDataObject() {
            this(0, null);
        }

        public MockDataObject(int intVal, String stringVal) {
            this.intVal = intVal;
            this.stringVal = stringVal;
        }
    }
}

