/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class StyleFactoryImplTest
extends TestCase {
    static StyleFactory styleFactory;
    static FilterFactory filterFactory;
    static SimpleFeature feature;
    protected static final Logger LOGGER;

    public StyleFactoryImplTest(String testName) {
        super(testName);
        feature = null;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)StyleFactoryImplTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(StyleFactoryImplTest.class);
        return suite;
    }

    public void testCommonFactoryFinder() {
        LOGGER.finer("testCreateStyle");
        styleFactory = CommonFactoryFinder.getStyleFactory(null);
        StyleFactoryImplTest.assertNotNull((String)"Failed to build styleFactory", (Object)styleFactory);
    }

    public void testCreatePointSymbolizer() {
        LOGGER.finer("testCreatePointSymbolizer");
        PointSymbolizer ps = styleFactory.createPointSymbolizer();
        StyleFactoryImplTest.assertNotNull((String)"Failed to create PointSymbolizer", (Object)ps);
    }

    public void testCreatePolygonSymbolizer() {
        LOGGER.finer("testCreatePolygonSymbolizer");
        PolygonSymbolizer ps = styleFactory.createPolygonSymbolizer();
        StyleFactoryImplTest.assertNotNull((String)"Failed to create PolygonSymbolizer", (Object)ps);
    }

    public void testCreateLineSymbolizer() {
        LOGGER.finer("testCreateLineSymbolizer");
        LineSymbolizer ls = styleFactory.createLineSymbolizer();
        StyleFactoryImplTest.assertNotNull((String)"Failed to create PolygonSymbolizer", (Object)ls);
    }

    public void testCreateTextSymbolizer() {
        LOGGER.finer("testCreateTextSymbolizer");
        TextSymbolizer ts = styleFactory.createTextSymbolizer();
        StyleFactoryImplTest.assertNotNull((String)"Failed to create TextSymbolizer", (Object)ts);
    }

    public void testCreateFeatureTypeStyle() {
        LOGGER.finer("testCreateFeatureTypeStyle");
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        StyleFactoryImplTest.assertNotNull((String)"failed to create featureTypeStyle", (Object)fts);
    }

    public void testCreateRule() {
        LOGGER.finer("testCreateRule");
        Rule r = styleFactory.createRule();
        StyleFactoryImplTest.assertNotNull((String)"failed to create Rule", (Object)r);
    }

    public void testCreateStroke() {
        LOGGER.finer("testCreateStroke");
        Stroke s = styleFactory.createStroke((Expression)filterFactory.literal((Object)"#000000"), (Expression)filterFactory.literal(2.0));
        StyleFactoryImplTest.assertNotNull((String)"Failed to build stroke ", (Object)s);
        s = styleFactory.createStroke((Expression)filterFactory.literal((Object)"#000000"), (Expression)filterFactory.literal(2.0), (Expression)filterFactory.literal(0.5));
        StyleFactoryImplTest.assertNotNull((String)"Failed to build stroke ", (Object)s);
        s = styleFactory.createStroke((Expression)filterFactory.literal((Object)"#000000"), (Expression)filterFactory.literal(2.0), (Expression)filterFactory.literal(0.5), (Expression)filterFactory.literal((Object)"bevel"), (Expression)filterFactory.literal((Object)"square"), new float[]{1.1f, 2.1f, 6.0f, 2.1f, 1.1f, 5.0f}, (Expression)filterFactory.literal(3), null, null);
        StyleFactoryImplTest.assertNotNull((String)"Failed to build stroke ", (Object)s);
        StyleFactoryImplTest.assertEquals((String)"Wrong color ", (String)"#000000", (String)s.getColor().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong width ", (String)"2.0", (String)s.getWidth().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong opacity ", (String)"0.5", (String)s.getOpacity().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong linejoin ", (String)"bevel", (String)s.getLineJoin().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong linejoin ", (String)"square", (String)s.getLineCap().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Broken dash array", (float)2.1f, (float)s.getDashArray()[1], (float)0.001f);
        StyleFactoryImplTest.assertEquals((String)"Wrong dash offset ", (String)"3", (String)s.getDashOffset().evaluate((Object)feature).toString());
    }

    public void testCreateFill() {
        LOGGER.finer("testCreateFill");
        Fill f = styleFactory.createFill((Expression)filterFactory.literal((Object)"#808080"));
        StyleFactoryImplTest.assertNotNull((String)"Failed to build fill", (Object)f);
        f = styleFactory.createFill((Expression)filterFactory.literal((Object)"#808080"), (Expression)filterFactory.literal(1.0));
        StyleFactoryImplTest.assertNotNull((String)"Failed to build fill", (Object)f);
        f = styleFactory.createFill(null);
        StyleFactoryImplTest.assertEquals((Object)f.getColor(), (Object)Fill.DEFAULT.getColor());
        StyleFactoryImplTest.assertSame((Object)f.getColor(), (Object)Fill.DEFAULT.getColor());
        StyleFactoryImplTest.assertEquals((Object)f.getBackgroundColor(), (Object)Fill.DEFAULT.getBackgroundColor());
        StyleFactoryImplTest.assertSame((Object)f.getBackgroundColor(), (Object)Fill.DEFAULT.getBackgroundColor());
    }

    public void testCreateMark() {
        LOGGER.finer("testCreateMark");
        Mark m = styleFactory.createMark();
        StyleFactoryImplTest.assertNotNull((String)"Failed to build mark ", (Object)m);
    }

    public void testGetNamedMarks() {
        LOGGER.finer("testGetNamedMarks");
        String[] names = new String[]{"Square", "Circle", "Triangle", "Star", "X", "Cross"};
        for (int i = 0; i < names.length; ++i) {
            try {
                Class<?> target = styleFactory.getClass();
                Method method = target.getMethod("get" + names[i] + "Mark", null);
                Mark m = (Mark)method.invoke((Object)styleFactory, (Object[])null);
                StyleFactoryImplTest.assertNotNull((String)("Failed to get " + names[i] + " mark "), (Object)m);
                Literal exp = filterFactory.literal((Object)names[i]);
                StyleFactoryImplTest.assertEquals((String)"Wrong sort of mark returned ", (Object)exp, (Object)m.getWellKnownName());
                StyleFactoryImplTest.assertEquals((String)"Wrong size of mark returned ", (String)"6", (String)m.getSize().evaluate((Object)feature).toString());
                continue;
            }
            catch (InvocationTargetException ite) {
                ite.getTargetException().printStackTrace();
                StyleFactoryImplTest.fail((String)("InvocationTargetException " + ite.getTargetException()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                StyleFactoryImplTest.fail((String)("Exception " + e.toString()));
            }
        }
    }

    public void testCreateGraphic() {
        LOGGER.finer("testCreateGraphic");
        ExternalGraphic[] externalGraphics = new ExternalGraphic[]{styleFactory.createExternalGraphic("http://www.ccg.leeds.ac.uk/ian/geotools/icons/rail.gif", "image/gif")};
        Mark[] marks = new Mark[]{styleFactory.getCircleMark()};
        Mark[] symbols = new Mark[]{};
        Literal opacity = filterFactory.literal(0.5);
        Literal size = filterFactory.literal(10);
        Literal rotation = filterFactory.literal(145.0);
        Graphic g = styleFactory.createGraphic(externalGraphics, marks, (Symbol[])symbols, (Expression)opacity, (Expression)size, (Expression)rotation);
        StyleFactoryImplTest.assertNotNull((String)"failed to build graphic ", (Object)g);
    }

    public void testCreateFont() {
        LOGGER.finer("testCreateFont");
        Literal fontFamily = filterFactory.literal((Object)"Times");
        Literal fontStyle = filterFactory.literal((Object)"Italic");
        Literal fontWeight = filterFactory.literal((Object)"Bold");
        Literal fontSize = filterFactory.literal((Object)"12");
        Font f = styleFactory.createFont((Expression)fontFamily, (Expression)fontStyle, (Expression)fontWeight, (Expression)fontSize);
        StyleFactoryImplTest.assertNotNull((String)"Failed to build font", (Object)f);
        StyleFactoryImplTest.assertEquals((String)"Wrong font type ", (String)"Times", (String)f.getFontFamily().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong font Style ", (String)"Italic", (String)f.getFontStyle().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong font weight ", (String)"Bold", (String)f.getFontWeight().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong font size ", (String)"12", (String)f.getFontSize().evaluate((Object)feature).toString());
    }

    public void testCreateLinePlacement() {
        LOGGER.finer("testCreateLinePlacement");
        LinePlacement lp = styleFactory.createLinePlacement((Expression)filterFactory.literal(10));
        StyleFactoryImplTest.assertNotNull((String)"failed to create LinePlacement", (Object)lp);
    }

    public void testCreatePointPlacement() {
        LOGGER.finer("testCreatePointPlacement");
        AnchorPoint anchorPoint = styleFactory.createAnchorPoint((Expression)filterFactory.literal(1.0), (Expression)filterFactory.literal(0.5));
        Displacement displacement = styleFactory.createDisplacement((Expression)filterFactory.literal(10.0), (Expression)filterFactory.literal(5.0));
        Literal rotation = filterFactory.literal(90.0);
        PointPlacement pp = styleFactory.createPointPlacement(anchorPoint, displacement, (Expression)rotation);
        StyleFactoryImplTest.assertNotNull((String)"failed to create PointPlacement", (Object)pp);
        StyleFactoryImplTest.assertEquals((String)"Wrong X anchorPoint ", (String)"1.0", (String)pp.getAnchorPoint().getAnchorPointX().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong Y anchorPoint ", (String)"0.5", (String)pp.getAnchorPoint().getAnchorPointY().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong X displacement ", (String)"10.0", (String)pp.getDisplacement().getDisplacementX().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong Y displacement ", (String)"5.0", (String)pp.getDisplacement().getDisplacementY().evaluate((Object)feature).toString());
        StyleFactoryImplTest.assertEquals((String)"Wrong Rotation ", (String)"90.0", (String)pp.getRotation().evaluate((Object)feature).toString());
    }

    public void testCreateHalo() {
        LOGGER.finer("testCreateHalo");
        Halo h = styleFactory.createHalo(styleFactory.getDefaultFill(), (Expression)filterFactory.literal(4));
        StyleFactoryImplTest.assertNotNull((String)"Failed to build halo", (Object)h);
        StyleFactoryImplTest.assertEquals((String)"Wrong radius", (int)4, (int)((Number)h.getRadius().evaluate((Object)feature)).intValue());
    }

    public void testBuggyStyleCopy() throws Exception {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Random rand = new Random();
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)"#8024d0"), (Expression)ff.literal(rand.nextInt(10) + 1));
        stroke.setOpacity((Expression)ff.literal(rand.nextFloat()));
        LineSymbolizer lineSymb = sf.createLineSymbolizer(stroke, ".");
        Rule rule = sf.createRule();
        rule.symbolizers().add(lineSymb);
        rule.setFilter((Filter)Filter.INCLUDE);
        rule.setMaxScaleDenominator(20000.0);
        FeatureTypeStyle style = sf.createFeatureTypeStyle();
        style.addRule(rule);
        style.setFeatureTypeName("Feature");
        Style namedStyle = sf.createStyle();
        namedStyle.addFeatureTypeStyle(style);
        namedStyle.setName("Feature");
        DuplicatingStyleVisitor duplicator = new DuplicatingStyleVisitor();
        namedStyle.accept((StyleVisitor)duplicator);
        Style namedStyle2 = (Style)duplicator.getCopy();
        SLDTransformer writer = new SLDTransformer();
        String out = writer.transform((Object)style);
        StyleFactoryImplTest.assertNotNull((Object)out);
    }

    static {
        filterFactory = CommonFactoryFinder.getFilterFactory(null);
        LOGGER = Logging.getLogger((String)"org.geotools.styling");
    }
}

