/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.awt.Color;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.style.LineSymbolizer;
import org.opengis.style.PolygonSymbolizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UomRescaleStyleVisitorTest
extends TestCase {
    public void testConstructorOK() {
        try {
            new UomRescaleStyleVisitor(1.0);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    public void testConstructorFail() {
        try {
            new UomRescaleStyleVisitor(-1.0);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"Should throw IllegalArgumentException.");
    }

    protected double computeExpectedRescaleSize(double size, double scaleMetersToPixel, Unit<Length> uom) {
        double expectedRescaledSize = size;
        if (uom != null) {
            double scaleUomToMeters = 1.0;
            if (uom.equals((Object)NonSI.FOOT)) {
                scaleUomToMeters *= 0.3048006096012;
            }
            if (!uom.equals((Object)NonSI.PIXEL)) {
                expectedRescaledSize *= scaleUomToMeters * scaleMetersToPixel;
            }
        }
        return expectedRescaledSize;
    }

    protected void visitPointSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            PointSymbolizerImpl pointSymb = (PointSymbolizerImpl)styleBuilder.createPointSymbolizer();
            pointSymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            pointSymb.getGraphic().setSize((Expression)filterFactory.literal(size));
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            pointSymb.accept((StyleVisitor)visitor);
            PointSymbolizer rescaledPointSymb = (PointSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledPointSymb.getGraphic().getSize().evaluate((Object)filterFactory, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledPointSymb, (Object)pointSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    protected void visitLineSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer();
            lineSymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            lineSymb.getStroke().setWidth((Expression)filterFactory.literal(size));
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledLineSymb.getStroke().getWidth().evaluate((Object)filterFactory, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    protected void visitPolygonSymbolizerTest(double scaleMetersToPixel, Unit<Length> uom) {
        try {
            UomRescaleStyleVisitor visitor = null;
            double size = 100.0;
            double expectedRescaledSize = this.computeExpectedRescaleSize(size, scaleMetersToPixel, uom);
            StyleBuilder styleBuilder = new StyleBuilder();
            PolygonSymbolizerImpl polySymb = (PolygonSymbolizerImpl)styleBuilder.createPolygonSymbolizer();
            polySymb.setUnitOfMeasure(uom);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            polySymb.getStroke().setWidth((Expression)filterFactory.literal(size));
            visitor = new UomRescaleStyleVisitor(scaleMetersToPixel);
            polySymb.accept((StyleVisitor)visitor);
            PolygonSymbolizer rescaledPolySymb = (PolygonSymbolizer)visitor.getCopy();
            double rescaledSize = (Double)rescaledPolySymb.getStroke().getWidth().evaluate((Object)filterFactory, Double.class);
            Assert.assertEquals((long)Math.round(expectedRescaledSize), (long)Math.round(rescaledSize));
            Assert.assertNotSame((Object)rescaledPolySymb, (Object)polySymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    public void testVisitPointSymbolizer_ScalePixelNull() {
        this.visitPointSymbolizerTest(10.0, null);
    }

    public void testVisitPointSymbolizer_ScalePixelExplicit() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitPointSymbolizer_ScaleMeter1() {
        this.visitPointSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPointSymbolizer_ScaleMeter10() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPointSymbolizer_ScaleFoot1() {
        this.visitPointSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitPointSymbolizer_ScaleFoot10() {
        this.visitPointSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitLineSymbolizer_ScalePixelNull() {
        this.visitLineSymbolizerTest(10.0, null);
    }

    public void testVisitLineSymbolizer_ScalePixelExplicit() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitLineSymbolizer_ScaleMeter1() {
        this.visitLineSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitLineSymbolizer_ScaleMeter10() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitLineSymbolizer_ScaleFoot1() {
        this.visitLineSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitLineSymbolizer_ScaleFoot10() {
        this.visitLineSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitPolygonSymbolizer_ScalePixelNull() {
        this.visitPolygonSymbolizerTest(10.0, null);
    }

    public void testVisitPolygonSymbolizer_ScalePixelExplicit() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)NonSI.PIXEL);
    }

    public void testVisitPolygonSymbolizer_ScaleMeter1() {
        this.visitPolygonSymbolizerTest(1.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPolygonSymbolizer_ScaleMeter10() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)SI.METER);
    }

    public void testVisitPolygonSymbolizer_ScaleFoot1() {
        this.visitPolygonSymbolizerTest(1.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitPolygonSymbolizer_ScaleFoot10() {
        this.visitPolygonSymbolizerTest(10.0, (Unit<Length>)NonSI.FOOT);
    }

    public void testVisitLineSymbolizer_NullStroke() {
        try {
            UomRescaleStyleVisitor visitor = null;
            StyleBuilder styleBuilder = new StyleBuilder();
            Stroke stroke = null;
            LineSymbolizerImpl lineSymb = (LineSymbolizerImpl)styleBuilder.createLineSymbolizer(stroke);
            lineSymb.setUnitOfMeasure(SI.METER);
            visitor = new UomRescaleStyleVisitor(10.0);
            lineSymb.accept((StyleVisitor)visitor);
            LineSymbolizer rescaledLineSymb = (LineSymbolizer)visitor.getCopy();
            Assert.assertNull((Object)rescaledLineSymb.getStroke());
            Assert.assertNotSame((Object)rescaledLineSymb, (Object)lineSymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }

    public void testVisitPolygonSymbolizer_NullStroke() {
        try {
            UomRescaleStyleVisitor visitor = null;
            StyleBuilder styleBuilder = new StyleBuilder();
            Fill fill = styleBuilder.createFill(Color.RED);
            PolygonSymbolizerImpl polySymb = (PolygonSymbolizerImpl)styleBuilder.createPolygonSymbolizer(null, fill);
            visitor = new UomRescaleStyleVisitor(10.0);
            polySymb.accept((StyleVisitor)visitor);
            PolygonSymbolizer rescaledPolySymb = (PolygonSymbolizer)visitor.getCopy();
            Assert.assertEquals((Object)polySymb.getFill(), (Object)rescaledPolySymb.getFill());
            Assert.assertNull((Object)rescaledPolySymb.getStroke());
            Assert.assertNotSame((Object)rescaledPolySymb, (Object)polySymb);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Assert.fail((String)(e2.getClass().getSimpleName() + " should not be thrown."));
        }
    }
}

