/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class BBoxExpressionImpl
extends LiteralExpressionImpl
implements BBoxExpression {
    private GeometryFactory gfac = new GeometryFactory();

    protected BBoxExpressionImpl() throws IllegalFilterException {
        this(new Envelope());
    }

    protected BBoxExpressionImpl(Envelope env) throws IllegalFilterException {
        this.expressionType = (short)104;
        this.setBounds(env);
    }

    public final void setBounds(Envelope env) throws IllegalFilterException {
        Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        LinearRing ring = null;
        try {
            ring = this.gfac.createLinearRing(coords);
        }
        catch (TopologyException tex) {
            throw new IllegalFilterException(tex.toString());
        }
        Polygon polygon = this.gfac.createPolygon(ring, null);
        if (env instanceof ReferencedEnvelope) {
            ReferencedEnvelope refEnv = (ReferencedEnvelope)env;
            polygon.setUserData((Object)refEnv.getCoordinateReferenceSystem());
        }
        super.setValue(polygon);
    }
}

