/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDataStore
extends AbstractDataStore {
    SimpleFeatureType featureType;
    FeatureCollection<SimpleFeatureType, SimpleFeature> collection;

    public CollectionDataStore(SimpleFeatureType schema) {
        this.collection = FeatureCollections.newCollection();
        this.featureType = schema;
        this.collection.addListener((CollectionListener)new FeatureCollectionListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.collection = collection;
        if (collection.size() == 0) {
            this.featureType = FeatureTypes.EMPTY;
        } else {
            Iterator iter = null;
            try {
                iter = collection.iterator();
                this.featureType = ((SimpleFeature)iter.next()).getFeatureType();
            }
            finally {
                if (iter != null) {
                    collection.close(iter);
                }
            }
        }
        collection.addListener((CollectionListener)new FeatureCollectionListener());
    }

    @Override
    public String[] getTypeNames() {
        return new String[]{this.featureType.getTypeName()};
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (typeName != null && typeName.equals(this.featureType.getTypeName())) {
            return this.featureType;
        }
        throw new IOException(typeName + " not available");
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(typeName), this.collection.features());
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getCollection() {
        return this.collection;
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws SchemaNotFoundException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        return this.getBoundsInternal(query);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) {
        FeatureIterator iterator = this.collection.features();
        ReferencedEnvelope envelope = new ReferencedEnvelope(this.featureType.getCoordinateReferenceSystem());
        if (iterator.hasNext()) {
            int count = 1;
            Filter filter = query.getFilter();
            while (iterator.hasNext() && count < query.getMaxFeatures()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                if (!filter.evaluate((Object)feature)) continue;
                ++count;
                envelope.expandToInclude(((Geometry)feature.getDefaultGeometry()).getEnvelopeInternal());
            }
        }
        return envelope;
    }

    @Override
    protected int getCount(Query query) throws IOException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        int count = 0;
        FeatureIterator iterator = this.collection.features();
        Filter filter = query.getFilter();
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            if (!filter.evaluate((Object)iterator.next())) continue;
            ++count;
        }
        return count;
    }

    private class FeatureCollectionListener
    implements CollectionListener {
        private FeatureCollectionListener() {
        }

        public void collectionChanged(CollectionEvent tce) {
            String typeName = CollectionDataStore.this.featureType.getTypeName();
            ReferencedEnvelope bounds = null;
            bounds = CollectionDataStore.this.getBoundsInternal(Query.ALL);
            switch (tce.getEventType()) {
                case 0: {
                    CollectionDataStore.this.listenerManager.fireFeaturesAdded(typeName, Transaction.AUTO_COMMIT, bounds, false);
                    break;
                }
                case 2: {
                    CollectionDataStore.this.listenerManager.fireFeaturesChanged(typeName, Transaction.AUTO_COMMIT, bounds, false);
                    break;
                }
                case 1: {
                    CollectionDataStore.this.listenerManager.fireFeaturesRemoved(typeName, Transaction.AUTO_COMMIT, bounds, false);
                }
            }
        }
    }
}

