/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdaptorFeatureCollection
implements FeatureCollection<SimpleFeatureType, SimpleFeature> {
    protected final Set open = new HashSet();
    protected List listeners = new ArrayList();
    protected String id;
    protected SimpleFeatureType schema;

    public AdaptorFeatureCollection(String id, SimpleFeatureType memberType) {
        this.id = id == null ? "featureCollection" : id;
        this.schema = memberType;
    }

    public FeatureIterator<SimpleFeature> features() {
        DelegateFeatureIterator<SimpleFeature> iter = new DelegateFeatureIterator<SimpleFeature>(this, this.openIterator());
        this.open.add(iter);
        return iter;
    }

    public void close(FeatureIterator<SimpleFeature> close) {
        this.closeIterator(close);
        this.open.remove(close);
    }

    public void closeIterator(FeatureIterator<SimpleFeature> close) {
        DelegateFeatureIterator iter = (DelegateFeatureIterator)close;
        this.closeIterator(iter.delegate);
        iter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        Iterator<SimpleFeature> iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                if (size > 0.0f) {
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                }
                try {
                    SimpleFeature feature = iterator.next();
                    visitor.visit((Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
            }
        }
        finally {
            progress.complete();
            this.close(iterator);
        }
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> subList(Filter filter) {
        return new SubFeatureList((FeatureCollection<SimpleFeatureType, SimpleFeature>)this, filter);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> sort(SortBy order) {
        return new SubFeatureList((FeatureCollection<SimpleFeatureType, SimpleFeature>)this, order);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            Object[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.close(it);
        }
    }

    public boolean add(SimpleFeature o) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Iterator<SimpleFeature> e = this.iterator();
        try {
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    e.remove();
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    e.remove();
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        Iterator e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        boolean modified = false;
        Iterator e = c.iterator();
        try {
            while (e.hasNext()) {
                if (!this.add((SimpleFeature)e.next())) continue;
                modified = true;
            }
        }
        finally {
            if (c instanceof FeatureCollection) {
                FeatureCollection other = (FeatureCollection)c;
                other.close(e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(FeatureCollection c) {
        boolean modified = false;
        Iterator e = c.iterator();
        try {
            while (e.hasNext()) {
                if (!this.add((SimpleFeature)e.next())) continue;
                modified = true;
            }
        }
        finally {
            c.close(e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                if (!c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        boolean modified = false;
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Iterator<SimpleFeature> e = this.iterator();
        try {
            while (e.hasNext()) {
                e.next();
                e.remove();
            }
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator<SimpleFeature> i = this.iterator();
        try {
            boolean hasNext = i.hasNext();
            while (hasNext) {
                SimpleFeature o = i.next();
                buf.append(o == this ? "(this Collection)" : String.valueOf(o));
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            String string = buf.toString();
            return string;
        }
        finally {
            this.close(i);
        }
    }

    public final Set getOpenIterators() {
        return this.open;
    }

    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        this.open.add(iterator);
        return iterator;
    }

    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(Iterator close) {
        if (close == null) {
            return;
        }
        try {
            this.closeIterator(close);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.open.remove(close);
        }
    }

    protected abstract Iterator<SimpleFeature> openIterator();

    protected abstract void closeIterator(Iterator<SimpleFeature> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Iterator resourceIterator;
            Object resource = i.next();
            if (resource instanceof Iterator) {
                resourceIterator = (Iterator)resource;
                try {
                    this.closeIterator(resourceIterator);
                }
                catch (Throwable e) {}
                continue;
                finally {
                    i.remove();
                    continue;
                }
            }
            if (!(resource instanceof FeatureIterator)) continue;
            resourceIterator = (FeatureIterator)resource;
            try {
                this.closeIterator((FeatureIterator<SimpleFeature>)resourceIterator);
            }
            catch (Throwable e) {}
            continue;
            finally {
                i.remove();
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public final void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public final void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public ReferencedEnvelope getBounds() {
        throw new UnsupportedOperationException("subclasses should override");
    }
}

