/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;

public class LiteCoordinateSequence
extends PackedCoordinateSequence {
    private double[] coords;
    private int size;

    public LiteCoordinateSequence(double[] coords, int dimensions) {
        this.init(coords, dimensions);
    }

    void init(double[] coords, int dimensions) {
        this.dimension = dimensions;
        if (dimensions < 2) {
            throw new IllegalArgumentException("Invalid dimensions, must be at least 2");
        }
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
        this.size = coords.length / this.dimension;
    }

    public LiteCoordinateSequence(double[] coords) {
        this.init(coords, 2);
    }

    public LiteCoordinateSequence(float[] coordinates, int dimension) {
        double[] dcoords = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            dcoords[i] = coordinates[i];
        }
        this.init(dcoords, dimension);
    }

    public LiteCoordinateSequence(float[] coordinates) {
        this(coordinates, 2);
    }

    public LiteCoordinateSequence(Coordinate[] coordinates) {
        if (coordinates == null) {
            coordinates = new Coordinate[]{};
        }
        this.dimension = 2;
        this.coords = new double[coordinates.length * this.dimension];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coords[i * this.dimension] = coordinates[i].x;
            if (this.dimension < 2) continue;
            this.coords[i * this.dimension + 1] = coordinates[i].y;
        }
        this.size = coordinates.length;
    }

    public LiteCoordinateSequence(int size, int dimension) {
        this.dimension = dimension;
        this.coords = new double[size * this.dimension];
        this.size = this.coords.length / dimension;
    }

    public LiteCoordinateSequence(LiteCoordinateSequence seq) {
        this.dimension = seq.dimension;
        this.size = seq.size;
        double[] orig = seq.getArray();
        this.coords = new double[orig.length];
        System.arraycopy(orig, 0, this.coords, 0, this.coords.length);
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        double z = this.dimension == 2 ? Double.NaN : this.coords[i * this.dimension + 2];
        return new Coordinate(x, y, z);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new LiteCoordinateSequence(clone, this.dimension);
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public double getX(int index) {
        return this.coords[index * this.dimension];
    }

    public double getY(int index) {
        return this.coords[index * this.dimension + 1];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        double miny;
        double minx;
        double maxx = minx = this.coords[0];
        double maxy = miny = this.coords[1];
        for (int i = 0; i < this.coords.length; i += this.dimension) {
            double x = this.coords[i];
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            double y = this.coords[i + 1];
            if (y < miny) {
                miny = y;
                continue;
            }
            if (!(y > maxy)) continue;
            maxy = y;
        }
        env.expandToInclude(minx, miny);
        env.expandToInclude(maxx, maxy);
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.coords = coords2;
        this.size = this.coords.length / this.dimension;
        this.coordRef = null;
    }

    public void setArray(double[] coords2, int dimension) {
        this.coords = coords2;
        this.dimension = dimension;
        this.size = this.coords.length / dimension;
        this.coordRef = null;
    }

    public double[] getXYArray() {
        if (this.dimension == 2) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * 2];
        for (int t = 0; t < n; ++t) {
            result[t * 2] = this.getOrdinate(t, 0);
            result[t * 2 + 1] = this.getOrdinate(t, 1);
        }
        return result;
    }
}

