/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Displacement;
import org.opengis.style.GraphicStroke;
import org.opengis.style.GraphicalSymbol;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicImpl
implements Graphic,
Cloneable {
    private final List<GraphicalSymbol> graphics = new ArrayList<GraphicalSymbol>();
    private AnchorPointImpl anchor;
    private Expression gap;
    private Expression initialGap;
    private FilterFactory filterFactory;
    private String geometryPropertyName = "";
    private Expression rotation = null;
    private Expression size = null;
    private DisplacementImpl displacement = null;
    private Expression opacity = null;

    protected GraphicImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public GraphicImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    public GraphicImpl(FilterFactory factory, org.opengis.style.AnchorPoint anchor, Expression gap, Expression initialGap) {
        this.filterFactory = factory;
        this.anchor = AnchorPointImpl.cast(anchor);
        this.gap = gap == null ? ConstantExpression.constant((int)0) : gap;
        this.initialGap = initialGap == null ? ConstantExpression.constant((int)0) : initialGap;
    }

    @Deprecated
    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public List<GraphicalSymbol> graphicalSymbols() {
        return this.graphics;
    }

    @Deprecated
    public ExternalGraphic[] getExternalGraphics() {
        ArrayList<ExternalGraphic> exts = new ArrayList<ExternalGraphic>();
        for (GraphicalSymbol s : this.graphics) {
            if (!(s instanceof ExternalGraphic)) continue;
            exts.add((ExternalGraphic)s);
        }
        return exts.toArray(new ExternalGraphic[0]);
    }

    @Deprecated
    public void setExternalGraphics(ExternalGraphic[] externalGraphics) {
        ArrayList<GraphicalSymbol> currExternalGraphics = new ArrayList<GraphicalSymbol>();
        for (GraphicalSymbol s : this.graphics) {
            if (!(s instanceof ExternalGraphic)) continue;
            currExternalGraphics.add(s);
        }
        this.graphics.removeAll(currExternalGraphics);
        for (ExternalGraphic g : externalGraphics) {
            this.graphics.add((GraphicalSymbol)g);
        }
    }

    @Deprecated
    public void addExternalGraphic(ExternalGraphic externalGraphic) {
        this.graphics.add((GraphicalSymbol)externalGraphic);
    }

    @Deprecated
    public Mark[] getMarks() {
        ArrayList<Mark> exts = new ArrayList<Mark>();
        for (GraphicalSymbol s : this.graphics) {
            if (!(s instanceof Mark)) continue;
            exts.add((Mark)s);
        }
        return exts.toArray(new Mark[0]);
    }

    @Deprecated
    public void setMarks(Mark[] marks) {
        ArrayList<GraphicalSymbol> currMarks = new ArrayList<GraphicalSymbol>();
        for (GraphicalSymbol s : this.graphics) {
            if (!(s instanceof Mark)) continue;
            currMarks.add(s);
        }
        this.graphics.removeAll(currMarks);
        for (Mark g : marks) {
            this.graphics.add((GraphicalSymbol)g);
        }
    }

    @Deprecated
    public void addMark(Mark mark) {
        this.graphics.add((GraphicalSymbol)mark);
    }

    @Deprecated
    public Symbol[] getSymbols() {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (GraphicalSymbol graphic : this.graphics) {
            if (!(graphic instanceof Symbol)) continue;
            symbols.add((Symbol)graphic);
        }
        return symbols.toArray(new Symbol[0]);
    }

    @Deprecated
    public void setSymbols(Symbol[] symbols) {
        this.graphics.clear();
        for (Symbol g : symbols) {
            this.graphics.add((GraphicalSymbol)g);
        }
    }

    @Deprecated
    public void addSymbol(Symbol symbol) {
        this.graphics.add((GraphicalSymbol)symbol);
    }

    public AnchorPointImpl getAnchorPoint() {
        return this.anchor;
    }

    public void setAnchorPoint(AnchorPoint anchor) {
        this.anchor = AnchorPointImpl.cast((org.opengis.style.AnchorPoint)anchor);
    }

    public void setAnchorPoint(org.opengis.style.AnchorPoint anchorPoint) {
        this.anchor = AnchorPointImpl.cast(anchorPoint);
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public Expression getSize() {
        return this.size;
    }

    public DisplacementImpl getDisplacement() {
        return this.displacement;
    }

    public Expression getInitialGap() {
        return this.initialGap;
    }

    public void setInitialGap(Expression initialGap) {
        this.initialGap = initialGap;
    }

    public Expression getGap() {
        return this.gap;
    }

    public void setGap(Expression gap) {
        this.gap = gap;
    }

    public void setDisplacement(Displacement offset) {
        this.displacement = DisplacementImpl.cast(offset);
    }

    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    @Deprecated
    public void setOpacity(double opacity) {
        this.setOpacity((Expression)this.filterFactory.literal(opacity));
    }

    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    @Deprecated
    public void setRotation(double rotation) {
        this.setRotation((Expression)this.filterFactory.literal(rotation));
    }

    public void setSize(Expression size) {
        this.size = size;
    }

    @Deprecated
    public void setSize(int size) {
        this.setSize((Expression)this.filterFactory.literal(size));
    }

    @Deprecated
    public void setGeometryPropertyName(String name) {
        this.geometryPropertyName = name;
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((GraphicStroke)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Graphic)this);
    }

    public Object clone() {
        GraphicImpl clone;
        try {
            clone = (GraphicImpl)super.clone();
            clone.graphics.clear();
            clone.graphics.addAll(this.graphics);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.graphics != null) {
            result = 1000003 * result + ((Object)this.graphics).hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof GraphicImpl) {
            GraphicImpl other = (GraphicImpl)oth;
            return Utilities.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && Utilities.equals((Object)this.size, (Object)other.size) && Utilities.equals((Object)this.rotation, (Object)other.rotation) && Utilities.equals((Object)this.opacity, (Object)other.opacity) && Arrays.equals(this.getMarks(), other.getMarks()) && Arrays.equals(this.getExternalGraphics(), other.getExternalGraphics()) && Arrays.equals(this.getSymbols(), other.getSymbols());
        }
        return false;
    }

    static GraphicImpl cast(org.opengis.style.Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        if (graphic instanceof GraphicImpl) {
            return (GraphicImpl)graphic;
        }
        GraphicImpl copy = new GraphicImpl();
        copy.setAnchorPoint(graphic.getAnchorPoint());
        copy.setDisplacement(graphic.getDisplacement());
        if (graphic.graphicalSymbols() != null) {
            for (GraphicalSymbol item : graphic.graphicalSymbols()) {
                if (item instanceof org.opengis.style.ExternalGraphic) {
                    copy.graphicalSymbols().add(ExternalGraphicImpl.cast(item));
                    continue;
                }
                if (!(item instanceof org.opengis.style.Mark)) continue;
                copy.graphicalSymbols().add((GraphicalSymbol)MarkImpl.cast(item));
            }
        }
        return copy;
    }
}

