/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadDescriptorMT;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverageio.GridCoverageUtilities;
import org.geotools.coverageio.RasterLayerRequest;
import org.geotools.coverageio.RasterLayerResponse;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.PrjFileReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.WorldFileReader;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class BaseGridCoverage2DReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER;
    private final String worldFileExt;
    private final ImageReaderSpi readerSPI;
    private GeneralEnvelope nativeEnvelope;
    private CoordinateReferenceSystem nativeCRS;
    private File inputFile;
    private String localCoverageName;
    private GridEnvelope2D nativeGridRange;
    private String parentPath;
    private ServiceInfo serviceInfo;
    private ResourceInfo resourceInfo;

    protected abstract void setCoverageProperties(ImageReader var1) throws IOException;

    /*
     * Loose catch block
     */
    protected BaseGridCoverage2DReader(Object input, Hints hints, String worldFileExtension, ImageReaderSpi formatSpecificSpi) throws DataSourceException {
        block25: {
            Exception e222;
            FileImageInputStreamExtImpl fiis;
            ImageReader reader;
            block20: {
                block21: {
                    super(input, hints);
                    this.nativeEnvelope = null;
                    this.nativeCRS = null;
                    this.inputFile = null;
                    this.localCoverageName = "geotools_coverage";
                    this.nativeGridRange = null;
                    reader = null;
                    fiis = null;
                    this.readerSPI = formatSpecificSpi;
                    this.worldFileExt = worldFileExtension;
                    this.checkSource(input);
                    reader = this.readerSPI.createReaderInstance();
                    fiis = new FileImageInputStreamExtImpl(this.inputFile);
                    reader.setInput(fiis);
                    this.setCoverageProperties(reader);
                    this.getResolutionInfo(reader);
                    Object var9_7 = null;
                    if (reader == null) break block20;
                    try {
                        reader.reset();
                    }
                    catch (Exception e222) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block21;
                        LOGGER.log(Level.FINE, e222.getLocalizedMessage(), e222);
                    }
                }
                try {
                    reader.dispose();
                }
                catch (Exception e222) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block20;
                    LOGGER.log(Level.FINE, e222.getLocalizedMessage(), e222);
                }
            }
            if (fiis != null) {
                try {
                    fiis.close();
                }
                catch (Exception e222) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e222.getLocalizedMessage(), e222);
                    }
                }
            }
            break block25;
            {
                catch (IOException e3) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e3.getLocalizedMessage(), e3);
                    }
                    throw new DataSourceException((Throwable)e3);
                }
                catch (TransformException e4) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e4.getLocalizedMessage(), e4);
                    }
                    throw new DataSourceException((Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Exception e222;
                    block23: {
                        Object var9_8 = null;
                        if (reader != null) {
                            block22: {
                                try {
                                    reader.reset();
                                }
                                catch (Exception e222) {
                                    if (!LOGGER.isLoggable(Level.FINE)) break block22;
                                    LOGGER.log(Level.FINE, e222.getLocalizedMessage(), e222);
                                }
                            }
                            try {
                                reader.dispose();
                            }
                            catch (Exception e222) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block23;
                                LOGGER.log(Level.FINE, e222.getLocalizedMessage(), e222);
                            }
                        }
                    }
                    if (fiis != null) {
                        try {
                            fiis.close();
                        }
                        catch (Exception e222) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block24;
                            LOGGER.log(Level.FINE, e222.getLocalizedMessage(), e222);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    Hints getHints() {
        return this.hints;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    private void checkSource(Object input) throws UnsupportedEncodingException, DataSourceException, IOException, FileNotFoundException {
        File sourceFile;
        this.source = null;
        if (input instanceof URL) {
            URL sourceURL = (URL)input;
            this.source = sourceURL;
            if (sourceURL.getProtocol().compareToIgnoreCase("file") == 0) {
                this.inputFile = new File(URLDecoder.decode(sourceURL.getFile(), "UTF-8"));
                input = this.inputFile;
            } else {
                throw new IllegalArgumentException("Unsupported input type");
            }
        }
        if (input instanceof FileImageInputStreamExt) {
            if (this.source == null) {
                this.source = input;
            }
            this.inputFile = ((FileImageInputStreamExt)input).getFile();
            input = this.inputFile;
        }
        if (input instanceof File) {
            sourceFile = (File)input;
            if (this.source == null) {
                this.source = sourceFile;
            }
            if (this.inputFile == null) {
                this.inputFile = sourceFile;
            }
            if (!sourceFile.exists() || sourceFile.isDirectory() || !sourceFile.canRead()) {
                throw new DataSourceException("Provided file does not exist or is a directory or is not readable!");
            }
        } else {
            throw new IllegalArgumentException("Unsupported input type");
        }
        this.parentPath = sourceFile.getParent();
        this.localCoverageName = sourceFile.getName();
        int dotIndex = this.localCoverageName.lastIndexOf(".");
        this.localCoverageName = dotIndex == -1 ? this.localCoverageName : this.localCoverageName.substring(0, dotIndex);
    }

    private void getResolutionInfo(ImageReader reader) throws IOException, TransformException {
        Rectangle originalDim = new Rectangle(0, 0, reader.getWidth(0), reader.getHeight(0));
        if (this.getCoverageGridRange() == null) {
            this.setCoverageGridRange(new GridEnvelope2D(originalDim));
        }
        this.highestRes = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)this.raster2Model));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("Highest Resolution = [").append(this.highestRes[0]).append(",").append(this.highestRes[1]).toString());
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        RasterLayerRequest request = new RasterLayerRequest(params, this);
        return (GridCoverage2D)this.requestCoverage(request).getGridCoverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parsePRJFile() {
        PrjFileReader projReader;
        block15: {
            String prjPath = null;
            this.setCoverageCRS(null);
            prjPath = this.parentPath + File.separatorChar + this.localCoverageName + ".prj";
            projReader = null;
            File prj = new File(prjPath);
            if (!prj.exists()) break block15;
            projReader = new PrjFileReader((ReadableByteChannel)new FileInputStream(prj).getChannel());
            this.setCoverageCRS(projReader.getCoordinateReferenceSystem());
        }
        Object var5_7 = null;
        if (projReader == null) return;
        try {
            projReader.close();
            return;
        }
        catch (IOException e2) {
            if (!LOGGER.isLoggable(Level.WARNING)) return;
            LOGGER.log(Level.WARNING, e2.getLocalizedMessage(), e2);
        }
        return;
        {
            catch (FileNotFoundException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                Object var5_8 = null;
                if (projReader == null) return;
                try {
                    projReader.close();
                    return;
                }
                catch (IOException e2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return;
                    LOGGER.log(Level.WARNING, e2.getLocalizedMessage(), e2);
                }
                return;
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                Object var5_9 = null;
                if (projReader == null) return;
                try {
                    projReader.close();
                    return;
                }
                catch (IOException e2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return;
                    LOGGER.log(Level.WARNING, e2.getLocalizedMessage(), e2);
                }
                return;
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                Object var5_10 = null;
                if (projReader == null) return;
                try {
                    projReader.close();
                    return;
                }
                catch (IOException e2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return;
                    LOGGER.log(Level.WARNING, e2.getLocalizedMessage(), e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (projReader == null) throw throwable;
            try {
                projReader.close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!LOGGER.isLoggable(Level.WARNING)) throw throwable;
                LOGGER.log(Level.WARNING, e2.getLocalizedMessage(), e2);
            }
            throw throwable;
        }
    }

    protected void parseWorldFile() throws IOException {
        block7: {
            String worldFilePath = new StringBuffer(this.parentPath).append(GridCoverageUtilities.SEPARATOR).append(this.localCoverageName).toString();
            File file2Parse = null;
            boolean worldFileExists = false;
            if (this.worldFileExt != null && this.worldFileExt.length() > 0) {
                file2Parse = new File(worldFilePath + this.worldFileExt);
                worldFileExists = file2Parse.exists();
            }
            if (!worldFileExists) {
                file2Parse = new File(worldFilePath + ".wld");
                worldFileExists = file2Parse.exists();
            }
            if (worldFileExists) {
                WorldFileReader reader = new WorldFileReader(file2Parse);
                this.raster2Model = reader.getTransform();
                MathTransform tempTransform = PixelTranslation.translate((MathTransform)this.raster2Model, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                try {
                    GeneralEnvelope gridRange = new GeneralEnvelope(this.getCoverageGridRange().getBounds2D());
                    GeneralEnvelope coverageEnvelope = CRS.transform((MathTransform)tempTransform, (Envelope)gridRange);
                    this.setCoverageEnvelope(coverageEnvelope);
                }
                catch (TransformException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                catch (IllegalStateException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public synchronized ServiceInfo getInfo() {
        if (this.serviceInfo != null) {
            return new DefaultServiceInfo(this.serviceInfo);
        }
        DefaultServiceInfo localInfo = new DefaultServiceInfo();
        this.serviceInfo = localInfo;
        localInfo.setDescription(this.source.toString());
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            localInfo.setTitle(url.getFile());
            try {
                localInfo.setSource(url.toURI());
            }
            catch (URISyntaxException e) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                localInfo.setTitle(file.getName());
            }
            localInfo.setSource(file.toURI());
        }
        return new DefaultServiceInfo((ServiceInfo)localInfo);
    }

    protected void writePrj(File outLocation, String wkt) throws IOException {
        this.writePrj(new BufferedWriter(new FileWriter(outLocation), 4096), wkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePrj(BufferedWriter writer, String wkt) {
        try {
            try {
                writer.write(wkt);
                this.close(writer);
                Object var5_3 = null;
                this.close(writer);
                return;
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                Object var5_4 = null;
                this.close(writer);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close(writer);
            throw throwable;
        }
    }

    private void close(BufferedWriter writer) {
        block2: {
            try {
                writer.close();
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
            }
        }
    }

    public synchronized ResourceInfo getInfo(String subname) {
        if (this.resourceInfo != null) {
            return new DefaultResourceInfo(this.resourceInfo);
        }
        DefaultResourceInfo localInfo = new DefaultResourceInfo();
        this.resourceInfo = localInfo;
        localInfo.setName(subname);
        localInfo.setBounds(new ReferencedEnvelope((Envelope)this.getOriginalEnvelope()));
        localInfo.setCRS(this.getCrs());
        localInfo.setTitle(subname);
        return new DefaultResourceInfo(this.resourceInfo);
    }

    private RasterLayerResponse requestCoverage(RasterLayerRequest request) {
        RasterLayerResponse response = new RasterLayerResponse(request, this.coverageFactory, this.readerSPI);
        try {
            response.compute();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        return response;
    }

    protected void setCoverageCRS(CoordinateReferenceSystem coverageCRS) {
        this.nativeCRS = coverageCRS;
    }

    protected CoordinateReferenceSystem getCoverageCRS() {
        return this.nativeCRS;
    }

    protected void setCoverageEnvelope(GeneralEnvelope coverageEnvelope) {
        this.nativeEnvelope = coverageEnvelope;
    }

    protected GeneralEnvelope getCoverageEnvelope() {
        return this.nativeEnvelope;
    }

    protected void setCoverageGridRange(GridEnvelope2D coverageGridRange) {
        this.nativeGridRange = coverageGridRange;
    }

    protected GridEnvelope2D getCoverageGridRange() {
        return this.nativeGridRange;
    }

    protected File getInputFile() {
        return this.inputFile;
    }

    public String getCoverageName() {
        return this.localCoverageName;
    }

    public int getGridCoverageCount() {
        return 1;
    }

    public boolean hasMoreGridCoverages() {
        return false;
    }

    static {
        block2: {
            LOGGER = Logging.getLogger((String)"org.geotools.coverageio.gdal");
            try {
                ImageReadDescriptorMT.register((JAI)JAI.getDefaultInstance());
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
    }
}

