/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryCreator
extends FactoryRegistry {
    private static final Class[] HINTS_ARGUMENT = new Class[]{Hints.class};
    private final Map<Class<?>, List<Reference<?>>> cache = new HashMap();
    private final Set<Class<?>> underConstruction = new HashSet();

    public FactoryCreator(Class<?> category) {
        super(category);
    }

    public FactoryCreator(Class<?>[] categories) {
        super(categories);
    }

    public FactoryCreator(Collection<Class<?>> categories) {
        super(categories);
    }

    @Override
    final <T> List<Reference<T>> getCachedProviders(Class<T> category) {
        List<Reference<T>> c = this.cache.get(category);
        if (c == null) {
            c = new LinkedList();
            this.cache.put(category, c);
        }
        List<Reference<T>> cheat = c;
        return cheat;
    }

    private <T> void cache(Class<T> category, T factory) {
        this.getCachedProviders(category).add(new WeakReference<T>(factory));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public <T> T getServiceProvider(Class<T> category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        block12: {
            try {
                return super.getServiceProvider(category, filter, hints, key);
            }
            catch (FactoryNotFoundException exception) {
                notFound = exception;
                if (hints == null || key == null) {
                    types = null;
                    break block12;
                }
                hint = hints.get(key);
                if (hint == null) {
                    types = null;
                    break block12;
                }
                types = hint instanceof Class[] != false ? (Class[])hint : new Class[]{(Class)hint};
                length = types.length;
                i = 0;
                ** while (i < length)
            }
lbl-1000:
            // 1 sources

            {
                type = types[i];
                if (type != null && category.isAssignableFrom(type) && !Modifier.isAbstract(modifiers = type.getModifiers()) && (candidate = this.createSafe(category, type, hints)) != null) {
                    if (this.isAcceptable(candidate, category, hints, filter)) {
                        this.cache(category, candidate);
                        return candidate;
                    }
                    FactoryCreator.dispose(candidate);
                }
                ++i;
                continue;
            }
        }
        it = this.getUnfilteredProviders(category);
        while (it.hasNext()) {
            factory = it.next();
            implementation = factory.getClass();
            if (types != null && !FactoryCreator.isTypeOf(types, implementation) || filter != null && !filter.filter(factory)) continue;
            try {
                candidate = this.createSafe(category, implementation, hints);
            }
            catch (FactoryNotFoundException exception) {
                Logging.recoverableException(FactoryCreator.LOGGER, FactoryCreator.class, "getServiceProvider", exception);
                continue;
            }
            catch (FactoryRegistryException exception) {
                if (exception.getCause() instanceof NoSuchMethodException) continue;
                throw exception;
            }
            if (candidate == null) continue;
            if (this.isAcceptable(candidate, category, hints, filter)) {
                this.cache(category, candidate);
                return candidate;
            }
            FactoryCreator.dispose(candidate);
        }
        throw notFound;
    }

    private static boolean isTypeOf(Class<?>[] types, Class<?> implementation) {
        int i = 0;
        while (i < types.length) {
            if (types[i].isAssignableFrom(implementation)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private <T> T createSafe(Class<T> category, Class<?> implementation, Hints hints) {
        if (!this.underConstruction.add(implementation)) {
            return null;
        }
        try {
            T t = this.createServiceProvider(category, implementation, hints);
            return t;
        }
        finally {
            if (!this.underConstruction.remove(implementation)) {
                throw new AssertionError();
            }
        }
    }

    protected <T> T createServiceProvider(Class<T> category, Class<?> implementation, Hints hints) throws FactoryRegistryException {
        Throwable cause;
        block8: {
            try {
                try {
                    return category.cast(implementation.getConstructor(HINTS_ARGUMENT).newInstance(hints));
                }
                catch (NoSuchMethodException exception2) {
                    cause = exception2;
                    try {
                        return category.cast(implementation.getConstructor(null).newInstance(null));
                    }
                    catch (NoSuchMethodException exception2) {
                    }
                }
            }
            catch (IllegalAccessException exception) {
                cause = exception;
            }
            catch (InstantiationException exception) {
                cause = exception;
            }
            catch (InvocationTargetException exception) {
                cause = exception.getCause();
                if (!(cause instanceof FactoryRegistryException)) break block8;
                throw (FactoryRegistryException)cause;
            }
        }
        throw new FactoryRegistryException(Errors.format(23, implementation), cause);
    }

    private static void dispose(Object factory) {
    }
}

