/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import org.opengis.util.Cloneable;

public class Line
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2185952238314399110L;
    private static final double EPS = 1.0E-12;
    private double slope;
    private double y0;
    private double x0;

    public Line() {
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        this.slope = Double.NaN;
    }

    public Line(double slope, double y0) {
        this.slope = slope;
        this.y0 = y0;
        this.x0 = -y0 / slope;
    }

    public void setLine(double slope, double y0) {
        this.slope = slope;
        this.y0 = y0;
        this.x0 = -y0 / slope;
    }

    public void setLine(Line2D line) {
        this.setLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    private void setLine(double x1, double y1, double x2, double y2) {
        this.slope = (y2 - y1) / (x2 - x1);
        this.x0 = x2 - y2 / this.slope;
        this.y0 = y2 - this.slope * x2;
        if (Double.isNaN(this.x0) && this.slope == 0.0) {
            this.x0 = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(this.y0) && Double.isInfinite(this.slope)) {
            this.y0 = Double.POSITIVE_INFINITY;
        }
    }

    public double setLine(double[] x, double[] y) throws MismatchedSizeException {
        int N = x.length;
        if (N != y.length) {
            throw new MismatchedSizeException();
        }
        int count = 0;
        double mean_x = 0.0;
        double mean_y = 0.0;
        int i = 0;
        while (i < N) {
            double xi = x[i];
            double yi = y[i];
            if (!Double.isNaN(xi) && !Double.isNaN(yi)) {
                mean_x += xi;
                mean_y += yi;
                ++count;
            }
            ++i;
        }
        mean_x /= (double)count;
        mean_y /= (double)count;
        double mean_x2 = 0.0;
        double mean_y2 = 0.0;
        double mean_xy = 0.0;
        int i2 = 0;
        while (i2 < N) {
            double xi = x[i2];
            double yi = y[i2];
            if (!Double.isNaN(xi) && !Double.isNaN(yi)) {
                mean_x2 += (xi -= mean_x) * xi;
                mean_y2 += yi * yi;
                mean_xy += xi * yi;
            }
            ++i2;
        }
        this.slope = (mean_xy /= (double)count) / (mean_x2 /= (double)count);
        this.y0 = mean_y - mean_x * this.slope;
        return mean_xy / Math.sqrt(mean_x2 * ((mean_y2 /= (double)count) - mean_y * mean_y));
    }

    public void translate(double dx, double dy) {
        if (this.slope == 0.0 || Double.isInfinite(this.slope)) {
            this.x0 += dx;
            this.y0 += dy;
        } else {
            this.x0 += dx - dy / this.slope;
            this.y0 += dy - this.slope * dx;
        }
    }

    public final double y(double x) {
        return this.slope * x + this.y0;
    }

    public final double x(double y) {
        return y / this.slope + this.x0;
    }

    public final double getY0() {
        return this.y0;
    }

    public final double getX0() {
        return this.x0;
    }

    public final double getSlope() {
        return this.slope;
    }

    public Point2D intersectionPoint(Line line) {
        double y;
        double x;
        if (Double.isInfinite(this.slope)) {
            if (Double.isInfinite(line.slope)) {
                return null;
            }
            x = this.x0;
            y = x * line.slope + line.y0;
        } else {
            if (!Double.isInfinite(line.slope)) {
                x = (this.y0 - line.y0) / (line.slope - this.slope);
                if (Double.isInfinite(x)) {
                    return null;
                }
            } else {
                x = line.x0;
            }
            y = x * this.slope + this.y0;
        }
        return new Point2D.Double(x, y);
    }

    public Point2D intersectionPoint(Line2D line) {
        double y;
        double x;
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        double m = (y2 - y1) / (x2 - x1);
        if (Double.isInfinite(this.slope)) {
            x = this.x0;
            y = x * m + (y2 - m * x2);
        } else {
            x = !Double.isInfinite(m) ? (this.y0 - (y2 - m * x2)) / (m - this.slope) : 0.5 * (x1 + x2);
            y = x * this.slope + this.y0;
        }
        double eps = 1.0E-12 * Math.abs(x);
        if (x1 <= x2 ? !(x >= x1 - eps) || !(x <= x2 + eps) : !(x <= x1 + eps) || !(x >= x2 - eps)) {
            return null;
        }
        eps = 1.0E-12 * Math.abs(y);
        if (y1 <= y2 ? !(y >= y1 - eps) || !(y <= y2 + eps) : !(y <= y1 - eps) || !(y >= y2 + eps)) {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public Point2D nearestColinearPoint(Point2D point) {
        if (!Double.isInfinite(this.slope)) {
            double x = ((point.getY() - this.y0) * this.slope + point.getX()) / (this.slope * this.slope + 1.0);
            return new Point2D.Double(x, x * this.slope + this.y0);
        }
        return new Point2D.Double(this.x0, point.getY());
    }

    public Line2D isoscelesTriangleBase(Point2D summit, double sideLength) {
        double A;
        sideLength *= sideLength;
        if (this.slope == 0.0) {
            double x = summit.getX();
            double dy = this.y0 - summit.getY();
            double dx = Math.sqrt(sideLength - dy * dy);
            if (Double.isNaN(dx)) {
                return null;
            }
            return new Line2D.Double(x + dx, this.y0, x - dx, this.y0);
        }
        if (Double.isInfinite(this.slope)) {
            double y = summit.getY();
            double dx = this.x0 - summit.getX();
            double dy = Math.sqrt(sideLength - dx * dx);
            if (Double.isNaN(dy)) {
                return null;
            }
            return new Line2D.Double(this.x0, y + dy, this.x0, y - dy);
        }
        double x = summit.getX();
        double y = summit.getY();
        double dy = this.y0 - y + this.slope * x;
        double B = -this.slope * dy;
        double C = Math.sqrt(B * B + (A = this.slope * this.slope + 1.0) * (sideLength - dy * dy));
        if (Double.isNaN(C)) {
            return null;
        }
        double x1 = (B + C) / A + x;
        double x2 = (B - C) / A + x;
        return new Line2D.Double(x1, this.slope * x1 + this.y0, x2, this.slope * x2 + this.y0);
    }

    public String toString() {
        if (!Double.isInfinite(this.slope)) {
            StringBuilder buffer = new StringBuilder("y= ");
            if (this.slope != 0.0) {
                buffer.append(this.slope).append("*x");
                if (this.y0 != 0.0) {
                    buffer.append(" + ");
                } else {
                    return buffer.toString();
                }
            }
            return buffer.append(this.y0).toString();
        }
        return "x= " + this.x0;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            Line that = (Line)object;
            return Double.doubleToLongBits(this.slope) == Double.doubleToLongBits(that.slope) && Double.doubleToLongBits(this.y0) == Double.doubleToLongBits(that.y0) && Double.doubleToLongBits(this.x0) == Double.doubleToLongBits(that.x0);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.slope) + 37L * Double.doubleToLongBits(this.y0);
        return (int)code ^ (int)(code >>> 32);
    }

    public Line clone() {
        try {
            return (Line)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

