/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.i18n;

import java.util.Arrays;
import java.util.Locale;
import org.geotools.resources.Arguments;
import org.geotools.resources.XArray;

public final class Locales {
    private Locales() {
    }

    public static Locale[] getAvailableLanguages() {
        return new Locale[]{Locale.ENGLISH, Locale.FRENCH, Locale.GERMAN};
    }

    public static Locale[] getAvailableLocales() {
        Locale[] languages = Locales.getAvailableLanguages();
        Locale[] locales = Locale.getAvailableLocales();
        int count = 0;
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            if (Locales.containsLanguage(languages, locale)) {
                locales[count++] = locale;
            }
            ++i;
        }
        locales = XArray.resize(locales, count);
        return locales;
    }

    private static boolean containsLanguage(Locale[] locales, Locale language) {
        String code = language.getLanguage();
        int i = 0;
        while (i < locales.length) {
            if (code.equals(locales[i].getLanguage())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getAvailableLocales(Locale locale) {
        Locale[] locales = Locales.getAvailableLocales();
        Object[] display = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            display[i] = locales[i].getDisplayName(locale);
            ++i;
        }
        Arrays.sort(display);
        return display;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        String[] locales = Locales.getAvailableLocales(arguments.locale);
        int i = 0;
        while (i < locales.length) {
            arguments.out.println(locales[i]);
            ++i;
        }
    }
}

