/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ranks {
    private final int index;

    private Ranks(int index) {
        this.index = index;
    }

    public static <T extends Comparable<T>> int[] ranks(T[] source, T[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Any[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Any<T>(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                Ranks entry = entries[i2];
                target[i2] = ((Any)entry).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(double[] source, double[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Double[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Double(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                target[i2] = ((Double)entries[i2]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(float[] source, float[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Float[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Float(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                target[i2] = ((Float)entries[i2]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(long[] source, long[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Long[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Long(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                target[i2] = ((Long)entries[i2]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(int[] source, int[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Integer[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Integer(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                target[i2] = ((Integer)entries[i2]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(short[] source, short[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Short[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Short(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                target[i2] = ((Short)entries[i2]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(byte[] source, byte[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Byte[source.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = new Byte(i, source[i]);
            ++i;
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i2 = Math.min(entries.length, target.length);
            while (--i2 >= 0) {
                target[i2] = ((Byte)entries[i2]).value;
            }
        }
        return ranks;
    }

    private static int[] ranks(Ranks[] entries) {
        Arrays.sort(entries);
        int[] ranks = new int[entries.length];
        int i = 0;
        while (i < ranks.length) {
            ranks[i] = entries[i].index;
            ++i;
        }
        return ranks;
    }

    /* synthetic */ Ranks(int n, Ranks ranks) {
        this(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Any<T extends Comparable<T>>
    extends Ranks
    implements Comparable<Any<T>> {
        private final T value;

        Any(int index, T value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Any<T> other) {
            return this.value.compareTo(other.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Byte
    extends Ranks
    implements Comparable<Byte> {
        private final byte value;

        Byte(int index, byte value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Byte other) {
            return this.value - other.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Double
    extends Ranks
    implements Comparable<Double> {
        private final double value;

        Double(int index, double value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Double other) {
            return java.lang.Double.compare(this.value, other.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Float
    extends Ranks
    implements Comparable<Float> {
        private final float value;

        Float(int index, float value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Float other) {
            return java.lang.Float.compare(this.value, other.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Integer
    extends Ranks
    implements Comparable<Integer> {
        private final int value;

        Integer(int index, int value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Integer other) {
            return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Long
    extends Ranks
    implements Comparable<Long> {
        private final long value;

        Long(int index, long value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Long other) {
            return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Short
    extends Ranks
    implements Comparable<Short> {
        private final short value;

        Short(int index, short value) {
            super(index, null);
            this.value = value;
        }

        @Override
        public int compareTo(Short other) {
            return this.value - other.value;
        }
    }
}

