/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.io.IOException;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.io.LineWriter;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class MonolineFormatter
extends Formatter {
    private static final String PREFIX = "";
    private static final String SUFFIX = " - ";
    private static final int DEFAULT_WIDTH = 9;
    private static final int NO_SOURCE = 0;
    private static final int NO_SOURCE_EX = 1;
    private static final int LOGGER_SHORT = 2;
    private static final int LOGGER_LONG = 3;
    private static final int CLASS_SHORT = 4;
    private static final int CLASS_LONG = 5;
    private static String[] FORMAT_LABELS = new String[6];
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final int margin;
    private final long startMillis;
    private SimpleDateFormat timeFormat;
    private int sourceFormat;
    private final StringBuffer buffer;
    private final LineWriter writer;

    static {
        MonolineFormatter.FORMAT_LABELS[1] = "none";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[3] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[4] = "class:short";
        MonolineFormatter.FORMAT_LABELS[5] = "class:long";
    }

    public MonolineFormatter() {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.timeFormat = null;
        this.sourceFormat = 0;
        this.startMillis = System.currentTimeMillis();
        this.margin = 9;
        StringWriter str = new StringWriter();
        this.writer = new LineWriter(str);
        this.buffer = str.getBuffer();
        this.buffer.append(PREFIX);
        LogManager manager = LogManager.getLogManager();
        String classname = MonolineFormatter.class.getName();
        try {
            this.setTimeFormat(manager.getProperty(String.valueOf(classname) + ".time"));
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
        try {
            this.setSourceFormat(manager.getProperty(String.valueOf(classname) + ".source"));
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
    }

    public synchronized void setTimeFormat(String pattern) {
        if (pattern == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(pattern);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(pattern);
        }
    }

    public synchronized String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat.toPattern() : null;
    }

    public synchronized void setSourceFormat(String format) {
        if (format != null) {
            format = format.trim().toLowerCase();
        }
        int i = 0;
        while (i < FORMAT_LABELS.length) {
            if (Utilities.equals(FORMAT_LABELS[i], format)) {
                this.sourceFormat = i;
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException(format);
    }

    public String getSourceFormat() {
        return FORMAT_LABELS[this.sourceFormat];
    }

    public synchronized String format(LogRecord record) {
        this.buffer.setLength(PREFIX.length());
        if (this.timeFormat != null) {
            Date time = new Date(Math.max(0L, record.getMillis() - this.startMillis));
            this.timeFormat.format(time, this.buffer, new FieldPosition(0));
            this.buffer.append(' ');
        }
        int offset = this.buffer.length();
        this.buffer.append(record.getLevel().getLocalizedName());
        offset = this.buffer.length() - offset;
        this.buffer.append(Utilities.spaces(this.margin - offset));
        String logger = record.getLoggerName();
        String classname = record.getSourceClassName();
        switch (this.sourceFormat) {
            case 2: {
                int pos = logger.lastIndexOf(46);
                if (pos >= 0) {
                    logger = logger.substring(pos);
                }
            }
            case 3: {
                this.buffer.append(' ');
                this.buffer.append(logger);
                break;
            }
            case 4: {
                int dot = classname.lastIndexOf(46);
                if (dot >= 0) {
                    classname = classname.substring(dot + 1);
                }
                classname = classname.replace('$', '.');
            }
            case 5: {
                this.buffer.append(' ');
                this.buffer.append(classname);
            }
        }
        this.buffer.append(SUFFIX);
        int margin = this.buffer.length();
        assert (margin >= this.margin);
        if (this.bodyLineSeparator.length() != this.lineSeparator.length() + margin) {
            this.bodyLineSeparator = String.valueOf(this.lineSeparator) + Utilities.spaces(margin);
        }
        try {
            this.writer.setLineSeparator(this.bodyLineSeparator);
            this.writer.write(String.valueOf(this.formatMessage(record)));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    /*
     * Exception decompiling
     */
    public static MonolineFormatter configureConsoleHandler(Logger logger, Level level) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MonolineFormatter addHandler(Logger logger, Level level) {
        MonolineFormatter monoline = new MonolineFormatter();
        try {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(monoline);
            if (level != null) {
                handler.setLevel(level);
            }
            logger.addHandler(handler);
        }
        catch (SecurityException exception) {
            MonolineFormatter.unexpectedException(exception);
        }
        return monoline;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(MonolineFormatter.class, "configureConsoleHandler", exception);
    }
}

