/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import org.geotools.resources.ClassChanger;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberRange<T extends Number>
extends Range<T> {
    private static final long serialVersionUID = -818167965963008231L;

    public static NumberRange<Byte> create(byte minimum, byte maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public NumberRange(byte minimum, byte maximum) {
        this(minimum, true, maximum, true);
    }

    public static NumberRange<Byte> create(byte minimum, boolean isMinIncluded, byte maximum, boolean isMaxIncluded) {
        return new NumberRange<Byte>(Byte.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    @Deprecated
    public NumberRange(byte minimum, boolean isMinIncluded, byte maximum, boolean isMaxIncluded) {
        super(Byte.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Short> create(short minimum, short maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public NumberRange(short minimum, short maximum) {
        this(minimum, true, maximum, true);
    }

    public static NumberRange<Short> create(short minimum, boolean isMinIncluded, short maximum, boolean isMaxIncluded) {
        return new NumberRange<Short>(Short.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    @Deprecated
    public NumberRange(short minimum, boolean isMinIncluded, short maximum, boolean isMaxIncluded) {
        super(Short.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Integer> create(int minimum, int maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public NumberRange(int minimum, int maximum) {
        this(minimum, true, maximum, true);
    }

    public static NumberRange<Integer> create(int minimum, boolean isMinIncluded, int maximum, boolean isMaxIncluded) {
        return new NumberRange<Integer>(Integer.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    @Deprecated
    public NumberRange(int minimum, boolean isMinIncluded, int maximum, boolean isMaxIncluded) {
        super(Integer.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Long> create(long minimum, long maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public NumberRange(long minimum, long maximum) {
        this(minimum, true, maximum, true);
    }

    public static NumberRange<Long> create(long minimum, boolean isMinIncluded, long maximum, boolean isMaxIncluded) {
        return new NumberRange<Long>(Long.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    @Deprecated
    public NumberRange(long minimum, boolean isMinIncluded, long maximum, boolean isMaxIncluded) {
        super(Long.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    public static NumberRange<Float> create(float minimum, float maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public NumberRange(float minimum, float maximum) {
        this(minimum, true, maximum, true);
    }

    public static NumberRange<Float> create(float minimum, boolean isMinIncluded, float maximum, boolean isMaxIncluded) {
        return new NumberRange<Float>(Float.class, Float.valueOf(minimum), isMinIncluded, Float.valueOf(maximum), isMaxIncluded);
    }

    @Deprecated
    public NumberRange(float minimum, boolean isMinIncluded, float maximum, boolean isMaxIncluded) {
        super(Float.class, (Number)Float.valueOf(minimum), isMinIncluded, (Number)Float.valueOf(maximum), isMaxIncluded);
    }

    public static NumberRange<Double> create(double minimum, double maximum) {
        return NumberRange.create(minimum, true, maximum, true);
    }

    public NumberRange(double minimum, double maximum) {
        this(minimum, true, maximum, true);
    }

    public static NumberRange<Double> create(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded) {
        return new NumberRange<Double>(Double.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    @Deprecated
    public NumberRange(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded) {
        super(Double.class, minimum, isMinIncluded, maximum, isMaxIncluded);
    }

    NumberRange(Class<T> type, Comparable<T> minimum, Comparable<T> maximum) throws IllegalArgumentException {
        super(type, (Number)((Object)minimum), (Number)((Object)maximum));
    }

    public NumberRange(Class<T> type, T minimum, T maximum) {
        super(type, (Comparable)minimum, (Comparable)maximum);
    }

    public NumberRange(Class<T> type, T minimum, boolean isMinIncluded, T maximum, boolean isMaxIncluded) {
        super(type, (Comparable)minimum, isMinIncluded, (Comparable)maximum, isMaxIncluded);
    }

    NumberRange(Class<T> type, Range<? extends Number> range) throws IllegalArgumentException {
        this(type, ClassChanger.cast(range.getMinValue(), type), range.isMinIncluded(), ClassChanger.cast(range.getMaxValue(), type), range.isMaxIncluded());
    }

    public NumberRange(Range<T> range) {
        super(range.getElementClass(), range.getMinValue(), range.isMinIncluded(), range.getMaxValue(), range.isMaxIncluded());
    }

    @Override
    NumberRange<T> create(T minValue, boolean isMinIncluded, T maxValue, boolean isMaxIncluded) {
        return new NumberRange<T>(this.elementClass, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    @Override
    void checkElementClass() throws IllegalArgumentException {
        NumberRange.ensureNumberClass(this.elementClass);
    }

    private static Class<? extends Number> getElementClass(Range<?> range) throws IllegalArgumentException {
        NumberRange.ensureNonNull("range", range);
        Class type = range.elementClass;
        NumberRange.ensureNumberClass(type);
        Class result = type;
        return result;
    }

    private static void ensureNumberClass(Class<?> type) throws IllegalArgumentException {
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(Errors.format(45, type, Number.class));
        }
    }

    public static <N extends Number> NumberRange<N> wrap(Range<N> range) {
        if (range instanceof NumberRange) {
            NumberRange cast = (NumberRange)range;
            return cast;
        }
        return new NumberRange<N>(range);
    }

    <N extends Number> NumberRange<N> convertAndCast(Range<? extends Number> range, Class<N> type) throws IllegalArgumentException {
        if (type.equals(range.getElementClass())) {
            NumberRange<? extends Number> cast = NumberRange.wrap(range);
            return cast;
        }
        return new NumberRange<N>(type, range);
    }

    @Deprecated
    final NumberRange damnJava5(Range range, Class type) {
        return this.convertAndCast(range, type);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> type) throws IllegalArgumentException {
        return this.convertAndCast(this, type);
    }

    NumberRange<T>[] newArray(int length) {
        return new NumberRange[length];
    }

    public boolean contains(Number value) throws IllegalArgumentException {
        if (value != null && !(value instanceof Comparable)) {
            throw new IllegalArgumentException(Errors.format(90, value.getClass()));
        }
        return this.contains((Comparable)((Object)value));
    }

    @Override
    public boolean contains(Comparable<?> value) throws IllegalArgumentException {
        if (value == null) {
            return false;
        }
        NumberRange.ensureNumberClass(value.getClass());
        Number number = (Number)((Object)value);
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, number.getClass());
        number = ClassChanger.cast(number, type);
        boolean contains = this.castTo(type).containsNC((Number)((Object)((Comparable)((Object)number))));
        return contains;
    }

    @Override
    public boolean contains(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, type);
        return this.castTo(type).containsNC(range);
    }

    @Override
    public boolean intersects(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, type);
        return this.castTo(type).intersectsNC(range);
    }

    @Override
    public NumberRange<?> union(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        range = this.convertAndCast(range, type);
        return (NumberRange)this.castTo(type).unionNC(range);
    }

    @Override
    public NumberRange<?> intersect(Range<?> range) {
        Class<Number> rangeType = NumberRange.getElementClass(range);
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, rangeType);
        range = this.castTo(type).intersectNC(this.convertAndCast(range, type));
        type = ClassChanger.getFinestClass(this.elementClass, rangeType);
        if (range.minValue != null) {
            type = ClassChanger.getWidestClass(type, ClassChanger.getFinestClass(((Number)range.minValue).doubleValue()));
        }
        if (range.maxValue != null) {
            type = ClassChanger.getWidestClass(type, ClassChanger.getFinestClass(((Number)range.maxValue).doubleValue()));
        }
        return this.convertAndCast(range, type);
    }

    public NumberRange<?>[] subtract(Range<?> range) {
        Class<Number> type = ClassChanger.getWidestClass(this.elementClass, NumberRange.getElementClass(range));
        return (NumberRange[])this.castTo(type).subtractNC(this.convertAndCast(range, type));
    }

    public double getMinimum() {
        Number value = (Number)this.getMinValue();
        return value != null ? value.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinimum(boolean inclusive) {
        double value = this.getMinimum();
        if (inclusive != this.isMinIncluded()) {
            value = XMath.rool(this.getElementClass(), value, inclusive ? 1 : -1);
        }
        return value;
    }

    public double getMaximum() {
        Number value = (Number)this.getMaxValue();
        return value != null ? value.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaximum(boolean inclusive) {
        double value = this.getMaximum();
        if (inclusive != this.isMaxIncluded()) {
            value = XMath.rool(this.getElementClass(), value, inclusive ? -1 : 1);
        }
        return value;
    }
}

