/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.jdbc.datasource.DataSourceUtil;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.oracle.OracleDataStore;
import org.geotools.util.logging.Logging;

public class OracleDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.oracle");
    private static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String JDBC_PATH = "jdbc:oracle:thin:@";
    static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "This must be 'oracle'.", true, (Object)"oracle");
    static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "The host name of the server.", true);
    static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "The port oracle is running on. (Default is 1521)", true, (Object)"1521");
    static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "The user name to log in with.", true);
    static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, "The password.", true);
    public static final DataAccessFactory.Param MAXCONN = new DataAccessFactory.Param("max connections", Integer.class, "maximum number of open connections", false, (Object)new Integer(10));
    public static final DataAccessFactory.Param MINCONN = new DataAccessFactory.Param("min connections", Integer.class, "minimum number of pooled connection", false, (Object)new Integer(4));
    public static final DataAccessFactory.Param VALIDATECONN = new DataAccessFactory.Param("validate connections", Boolean.class, "check connection is alive before using it", false, (Object)Boolean.FALSE);
    static final DataAccessFactory.Param INSTANCE = new DataAccessFactory.Param("instance", String.class, "The name of the Oracle instance to connect to.", true);
    static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "The schema name to narrow down the exposed tables (must be upper case).", false){

        public Object lookUp(Map map) throws IOException {
            if (!map.containsKey(this.key)) {
                if (this.required) {
                    throw new IOException("Parameter " + this.key + " is required:" + this.description);
                }
                return null;
            }
            Object value = map.get(this.key);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                String text = (String)value;
                if (text == null) {
                    return null;
                }
                if (text.equals(text.toUpperCase())) {
                    return text;
                }
                throw new IOException("Schema must be supplied in uppercase");
            }
            throw new IOException("String required for parameter " + this.key + ": not " + value.getClass().getName());
        }
    };
    static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "The namespace to give the DataStore", false);

    public boolean canProcess(Map params) {
        if (params != null) {
            if (params.get("dbtype") == null || !params.get("dbtype").toString().equalsIgnoreCase("oracle")) {
                return false;
            }
            DataAccessFactory.Param[] arrayParameters = this.getParametersInfo();
            for (int i = 0; i < arrayParameters.length; ++i) {
                Object value;
                DataAccessFactory.Param param = arrayParameters[i];
                if (!params.containsKey(param.key)) {
                    if (!param.required) continue;
                    return false;
                }
                try {
                    value = param.lookUp(params);
                }
                catch (IOException e) {
                    LOGGER.warning(param.key + ":" + e);
                    return false;
                }
                if (!(value == null ? param.required : !param.type.isInstance(value))) continue;
                return false;
            }
        } else {
            return false;
        }
        return ((String)params.get("dbtype")).equalsIgnoreCase("oracle");
    }

    public DataStore createDataStore(Map params) throws IOException {
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        String instance = (String)INSTANCE.lookUp(params);
        String user = (String)USER.lookUp(params);
        String passwd = (String)PASSWD.lookUp(params);
        String schema = (String)SCHEMA.lookUp(params);
        String namespace = (String)NAMESPACE.lookUp(params);
        String dbtype = (String)DBTYPE.lookUp(params);
        Integer maxConn = (Integer)MAXCONN.lookUp(params);
        Integer minConn = (Integer)MINCONN.lookUp(params);
        Boolean validateConn = (Boolean)VALIDATECONN.lookUp(params);
        if (!"oracle".equals(dbtype)) {
            throw new IOException("Parameter 'dbtype' must be oracle");
        }
        if (!this.canProcess(params)) {
            throw new IOException("Cannot connect using provided parameters");
        }
        boolean validate = validateConn != null && validateConn != false;
        int maxActive = maxConn != null ? maxConn : 10;
        int maxIdle = minConn != null ? minConn : 4;
        ManageableDataSource source = OracleDataStoreFactory.getDefaultDataSource(host, user, passwd, port, instance, maxActive, maxIdle, validate);
        OracleDataStore dataStore = new OracleDataStore((DataSource)source, namespace, schema, new HashMap());
        return dataStore;
    }

    public static ManageableDataSource getDefaultDataSource(String host, String user, String passwd, int port, String instance, int maxActive, int minIdle, boolean validate) throws DataSourceException {
        String dbUrl = null;
        dbUrl = instance.startsWith("(") ? JDBC_PATH + instance : (instance.startsWith("/") ? "jdbc:oracle:thin:@//" + host + ":" + port + instance : JDBC_PATH + host + ":" + port + ":" + instance);
        return DataSourceUtil.buildDefaultDataSource((String)dbUrl, (String)JDBC_DRIVER, (String)user, (String)passwd, (int)maxActive, (int)minIdle, (String)(validate ? "select sysdate from dual" : null), (boolean)false, (int)0);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Oracle cannot create a new Database");
    }

    public String getDisplayName() {
        return "Oracle";
    }

    public String getDescription() {
        return "Oracle Spatial Database";
    }

    public boolean isAvailable() {
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, HOST, PORT, USER, PASSWD, INSTANCE, MAXCONN, MINCONN, VALIDATECONN, SCHEMA, NAMESPACE};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

