/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle.sdo;

import java.util.AbstractList;

public class OrdinateList
extends AbstractList {
    final double[] ARRAY;
    final int OFFSET;
    final int LEN;
    final int SIZE;
    final int START;
    final int END;
    final int STEP;

    public OrdinateList(double[] array) {
        this(array, 0, 1);
    }

    public OrdinateList(double[] array, int offset, int len) {
        this(array, offset, len, 0, array.length);
    }

    public OrdinateList(double[] array, int offset, int len, int start, int end) {
        this.START = start;
        this.END = end;
        this.ARRAY = array;
        this.OFFSET = offset;
        this.LEN = len;
        this.SIZE = Math.abs(this.START - this.END) / this.LEN;
        int n = this.STEP = this.START < this.END ? this.LEN : -this.LEN;
        if (this.ARRAY.length % this.LEN != 0) {
            throw new IllegalArgumentException("You have requested Coordiantes of " + this.LEN + " ordinates. " + "This is inconsistent with an array of length " + this.ARRAY.length);
        }
    }

    public Object get(int index) {
        return new Double(this.getDouble(index));
    }

    public double getDouble(int index) {
        this.rangeCheck(index);
        return this.ARRAY[this.START + this.STEP * index + this.OFFSET];
    }

    public double[] toDoubleArray() {
        double[] array = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.getDouble(i);
        }
        return array;
    }

    private void rangeCheck(int index) {
        if (index >= this.SIZE) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.SIZE);
        }
    }

    public int size() {
        return this.SIZE;
    }
}

