/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.VersioningDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.MultiColumnFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.data.postgis.FidTransformeVisitor;
import org.geotools.data.postgis.ModifiedFeatureIds;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.data.postgis.RevisionInfo;
import org.geotools.data.postgis.VersionedFeatureReader;
import org.geotools.data.postgis.VersionedFeatureWriter;
import org.geotools.data.postgis.VersionedJdbcTransactionState;
import org.geotools.data.postgis.VersionedPostgisFeatureStore;
import org.geotools.data.postgis.WrappedPostgisDataStore;
import org.geotools.data.postgis.WrappingPostgisFeatureLocking;
import org.geotools.data.postgis.WrappingPostgisFeatureSource;
import org.geotools.data.postgis.WrappingPostgisFeatureStore;
import org.geotools.data.postgis.fidmapper.PostGISAutoIncrementFIDMapper;
import org.geotools.data.postgis.fidmapper.UUIDFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapperFactory;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedPostgisDataStore
implements VersioningDataStore {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    public static final String TBL_VERSIONEDTABLES = "versioned_tables";
    public static final String TBL_TABLESCHANGED = "tables_changed";
    public static final String TBL_CHANGESETS = "changesets";
    static final String REVISION = "revision";
    static final String VERSION = "version";
    static final Class[] SUPPORTED_FID_MAPPERS = new Class[]{BasicFIDMapper.class, MultiColumnFIDMapper.class, PostGISAutoIncrementFIDMapper.class, UUIDFIDMapper.class};
    public static final String DIRTYTYPES = "PgVersionedDirtyTypes";
    protected WrappedPostgisDataStore wrapped;
    protected Map versionedMap = new HashMap();
    protected FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    protected FeatureListenerManager listenerManager = new FeatureListenerManager();

    public VersionedPostgisDataStore(DataSource dataSource, String schema, String namespace, int optimizeMode) throws IOException {
        this.wrapped = new WrappedPostgisDataStore(dataSource, schema, namespace, optimizeMode);
        this.checkVersioningDataStructures();
    }

    public VersionedPostgisDataStore(DataSource dataSource, String schema, String namespace) throws IOException {
        this.wrapped = new WrappedPostgisDataStore(dataSource, schema, namespace);
        this.checkVersioningDataStructures();
    }

    public VersionedPostgisDataStore(DataSource dataSource, String namespace) throws IOException {
        this.wrapped = new WrappedPostgisDataStore(dataSource, namespace);
        this.checkVersioningDataStructures();
    }

    public VersionedPostgisDataStore(DataSource dataSource) throws IOException {
        this.wrapped = new WrappedPostgisDataStore(dataSource);
        this.checkVersioningDataStructures();
    }

    protected JDBCDataStoreConfig getConfig() {
        return this.wrapped.getConfig();
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from PostGIS, managed with a version history");
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    public String[] getTypeNames() throws IOException {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.wrapped.getTypeNames()));
        names.remove(TBL_TABLESCHANGED);
        names.remove(TBL_VERSIONEDTABLES);
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.isVersionedFeatureCollection(name)) continue;
            it.remove();
        }
        return names.toArray(new String[names.size()]);
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        SimpleFeatureType ft = this.wrapped.getSchema(typeName);
        if (!this.isVersioned(typeName)) {
            return ft;
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(this.filterPropertyNames((Query)new DefaultQuery(typeName))));
        ArrayList<AttributeDescriptor> filtered = new ArrayList<AttributeDescriptor>();
        for (int i = 0; i < ft.getAttributeCount(); ++i) {
            AttributeDescriptor cat = ft.getDescriptor(i);
            String name = cat.getLocalName().toLowerCase();
            if (!names.contains(name)) continue;
            filtered.add(cat);
        }
        AttributeDescriptor[] ats = filtered.toArray(new AttributeDescriptor[filtered.size()]);
        try {
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.init(ft);
            ftb.setAttributes(Arrays.asList(ats));
            return ftb.buildFeatureType();
        }
        catch (IllegalArgumentException e) {
            throw new DataSourceException("Error converting FeatureType from versioned (internal) schema to unversioned (external) schema " + typeName, (Throwable)e);
        }
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.wrapped.createSchema(featureType);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new IOException("VersionedPostgisDataStore.updateSchema not yet implemented");
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction trans) throws IOException {
        if (!this.isVersioned(query.getTypeName())) {
            return this.wrapped.getFeatureReader(query, trans);
        }
        DefaultQuery versionedQuery = this.buildVersionedQuery(query);
        FeatureReader reader = this.wrapped.getFeatureReader((Query)versionedQuery, trans);
        VersionedFIDMapper mapper = (VersionedFIDMapper)this.getFIDMapper(query.getTypeName());
        return new VersionedFeatureReader((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, mapper);
    }

    public LockingManager getLockingManager() {
        return this.wrapped.getLockingManager();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        if (TBL_CHANGESETS.equals(typeName)) {
            throw new DataSourceException("Changesets feature type is read only");
        }
        if (!this.isVersioned(typeName)) {
            return this.wrapped.getFeatureWriter(typeName, filter, transaction);
        }
        return this.getFeatureWriterInternal(typeName, filter, transaction, false);
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterInternal(String typeName, Filter filter, Transaction transaction, boolean append) throws IOException, DataSourceException {
        boolean autoCommit = false;
        if (transaction.equals(Transaction.AUTO_COMMIT)) {
            transaction = new DefaultTransaction();
            autoCommit = true;
        }
        Filter revisionedFilter = this.buildVersionedFilter(typeName, filter, new RevisionInfo());
        FeatureWriter updateWriter = append ? null : this.wrapped.getFeatureWriter(typeName, revisionedFilter, transaction);
        FeatureWriter appendWriter = this.wrapped.getFeatureWriterAppend(typeName, transaction);
        VersionedJdbcTransactionState state = this.wrapped.getVersionedJdbcTransactionState(transaction);
        state.setTypeNameDirty(typeName);
        VersionedFIDMapper mapper = (VersionedFIDMapper)this.getFIDMapper(typeName);
        VersionedFeatureWriter writer = new VersionedFeatureWriter((FeatureWriter<SimpleFeatureType, SimpleFeature>)updateWriter, (FeatureWriter<SimpleFeatureType, SimpleFeature>)appendWriter, this.getSchema(typeName), state, mapper, autoCommit);
        writer.setFeatureListenerManager(this.listenerManager);
        return writer;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        if (!this.isVersioned(typeName)) {
            return this.wrapped.getFeatureWriterAppend(typeName, transaction);
        }
        return this.getFeatureWriterInternal(typeName, (Filter)Filter.EXCLUDE, transaction, true);
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.isVersioned(typeName)) {
            return new VersionedPostgisFeatureStore(this.getSchema(typeName), this);
        }
        SimpleFeatureSource source = this.wrapped.getFeatureSource(typeName);
        if (TBL_CHANGESETS.equals(typeName)) {
            return new WrappingPostgisFeatureSource(source, this);
        }
        if (source instanceof SimpleFeatureLocking) {
            return new WrappingPostgisFeatureLocking((SimpleFeatureLocking)source, this);
        }
        if (source instanceof SimpleFeatureStore) {
            return new WrappingPostgisFeatureStore((SimpleFeatureStore)source, this);
        }
        return new WrappingPostgisFeatureSource(source, this);
    }

    public SimpleFeatureSource getView(Query query) throws IOException, SchemaException {
        throw new UnsupportedOperationException("At the moment getView(Query) is not supported");
    }

    @Override
    public boolean isVersioned(String typeName) throws IOException {
        return this.isVersioned(typeName, null);
    }

    @Override
    public synchronized void setVersioned(String typeName, boolean versioned, String author, String message) throws IOException {
        if (typeName == null) {
            throw new NullPointerException("TypeName cannot be null");
        }
        if (typeName.equals(TBL_CHANGESETS) && versioned) {
            throw new IOException("changesets is exposed as a log facility, and cannot be versioned");
        }
        if (this.isVersioned(typeName) == versioned) {
            return;
        }
        if (versioned) {
            this.enableVersioning(typeName, author, message);
        } else {
            this.disableVersioning(typeName, author, message);
        }
        this.versionedMap.put(typeName, versioned);
    }

    protected boolean isVersioned(String typeName, Transaction transaction) throws IOException {
        Boolean versioned;
        block6: {
            versioned = (Boolean)this.versionedMap.get(typeName);
            if (versioned != null) break block6;
            if (this.isVersionedFeatureCollection(typeName)) {
                throw new DataSourceException("Could not find type " + typeName);
            }
            if (!Arrays.asList(this.wrapped.getTypeNames()).contains(typeName)) {
                throw new DataSourceException("Unknown feature type " + typeName);
            }
            Connection conn = null;
            Statement st = null;
            PostgisSQLBuilder sqlb = this.wrapped.createSQLBuilder();
            ResultSet rs = null;
            try {
                conn = transaction != null ? this.wrapped.getConnection(transaction) : this.wrapped.getDataSource().getConnection();
                st = conn.createStatement();
                rs = this.executeQuery(st, "SELECT COUNT(*) from " + sqlb.encodeTableName(TBL_VERSIONEDTABLES) + " WHERE SCHEMA = '" + this.getConfig().getDatabaseSchemaName() + "'" + " AND NAME='" + typeName + "'" + " AND VERSIONED = TRUE");
                rs.next();
                versioned = new Boolean(rs.getInt(1) > 0);
            }
            catch (SQLException e) {
                try {
                    throw new DataSourceException("Error occurred while checking versioned tables, database support tables are probably corrupt", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(st);
                    JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
                    throw throwable;
                }
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((Statement)st);
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
            this.versionedMap.put(typeName, versioned);
        }
        return versioned;
    }

    public Connection getConnection(Transaction t) throws IOException {
        return this.wrapped.getConnection(t);
    }

    public boolean isVersionedFeatureCollection(String typeName) throws IOException {
        if (!typeName.endsWith("_vfc_view")) {
            return false;
        }
        String originalName = VersionedPostgisDataStore.getVFCTableName(typeName);
        return Arrays.asList(this.wrapped.getTypeNames()).contains(originalName);
    }

    public void setWKBEnabled(boolean enabled) {
        this.wrapped.setWKBEnabled(enabled);
    }

    public void setLooseBbox(boolean enabled) {
        this.wrapped.setLooseBbox(enabled);
    }

    public FIDMapper getFIDMapper(String tableName) throws IOException {
        return this.wrapped.getFIDMapper(tableName);
    }

    public long getLastRevision() throws IOException {
        long l;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = this.wrapped.getDataSource().getConnection();
            st = conn.createStatement();
            rs = st.executeQuery("select max(revision) from changesets");
            rs.next();
            l = rs.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new DataSourceException("Error getting last revision.", (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(st);
                JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        return l;
    }

    public String[] getModifiedFeatureTypes(String version1, String version2) throws IOException {
        String[] stringArray;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        RevisionInfo r1 = new RevisionInfo(version1);
        RevisionInfo r2 = new RevisionInfo(version2);
        if (r1.revision > r2.revision) {
            RevisionInfo tmp = r1;
            r1 = r2;
            r1 = tmp;
        }
        if (r1.revision == Long.MAX_VALUE || r1.revision == r2.revision) {
            return new String[0];
        }
        try {
            conn = this.wrapped.getDataSource().getConnection();
            st = conn.createStatement();
            rs = st.executeQuery("select distinct(name) from versioned_tables where id in (select versionedtable from tables_changed where revision > " + r1.revision + " and revision <= " + r2.revision + ")");
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            stringArray = result.toArray(new String[result.size()]);
        }
        catch (SQLException e) {
            try {
                throw new DataSourceException("Error getting feature types modified between " + r1.revision + " and " + r2.revision, (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(st);
                JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        return stringArray;
    }

    public ModifiedFeatureIds getModifiedFeatureFIDs(String typeName, String version1, String version2, Filter originalFilter, String[] users, Transaction transaction) throws IOException {
        if (originalFilter == null) {
            originalFilter = Filter.INCLUDE;
        }
        RevisionInfo r1 = new RevisionInfo(version1);
        RevisionInfo r2 = new RevisionInfo(version2);
        if (!this.isVersioned(typeName)) {
            return new ModifiedFeatureIds(r1, r2);
        }
        if (r1.revision > r2.revision) {
            RevisionInfo tmp = r1;
            r1 = r2;
            r2 = tmp;
        }
        Filter filter = this.transformFidFilter(typeName, originalFilter);
        long baseRevision = this.getBaseRevision(typeName, transaction);
        if (baseRevision > r2.revision) {
            return new ModifiedFeatureIds(r1, r2);
        }
        if (baseRevision > r1.revision) {
            r1.revision = baseRevision;
        }
        Set userRevisions = this.getRevisionsCreatedBy(typeName, r1, r2, users, transaction);
        HashSet<String> columns = new HashSet<String>();
        SQLBuilder builder = this.wrapped.getSqlBuilder(typeName);
        SimpleFeatureType internalType = this.wrapped.getSchema(typeName);
        Filter preFilter = builder.getPreQueryFilter(filter);
        Filter postFilter = builder.getPostQueryFilter(filter);
        columns.addAll(Arrays.asList(DataUtilities.attributeNames((Filter)postFilter, (SimpleFeatureType)internalType)));
        VersionedFIDMapper mapper = (VersionedFIDMapper)this.wrapped.getFIDMapper(typeName);
        for (int i = 0; i < mapper.getColumnCount(); ++i) {
            columns.add(mapper.getColumnName(i));
        }
        columns.add(REVISION);
        columns.add("expired");
        PropertyIsLessThanOrEqualTo revLeR1 = this.ff.lessOrEqual((Expression)this.ff.property(REVISION), (Expression)this.ff.literal(r1.revision));
        PropertyIsGreaterThan expGtR1 = this.ff.greater((Expression)this.ff.property("expired"), (Expression)this.ff.literal(r1.revision));
        PropertyIsLessThanOrEqualTo expLeR2 = this.ff.lessOrEqual((Expression)this.ff.property("expired"), (Expression)this.ff.literal(r2.revision));
        PropertyIsLessThan expLtR2 = this.ff.less((Expression)this.ff.property("expired"), (Expression)this.ff.literal(r2.revision));
        PropertyIsGreaterThan revGtR1 = this.ff.greater((Expression)this.ff.property(REVISION), (Expression)this.ff.literal(r1.revision));
        PropertyIsLessThanOrEqualTo revLeR2 = this.ff.lessOrEqual((Expression)this.ff.property(REVISION), (Expression)this.ff.literal(r2.revision));
        Or versionFilter = r2.isLast() ? this.ff.or((Filter)this.ff.and((Filter)revLeR1, (Filter)this.ff.and((Filter)expGtR1, (Filter)expLtR2)), (Filter)revGtR1) : this.ff.or((Filter)this.ff.and((Filter)revLeR1, (Filter)this.ff.and((Filter)expGtR1, (Filter)expLeR2)), (Filter)this.ff.and((Filter)revGtR1, (Filter)revLeR2));
        Or newFilter = null;
        if (Filter.EXCLUDE.equals(preFilter)) {
            return new ModifiedFeatureIds(r1, r2);
        }
        if (Filter.INCLUDE.equals(preFilter)) {
            newFilter = versionFilter;
        } else {
            Filter clone = this.transformFidFilter(typeName, preFilter);
            newFilter = this.ff.and((Filter)versionFilter, clone);
        }
        if (userRevisions != null) {
            if (userRevisions.isEmpty()) {
                return new ModifiedFeatureIds(r1, r2);
            }
            ArrayList<PropertyIsEqualTo> urFilters = new ArrayList<PropertyIsEqualTo>(userRevisions.size());
            PropertyName revisionProperty = this.ff.property(REVISION);
            for (Long revision : userRevisions) {
                urFilters.add(this.ff.equals((Expression)revisionProperty, (Expression)this.ff.literal((Object)revision)));
            }
            newFilter = this.ff.and((Filter)newFilter, (Filter)this.ff.or(urFilters));
        }
        FeatureReader fr = null;
        HashSet<String> matched = new HashSet<String>();
        HashSet<String> createdBefore = new HashSet<String>();
        HashSet<String> expiredAfter = new HashSet<String>();
        try {
            String[] colArray = columns.toArray(new String[columns.size()]);
            DefaultQuery q = new DefaultQuery(typeName, (Filter)newFilter, colArray);
            fr = this.wrapped.getFeatureReader((Query)q, transaction);
            while (fr.hasNext()) {
                SimpleFeature f = (SimpleFeature)fr.next();
                long revision = (Long)f.getAttribute(REVISION);
                long expired = (Long)f.getAttribute("expired");
                String id = mapper.getUnversionedFid(f.getID());
                if (!matched.contains(id) && (revision > r1.revision || expired > r1.revision && expired <= r2.revision) && postFilter.evaluate((Object)f)) {
                    matched.add(id);
                }
                if (revision <= r1.revision) {
                    createdBefore.add(id);
                }
                if (expired <= r2.revision) continue;
                expiredAfter.add(id);
            }
            fr.close();
            fr = null;
            HashSet created = new HashSet(matched);
            created.removeAll(createdBefore);
            if (!created.isEmpty()) {
                Filter r1FidFilter = this.buildFidFilter(created);
                Filter r1Filter = this.buildVersionedFilter(typeName, r1FidFilter, r1);
                DefaultQuery r1q = new DefaultQuery(typeName, r1Filter, colArray);
                fr = this.wrapped.getFeatureReader((Query)r1q, transaction);
                while (fr.hasNext()) {
                    String versionedId = ((SimpleFeature)fr.next()).getID();
                    String unversionedId = mapper.getUnversionedFid(versionedId);
                    created.remove(unversionedId);
                }
                fr.close();
                fr = null;
            }
            HashSet deleted = new HashSet(matched);
            deleted.removeAll(expiredAfter);
            if (!deleted.isEmpty()) {
                Filter r2FidFilter = this.buildFidFilter(deleted);
                Filter r2Filter = this.buildVersionedFilter(typeName, r2FidFilter, r2);
                DefaultQuery r2q = new DefaultQuery(typeName, r2Filter, colArray);
                fr = this.wrapped.getFeatureReader((Query)r2q, transaction);
                while (fr.hasNext()) {
                    String versionedId = ((SimpleFeature)fr.next()).getID();
                    String unversionedId = mapper.getUnversionedFid(versionedId);
                    deleted.remove(unversionedId);
                }
                fr.close();
                fr = null;
            }
            HashSet modified = new HashSet(matched);
            modified.removeAll(created);
            modified.removeAll(deleted);
            ModifiedFeatureIds modifiedFeatureIds = new ModifiedFeatureIds(r1, r2, created, deleted, modified);
            return modifiedFeatureIds;
        }
        catch (Exception e) {
            throw new DataSourceException("Error occurred while computing modified fids", (Throwable)e);
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
    }

    Set getRevisionsCreatedBy(String typeName, RevisionInfo r1, RevisionInfo r2, String[] users, Transaction transaction) throws IOException {
        if (users == null || users.length == 0) {
            return null;
        }
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>(users.length);
        for (int i = 0; i < users.length; ++i) {
            filters.add(this.ff.equals((Expression)this.ff.property("author"), (Expression)this.ff.literal((Object)users[i])));
        }
        PropertyIsBetween revisionFilter = this.ff.between((Expression)this.ff.property(REVISION), (Expression)this.ff.literal(r1.revision), (Expression)this.ff.literal(r2.revision));
        And userFilter = this.ff.and((Filter)this.ff.or(filters), (Filter)revisionFilter);
        DefaultQuery query = new DefaultQuery(TBL_CHANGESETS, (Filter)userFilter, new String[]{REVISION});
        HashSet<Object> revisions = new HashSet<Object>();
        FeatureReader fr = null;
        try {
            fr = this.wrapped.getFeatureReader((Query)query, transaction);
            while (fr.hasNext()) {
                SimpleFeature f = (SimpleFeature)fr.next();
                revisions.add(f.getAttribute(REVISION));
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Error reading revisions modified by users " + Arrays.asList(users), (Throwable)e);
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
        return revisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getBaseRevision(String typeName, Transaction transaction) throws IOException {
        Long tableId;
        SimpleFeature feature2;
        DefaultQuery q = new DefaultQuery(TBL_VERSIONEDTABLES);
        q.setFilter((Filter)this.ff.equal((Expression)this.ff.property("name"), (Expression)this.ff.literal((Object)typeName), true));
        FeatureReader fr = null;
        try {
            fr = this.wrapped.getFeatureReader((Query)q, transaction);
            feature2 = (SimpleFeature)fr.next();
            tableId = Long.parseLong(feature2.getID().substring(TBL_VERSIONEDTABLES.length() + 1));
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
        if (tableId == null) {
            throw new RuntimeException("Table " + typeName + " does not appear " + "to be versioned, there is no record of it in " + TBL_VERSIONEDTABLES);
        }
        q = new DefaultQuery(TBL_TABLESCHANGED);
        q.setFilter((Filter)this.ff.equal((Expression)this.ff.property("versionedtable"), (Expression)this.ff.literal((Object)tableId), false));
        q.setSortBy(new SortBy[]{this.ff.sort(REVISION, SortOrder.ASCENDING)});
        q.setMaxFeatures(1);
        try {
            fr = this.wrapped.getFeatureReader((Query)q, transaction);
            if (!fr.hasNext()) {
                long feature2 = -1L;
                return feature2;
            }
            feature2 = (SimpleFeature)fr.next();
            long l = (Long)feature2.getAttribute(REVISION);
            return l;
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
    }

    Filter buildFidFilter(Set ids) {
        HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
        for (String id : ids) {
            featureIds.add(this.ff.featureId(id));
        }
        return this.ff.id(featureIds);
    }

    protected synchronized void checkVersioningDataStructures() throws IOException {
        Connection conn = null;
        Statement st = null;
        ResultSet tables = null;
        try {
            conn = this.wrapped.getDataSource().getConnection();
            conn.setAutoCommit(false);
            boolean changeSets = false;
            boolean tablesChanged = false;
            boolean versionedTables = false;
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableType = new String[]{"TABLE"};
            tables = meta.getTables(null, this.getConfig().getDatabaseSchemaName(), "%", tableType);
            while (tables.next()) {
                String tableName = tables.getString(3);
                if (tableName.equals(TBL_CHANGESETS)) {
                    changeSets = true;
                }
                if (tableName.equals(TBL_TABLESCHANGED)) {
                    tablesChanged = true;
                }
                if (!tableName.equals(TBL_VERSIONEDTABLES)) continue;
                versionedTables = true;
            }
            if (!(changeSets && tablesChanged && versionedTables)) {
                if (changeSets || tablesChanged || versionedTables) {
                    String msg = "The versioning tables are not complete, yet some table with the same name is there.\n";
                    msg = msg + "Remove tables (";
                    if (changeSets) {
                        msg = msg + "changesets ";
                    }
                    if (tablesChanged) {
                        msg = msg + "tables_changed ";
                    }
                    if (versionedTables) {
                        msg = msg + TBL_VERSIONEDTABLES;
                    }
                    msg = msg + ") before using again the versioned data store";
                    throw new IOException(msg);
                }
                st = conn.createStatement();
                this.execute(st, "CREATE TABLE versioned_tables(ID SERIAL PRIMARY KEY, SCHEMA VARCHAR(63) NOT NULL, NAME VARCHAR(63) NOT NULL, VERSIONED BOOLEAN NOT NULL)");
                this.execute(st, "CREATE TABLE changesets(REVISION BIGSERIAL PRIMARY KEY, AUTHOR VARCHAR(256), DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, MESSAGE TEXT)");
                String schema = this.getConfig().getDatabaseSchemaName();
                if (schema == null) {
                    schema = "public";
                }
                this.execute(st, "SELECT ADDGEOMETRYCOLUMN('" + schema + "', '" + TBL_CHANGESETS + "', 'bbox', 4326,  'POLYGON', 2)");
                this.execute(st, "CREATE TABLE tables_changed(REVISION BIGINT NOT NULL REFERENCES changesets, VERSIONEDTABLE INT NOT NULL REFERENCES versioned_tables, PRIMARY KEY (REVISION, VERSIONEDTABLE))");
                conn.commit();
            }
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)sqlException);
                conn = null;
                String message = "Error querying database for list of tables:" + sqlException.getMessage();
                throw new DataSourceException(message, (Throwable)sqlException);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(tables);
                JDBCUtils.close(st);
                JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)tables);
        JDBCUtils.close(st);
        JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        this.resetTypeInfo();
    }

    void resetTypeInfo() throws IOException {
        this.wrapped.getTypeHandler().forceRefresh();
        this.wrapped.getTypeHandler().resetFIDMappers();
        VersionedFIDMapperFactory factory = (VersionedFIDMapperFactory)this.wrapped.getFIDMapperFactory();
        factory.setVersionedTypes(this.getVersionedTypeNames());
    }

    private String[] getVersionedTypeNames() throws IOException {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            PostgisSQLBuilder sqlb = this.wrapped.createSQLBuilder();
            conn = this.wrapped.getDataSource().getConnection();
            st = conn.createStatement();
            rs = this.executeQuery(st, "SELECT NAME from " + sqlb.encodeTableName(TBL_VERSIONEDTABLES) + " WHERE SCHEMA = '" + this.getConfig().getDatabaseSchemaName() + "'" + " AND VERSIONED ='" + true + "'");
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
        }
        catch (SQLException sqlException) {
            try {
                String message = "Error querying database for list of versioned tables:" + sqlException.getMessage();
                throw new DataSourceException(message, (Throwable)sqlException);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(st);
                JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        return tables.toArray(new String[tables.size()]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void enableVersioning(String typeName, String author, String message) throws IOException, DataSourceException {
        FIDMapper mapper = this.wrapped.getFIDMapper(typeName);
        if (!this.checkSupportedMapper(mapper)) {
            if (!(mapper instanceof TypedFIDMapper)) throw new IOException("This feature type (" + typeName + ") is associated to " + "an unsupported fid mapper: " + mapper.getClass() + "\n" + "The supported fid mapper classes are: " + Arrays.asList(SUPPORTED_FID_MAPPERS));
            mapper = ((TypedFIDMapper)mapper).getWrappedMapper();
            throw new IOException("This feature type (" + typeName + ") is associated to " + "an unsupported fid mapper: " + mapper.getClass() + "\n" + "The supported fid mapper classes are: " + Arrays.asList(SUPPORTED_FID_MAPPERS));
        }
        if (message == null) {
            message = "Version enabling " + typeName;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        PostgisSQLBuilder sqlb = this.wrapped.createSQLBuilder();
        DefaultTransaction t = new DefaultTransaction();
        t.putProperty((Object)"VersioningCommitAuthor", (Object)author);
        t.putProperty((Object)"VersioningCommitMessage", (Object)message);
        try {
            PkDescriptor pk;
            GeometryDescriptor defaultGeometry;
            VersionedJdbcTransactionState state = this.wrapped.getVersionedJdbcTransactionState((Transaction)t);
            state.setTypeNameDirty(typeName);
            long revision = state.getRevision();
            ReferencedEnvelope envelope = this.wrapped.getFeatureSource(typeName).getBounds();
            if (envelope != null && (defaultGeometry = this.wrapped.getSchema(typeName).getGeometryDescriptor()) != null) {
                CoordinateReferenceSystem crs = defaultGeometry.getCoordinateReferenceSystem();
                if (crs != null) {
                    envelope = JTS.toGeographic((Envelope)envelope, (CoordinateReferenceSystem)crs);
                }
                state.expandDirtyBounds((Envelope)envelope);
            }
            if ((pk = this.getPrimaryKeyConstraintName(conn = state.getConnection(), typeName)) == null) {
                throw new DataSourceException("Cannot version tables without primary keys");
            }
            String colList = "";
            for (int i = 0; i < pk.columns.length; ++i) {
                colList = colList + "," + pk.columns[i];
            }
            st = conn.createStatement();
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " DROP CONSTRAINT " + pk.name);
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ADD COLUMN REVISION BIGINT REFERENCES " + TBL_CHANGESETS);
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ADD COLUMN EXPIRED BIGINT NOT NULL DEFAULT " + Long.MAX_VALUE);
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ADD COLUMN CREATED BIGINT REFERENCES " + TBL_CHANGESETS);
            this.execute(st, "UPDATE " + sqlb.encodeTableName(typeName) + " SET REVISION = " + revision + " , CREATED = " + revision);
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ALTER REVISION SET NOT NULL");
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ALTER CREATED SET NOT NULL");
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ADD CONSTRAINT " + pk.name + " PRIMARY KEY(REVISION " + colList + ")");
            this.execute(st, "CREATE INDEX " + typeName.toUpperCase() + "_REVIDX" + " ON " + typeName + "(EXPIRED" + colList + ")");
            rs = this.executeQuery(st, "SELECT VERSIONED from " + sqlb.encodeTableName(TBL_VERSIONEDTABLES) + " WHERE SCHEMA = '" + this.getConfig().getDatabaseSchemaName() + "'" + " AND NAME='" + typeName + "'");
            if (rs.next()) {
                this.execute(st, "UPDATE " + sqlb.encodeTableName(TBL_VERSIONEDTABLES) + " SET VERSIONED = TRUE " + " WHERE SCHEMA = '" + this.getConfig().getDatabaseSchemaName() + "'" + " AND NAME='" + typeName + "'");
            } else {
                this.execute(st, "INSERT INTO " + sqlb.encodeTableName(TBL_VERSIONEDTABLES) + " VALUES(default, " + "'" + this.getConfig().getDatabaseSchemaName() + "','" + typeName + "', TRUE)");
            }
            rs.close();
            this.createVersionedFeatureCollectionView(typeName, conn);
            t.commit();
            this.resetTypeInfo();
        }
        catch (SQLException sql) {
            try {
                throw new DataSourceException("Error occurred during version enabling. Does your table have columns with reserved names?", (Throwable)sql);
                catch (TransformException e) {
                    throw new DataSourceException("Error occurred while trying to compute the lat/lon bounding box affected by this operation", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(st);
                JDBCUtils.close(conn, (Transaction)t, null);
                t.close();
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Connection)conn, (Transaction)t, null);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createVersionedFeatureCollectionView(String typeName) throws IOException {
        Connection conn = null;
        DefaultTransaction t = new DefaultTransaction();
        try {
            conn = this.wrapped.getConnection((Transaction)t);
            this.createVersionedFeatureCollectionView(typeName, conn);
            t.commit();
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)t, null);
        }
    }

    private void createVersionedFeatureCollectionView(String typeName, Connection conn) throws IOException {
        Statement st = null;
        try {
            st = conn.createStatement();
            String viewName = VersionedPostgisDataStore.getVFCViewName(typeName);
            st.execute("CREATE VIEW " + viewName + "\n " + "AS SELECT " + "cr.revision as \"creationVersion\", cr.author as \"createdBy\", " + "cr.date as \"creationDate\", cr.message as \"creationMessage\",  " + "lu.revision as \"lastUpdateVersion\", lu.author as \"lastUpdatedBy\", " + "lu.date as \"lastUpdateDate\", lu.message as \"lastUpdateMessage\"," + typeName + ".*\n" + "FROM " + typeName + " inner join " + " changesets lu on " + typeName + ".revision = lu.revision " + " inner join changesets cr on " + typeName + ".created = cr.revision");
            st.execute("DELETE FROM geometry_columns WHERE f_table_schema = current_schema()AND f_table_name = '" + viewName + "'");
            st.execute("INSERT INTO geometry_columns \nSELECT '', current_schema(), '" + viewName + "', " + "       gc.f_geometry_column, gc.coord_dimension, gc.srid, gc.type\n" + "FROM geometry_columns as gc\n" + "WHERE gc.f_table_name = '" + typeName + "'");
        }
        catch (SQLException e) {
            throw new DataSourceException("Issues creating versioned feature collection view for " + typeName, (Throwable)e);
        }
        finally {
            JDBCUtils.close((Statement)st);
        }
    }

    public static String getVFCViewName(String typeName) {
        return typeName + "_vfc_view";
    }

    public static String getVFCTableName(String vfcTypeName) throws IOException {
        if (vfcTypeName.endsWith("_vfc_view")) {
            return vfcTypeName.substring(0, vfcTypeName.lastIndexOf("_vfc_view"));
        }
        throw new IOException("Specified type " + vfcTypeName + " is not a versioned feature collection view");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void disableVersioning(String typeName, String author, String message) throws IOException {
        if (message == null) {
            message = "Version disabling " + typeName;
        }
        Connection conn = null;
        Statement st = null;
        PostgisSQLBuilder sqlb = this.wrapped.createSQLBuilder();
        DefaultTransaction t = new DefaultTransaction();
        t.putProperty((Object)"VersioningCommitAuthor", (Object)author);
        t.putProperty((Object)"VersioningCommitMessage", (Object)message);
        try {
            VersionedJdbcTransactionState state = this.wrapped.getVersionedJdbcTransactionState((Transaction)t);
            state.setTypeNameDirty(typeName);
            state.getRevision();
            ReferencedEnvelope envelope = this.wrapped.getFeatureSource(typeName).getBounds();
            if (envelope != null && this.wrapped.getSchema(typeName).getGeometryDescriptor() != null) {
                CoordinateReferenceSystem crs = this.wrapped.getSchema(typeName).getGeometryDescriptor().getCoordinateReferenceSystem();
                if (crs != null) {
                    envelope = JTS.toGeographic((Envelope)envelope, (CoordinateReferenceSystem)crs);
                }
                state.expandDirtyBounds((Envelope)envelope);
            }
            conn = state.getConnection();
            st = conn.createStatement();
            try {
                st.execute("DROP VIEW " + typeName + "_vfc_view");
            }
            catch (SQLException e) {
                // empty catch block
            }
            st.execute("DELETE FROM geometry_columns WHERE f_table_schema = current_schema()    AND f_table_name = '" + typeName + "_vfc_view'");
            st.execute("DELETE FROM " + sqlb.encodeTableName(typeName) + " WHERE expired <> " + Long.MAX_VALUE);
            PkDescriptor pk = this.getPrimaryKeyConstraintName(conn, typeName);
            if (pk == null) {
                throw new DataSourceException("Cannot version tables without primary keys");
            }
            String colList = "";
            for (int i = 1; i < pk.columns.length; ++i) {
                colList = colList + "," + pk.columns[i];
            }
            colList = colList.substring(1);
            this.execute(st, "DROP INDEX " + sqlb.encodeTableName(typeName.toLowerCase() + "_revidx"));
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " DROP CONSTRAINT " + pk.name);
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " DROP COLUMN REVISION");
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " DROP COLUMN EXPIRED");
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " DROP COLUMN CREATED");
            this.execute(st, "ALTER TABLE " + sqlb.encodeTableName(typeName) + " ADD CONSTRAINT " + pk.name + " PRIMARY KEY(" + colList + ")");
            this.execute(st, "UPDATE " + sqlb.encodeTableName(TBL_VERSIONEDTABLES) + " SET VERSIONED = FALSE WHERE SCHEMA = '" + this.getConfig().getDatabaseSchemaName() + "' AND NAME = '" + typeName + "'");
            t.commit();
            this.resetTypeInfo();
        }
        catch (SQLException sql) {
            try {
                throw new DataSourceException("Error occurred during version disabling", (Throwable)sql);
                catch (TransformException e) {
                    throw new DataSourceException("Error occurred while trying to compute the lat/lon bounding box affected by this operation", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(st);
                JDBCUtils.close(conn, (Transaction)t, null);
                t.close();
                throw throwable;
            }
        }
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Connection)conn, (Transaction)t, null);
        t.close();
    }

    protected void execute(Statement st, String sql) throws SQLException {
        LOGGER.fine(sql);
        st.execute(sql);
    }

    protected ResultSet executeQuery(Statement st, String sql) throws SQLException {
        LOGGER.fine(sql);
        return st.executeQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PkDescriptor getPrimaryKeyConstraintName(Connection conn, String table) throws SQLException {
        ResultSet columns;
        PkDescriptor descriptor;
        block4: {
            descriptor = null;
            columns = null;
            columns = conn.getMetaData().getPrimaryKeys(null, this.getConfig().getDatabaseSchemaName(), table);
            if (columns.next()) break block4;
            PkDescriptor pkDescriptor = null;
            JDBCUtils.close((ResultSet)columns);
            return pkDescriptor;
        }
        try {
            descriptor = new PkDescriptor();
            descriptor.name = columns.getString("PK_NAME");
            ArrayList<String> colnames = new ArrayList<String>();
            do {
                colnames.add(columns.getString("COLUMN_NAME"));
            } while (columns.next());
            descriptor.columns = colnames.toArray(new String[colnames.size()]);
        }
        catch (Throwable throwable) {
            JDBCUtils.close(columns);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)columns);
        return descriptor;
    }

    private boolean checkSupportedMapper(FIDMapper mapper) {
        if (mapper instanceof TypedFIDMapper) {
            mapper = ((TypedFIDMapper)mapper).getWrappedMapper();
        }
        for (int i = 0; i < SUPPORTED_FID_MAPPERS.length; ++i) {
            if (!SUPPORTED_FID_MAPPERS[i].isAssignableFrom(mapper.getClass())) continue;
            return true;
        }
        return false;
    }

    Filter buildVersionedFilter(String featureTypeName, Filter filter, RevisionInfo ri) throws IOException {
        PropertyIsEqualTo extraFilter = null;
        if (ri.isLast()) {
            extraFilter = this.ff.equals((Expression)this.ff.property("expired"), (Expression)this.ff.literal(Long.MAX_VALUE));
        } else {
            PropertyIsLessThanOrEqualTo revf = this.ff.lessOrEqual((Expression)this.ff.property(REVISION), (Expression)this.ff.literal(ri.revision));
            PropertyIsGreaterThan expf = this.ff.greater((Expression)this.ff.property("expired"), (Expression)this.ff.literal(ri.revision));
            extraFilter = this.ff.and((Filter)revf, (Filter)expf);
        }
        if (filter.equals(Filter.EXCLUDE)) {
            return Filter.EXCLUDE;
        }
        if (filter.equals(Filter.INCLUDE)) {
            return extraFilter;
        }
        Filter transformedFidFilter = this.transformFidFilter(featureTypeName, filter);
        And newFilter = this.ff.and(transformedFidFilter, (Filter)extraFilter);
        return newFilter;
    }

    protected Filter transformFidFilter(String featureTypeName, Filter filter) throws IOException, FactoryRegistryException {
        if (this.isVersionedFeatureCollection(featureTypeName)) {
            featureTypeName = VersionedPostgisDataStore.getVFCTableName(featureTypeName);
        }
        SimpleFeatureType featureType = this.wrapped.getSchema(featureTypeName);
        VersionedFIDMapper mapper = (VersionedFIDMapper)this.wrapped.getFIDMapper(featureTypeName);
        FidTransformeVisitor transformer = new FidTransformeVisitor(this.ff, featureType, mapper);
        Filter clone = (Filter)filter.accept((FilterVisitor)transformer, null);
        return clone;
    }

    DefaultQuery buildVersionedQuery(Query query) throws IOException {
        RevisionInfo ri = new RevisionInfo(query.getVersion());
        Filter newFilter = this.buildVersionedFilter(query.getTypeName(), query.getFilter(), ri);
        DefaultQuery versionedQuery = new DefaultQuery(query);
        versionedQuery.setPropertyNames(this.filterPropertyNames(query));
        versionedQuery.setFilter(newFilter);
        return versionedQuery;
    }

    private String[] filterPropertyNames(Query query) throws IOException {
        String[] names = this.wrapped.propertyNames(query);
        HashSet<String> extraColumns = new HashSet<String>();
        if (this.isVersionedFeatureCollection(query.getTypeName()) || this.isVersioned(query.getTypeName(), null)) {
            extraColumns.add(REVISION);
            extraColumns.add("expired");
            extraColumns.add("created");
        }
        FIDMapper mapper = this.getFIDMapper(query.getTypeName());
        for (int i = 0; i < mapper.getColumnCount(); ++i) {
            extraColumns.add(mapper.getColumnName(i).toLowerCase());
        }
        ArrayList<String> filtered = new ArrayList<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            if (extraColumns.contains(names[i])) continue;
            filtered.add(names[i]);
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    public void dispose() {
        if (this.wrapped != null) {
            this.wrapped.dispose();
            this.wrapped = null;
        }
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(typeName));
        }
        return names;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    private static class PkDescriptor {
        String name;
        String[] columns;

        private PkDescriptor() {
        }
    }
}

