/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FeatureTypeHandler;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.data.postgis.VersionedJdbcTransactionState;
import org.geotools.data.postgis.fidmapper.PostgisFIDMapperFactory;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapperFactory;

class WrappedPostgisDataStore
extends PostgisDataStore {
    public WrappedPostgisDataStore(DataSource dataSource, JDBCDataStoreConfig config, int optimizeMode) throws IOException {
        super(dataSource, config, optimizeMode);
    }

    public WrappedPostgisDataStore(DataSource dataSource, String schema, String namespace, int optimizeMode) throws IOException {
        super(dataSource, schema, namespace, optimizeMode);
    }

    public WrappedPostgisDataStore(DataSource dataSource, String schema, String namespace) throws IOException {
        super(dataSource, schema, namespace);
    }

    public WrappedPostgisDataStore(DataSource dataSource, String namespace) throws IOException {
        super(dataSource, namespace);
    }

    public WrappedPostgisDataStore(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    public Connection getConnection(Transaction transaction) throws IOException {
        if (transaction != Transaction.AUTO_COMMIT) {
            VersionedJdbcTransactionState state = this.getVersionedJdbcTransactionState(transaction);
            return state.getConnection();
        }
        try {
            return this.createConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Connection failed:" + sqle, (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionedJdbcTransactionState getVersionedJdbcTransactionState(Transaction transaction) throws IOException, DataSourceException {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            VersionedJdbcTransactionState state = (VersionedJdbcTransactionState)transaction.getState((Object)this);
            if (state == null) {
                try {
                    Connection conn = this.createConnection();
                    conn.setAutoCommit(this.requireAutoCommit());
                    if (this.getTransactionIsolation() != 0) {
                        conn.setTransactionIsolation(this.getTransactionIsolation());
                    }
                    state = new VersionedJdbcTransactionState(conn, this);
                    transaction.putState((Object)this, (Transaction.State)state);
                }
                catch (SQLException eep) {
                    throw new DataSourceException("Connection failed:" + eep, (Throwable)eep);
                }
            }
            return state;
        }
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new VersionedFIDMapperFactory((FIDMapperFactory)new PostgisFIDMapperFactory(config));
    }

    public String[] propertyNames(Query query) throws IOException {
        return super.propertyNames(query);
    }

    public JDBCDataStoreConfig getConfig() {
        return this.config;
    }

    public FeatureTypeHandler getTypeHandler() {
        return this.typeHandler;
    }
}

