/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

class FidTransformeVisitor
extends DuplicatingFilterVisitor {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    private VersionedFIDMapper mapper;
    private Object featureType;

    public FidTransformeVisitor(FilterFactory2 factory, SimpleFeatureType featureType, VersionedFIDMapper mapper) {
        super(factory);
        this.mapper = mapper;
        this.featureType = featureType;
    }

    public Object visit(Id filter, Object extraData) {
        Set ids = filter.getIDs();
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("Invalid fid filter provides, has no fids inside");
        }
        Or result = null;
        ArrayList<PropertyIsEqualTo> transformedIdFilters = new ArrayList<PropertyIsEqualTo>();
        for (String id : ids) {
            Object[] attributes;
            try {
                attributes = this.mapper.getUnversionedPKAttributes(id);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Skipping fid " + id + " since it's not in the " + "proper format for this datastore" + e.getMessage());
                continue;
            }
            Object idf = null;
            int i = 0;
            int j = 0;
            while (i < attributes.length) {
                String colName = this.mapper.getColumnName(j);
                if (!"revision".equals(colName)) {
                    transformedIdFilters.add(this.ff.equals((Expression)this.ff.property(colName), (Expression)this.ff.literal(attributes[i])));
                    ++i;
                }
                ++j;
            }
        }
        if (transformedIdFilters.size() > 1) {
            result = this.ff.or(transformedIdFilters);
        } else if (transformedIdFilters.size() == 1) {
            result = (Filter)transformedIdFilters.get(0);
        }
        if (result == null) {
            PropertyIsEqualTo equal = this.ff.equals((Expression)this.ff.literal(0), (Expression)this.ff.literal(1));
            return equal;
        }
        return result;
    }
}

