/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.fidmapper;

import java.io.IOException;
import java.rmi.server.UID;
import java.sql.Connection;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.MultiColumnFIDMapper;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

class VersionedMulticolumnFIDMapper
extends MultiColumnFIDMapper
implements VersionedFIDMapper {
    public VersionedMulticolumnFIDMapper(String tableSchemaName, String tableName, String[] colNames, int[] colTypes, int[] colSizes, int[] colDecimalDigits, boolean[] autoIncrement) {
        super(tableSchemaName, tableName, colNames, colTypes, colSizes, colDecimalDigits, autoIncrement);
        this.returnFIDColumnsAsAttributes = true;
    }

    public String getUnversionedFid(String versionedFID) {
        return this.tableName + "." + versionedFID.substring(versionedFID.indexOf(38) + 1);
    }

    public String createVersionedFid(String externalFID, long revision) {
        return revision + "&" + externalFID.substring(this.tableName.length() + 1);
    }

    public Object[] getUnversionedPKAttributes(String FID) throws IOException {
        if (!FID.startsWith(this.tableName + ".")) {
            throw new DataSourceException("The FID is invalid, should start with '" + this.tableName + "', it's " + FID + " instead");
        }
        Object[] values = super.getPKAttributes("0&" + FID.substring(this.tableName.length() + 1));
        Object[] unversioned = new Object[values.length - 1];
        System.arraycopy(values, 1, unversioned, 0, unversioned.length);
        return unversioned;
    }

    public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        if (this.colNames.length == 2 && feature.getAttribute(this.colNames[1]) == null) {
            try {
                feature.setAttribute(this.colNames[1], (Object)new UID().toString());
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Could not generate key for the unset primary key column " + this.colNames[0], (Throwable)e);
            }
        }
        return super.createID(conn, feature, statement);
    }

    public Object[] getPKAttributes(String FID) throws IOException {
        return super.getPKAttributes(FID);
    }
}

