/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.AbstractPostgisDataTestCase;
import org.geotools.data.postgis.PostgisDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class PostgisWithoutGeosOnlineTest
extends AbstractPostgisDataTestCase {
    public PostgisWithoutGeosOnlineTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public String getFixtureFile() {
        return "nogeos.properties";
    }

    public void _testBboxQuery() throws Exception {
        ArrayList<Envelope> bbox = new ArrayList<Envelope>();
        ArrayList<String> fids = new ArrayList<String>();
        FeatureCollection fc = this.data.getFeatureSource("road").getFeatures();
        for (SimpleFeature f : fc) {
            bbox.add(((Geometry)f.getDefaultGeometry()).getEnvelopeInternal());
            fids.add(f.getID());
        }
        SimpleFeatureType type = this.data.getSchema("road");
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        for (int i = 0; i < bbox.size(); ++i) {
            Envelope box = (Envelope)bbox.get(i);
            String fid = (String)fids.get(i);
            GeometryFilter filter = ff.createGeometryFilter((short)4);
            filter.addLeftGeometry((Expression)ff.createAttributeExpression(type, "geom"));
            filter.addRightGeometry((Expression)ff.createBBoxExpression(box));
            FeatureReader reader = ((PostgisDataStore)this.data).getFeatureReader(type, (Filter)filter, Transaction.AUTO_COMMIT);
            boolean found = false;
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (!fid.equals(f.getID())) continue;
                found = true;
            }
            reader.close();
            PostgisWithoutGeosOnlineTest.assertTrue((boolean)found);
        }
    }

    public void testBboxQueryWithLooseBBOX() throws Exception {
        ((PostgisDataStore)this.data).setLooseBbox(true);
        this._testBboxQuery();
    }

    public void testBboxQueryWithoutLooseBBOX() throws Exception {
        ((PostgisDataStore)this.data).setLooseBbox(false);
        this._testBboxQuery();
    }
}

