/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderPostgisGeos;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class SQLEncoderPostgisGeosTest
extends TestCase {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    protected static SimpleFeatureType testSchema = null;
    protected static SimpleFeature testFeature = null;
    TestSuite suite = null;
    String dataFolder = "";
    protected boolean setup = false;

    public SQLEncoderPostgisGeosTest(String testName) {
        super(testName);
        LOGGER.finer("running SQLEncoderTests - SQLEncoderPostgisGeosTest");
        this.dataFolder = System.getProperty("dataFolder");
        if (this.dataFolder == null) {
            this.dataFolder = System.getProperty("basedir");
            this.dataFolder = this.dataFolder + "/tests/unit/testData";
        }
    }

    protected void setUp() throws SchemaException, IllegalAttributeException {
        if (this.setup) {
            return;
        }
        this.prepareFeatures();
        this.setup = true;
    }

    protected void prepareFeatures() throws SchemaException, IllegalAttributeException {
        LOGGER.finer("creating flat feature...");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testZeroDouble", Double.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        GeometryFactory geomFac = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[]{geomFac.createLineString(coords), new Boolean(true), new Character('t'), new Byte("10"), new Short("101"), new Integer(1002), new Long(10003L), new Float(10000.4), new Double(100000.5), "test string data"};
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
        LOGGER.finer("...flat feature created");
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SQLEncoderPostgisGeosTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SQLEncoderPostgisGeosTest.class);
        return suite;
    }

    public void test1() throws Exception {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        GeometryFilter gf = factory.createGeometryFilter((short)4);
        BBoxExpressionImpl right = new BBoxExpressionImpl(new Envelope(0.0, 300.0, 0.0, 300.0));
        gf.addRightGeometry((Expression)right);
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        gf.addLeftGeometry((Expression)left);
        SQLEncoderPostgisGeos encoder = new SQLEncoderPostgisGeos();
        encoder.setLooseBbox(true);
        encoder.setSRID(2356);
        String out = encoder.encode((Filter)gf);
        LOGGER.fine("Resulting SQL filter is \n" + out);
        SQLEncoderPostgisGeosTest.assertEquals((String)"WHERE \"testGeometry\" && GeometryFromText('POLYGON ((0 0, 0 300, 300 300, 300 0, 0 0))', 2356)", (String)out);
    }

    public void test2() throws Exception {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        GeometryFilter gf = factory.createGeometryFilter((short)4);
        BBoxExpressionImpl left = new BBoxExpressionImpl(new Envelope(10.0, 300.0, 10.0, 300.0));
        gf.addLeftGeometry((Expression)left);
        SQLEncoderPostgisGeos encoder = new SQLEncoderPostgisGeos(2346);
        encoder.setDefaultGeometry("testGeometry");
        String out = encoder.encode((Filter)gf);
        LOGGER.fine("Resulting SQL filter is \n" + out);
        SQLEncoderPostgisGeosTest.assertEquals((String)out, (String)"WHERE GeometryFromText('POLYGON ((10 10, 10 300, 300 300, 300 10, 10 10))', 2346) && \"testGeometry\" AND intersects(GeometryFromText('POLYGON ((10 10, 10 300, 300 300, 300 10, 10 10))', 2346), \"testGeometry\")");
    }

    public void testFid() throws Exception {
        FilterFactory filterFac = FilterFactoryFinder.createFilterFactory();
        FidFilter fidFilter = filterFac.createFidFilter("road.345");
        SQLEncoderPostgisGeos encoder = new SQLEncoderPostgisGeos();
        encoder.setFIDMapper((FIDMapper)new TypedFIDMapper((FIDMapper)new BasicFIDMapper("gid", 255, true), "road"));
        String out = encoder.encode((Filter)((AbstractFilterImpl)fidFilter));
        LOGGER.fine("Resulting SQL filter is \n" + out);
        SQLEncoderPostgisGeosTest.assertEquals((String)out, (String)"WHERE (\"gid\" = '345')");
    }

    public void test3() throws Exception {
        FilterFactory filterFac = FilterFactoryFinder.createFilterFactory();
        CompareFilter compFilter = filterFac.createCompareFilter((short)14);
        compFilter.addLeftValue((Expression)filterFac.createAttributeExpression(testSchema, "testInteger"));
        compFilter.addRightValue((Expression)filterFac.createLiteralExpression((Object)new Double(5.0)));
        SQLEncoderPostgisGeos encoder = new SQLEncoderPostgisGeos(2346);
        String out = encoder.encode((Filter)compFilter);
        LOGGER.fine("Resulting SQL filter is \n" + out);
        SQLEncoderPostgisGeosTest.assertEquals((String)out, (String)"WHERE \"testInteger\" = 5.0");
    }

    public void test4() throws Exception {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        GeometryFilter gf = factory.createGeometryFilter((short)6);
        BBoxExpressionImpl left = new BBoxExpressionImpl(new Envelope(10.0, 300.0, 10.0, 300.0));
        gf.addLeftGeometry((Expression)left);
        SQLEncoderPostgisGeos encoder = new SQLEncoderPostgisGeos(2346);
        encoder.setDefaultGeometry("testGeometry");
        String out = encoder.encode((Filter)gf);
        LOGGER.fine("Resulting SQL filter is \n" + out);
        SQLEncoderPostgisGeosTest.assertEquals((String)out, (String)"WHERE NOT (intersects(GeometryFromText('POLYGON ((10 10, 10 300, 300 300, 300 10, 10 10))', 2346), \"testGeometry\"))");
    }

    public void testException() throws Exception {
        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
        GeometryFilter gf = factory.createGeometryFilter((short)13);
        BBoxExpressionImpl right = new BBoxExpressionImpl(new Envelope(10.0, 10.0, 300.0, 300.0));
        gf.addRightGeometry((Expression)right);
        AttributeExpressionImpl left = new AttributeExpressionImpl(testSchema, "testGeometry");
        gf.addLeftGeometry((Expression)left);
        try {
            SQLEncoderPostgisGeos encoder = new SQLEncoderPostgisGeos(2346);
            String out = encoder.encode((Filter)gf);
            LOGGER.fine("out is " + out);
            SQLEncoderPostgisGeosTest.fail((String)"This filter type should not be supported at the moment?");
        }
        catch (SQLEncoderException e) {
            LOGGER.fine(e.getMessage());
            SQLEncoderPostgisGeosTest.assertEquals((String)"Filter type not supported", (String)e.getMessage());
        }
    }
}

