/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.referencing;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.referencing.JDBCAuthorityFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostgisAuthorityFactory
extends JDBCAuthorityFactory {
    private static final Logger LOGGER = Logging.getLogger(PostgisAuthorityFactory.class);
    private String TABLE_NAME = "SPATIAL_REF_SYS";
    private String WKT_COLUMN = "SRTEXT";
    private String SRID_COLUMN = "SRID";
    private String AUTH_NAME = "AUTH_NAME";
    private String AUTH_SRID = "AUTH_SRID";

    public PostgisAuthorityFactory(DataSource pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createCRS(int srid) throws FactoryException, IOException {
        Connection dbConnection;
        block9: {
            dbConnection = null;
            String sqlStatement = "SELECT * FROM " + this.TABLE_NAME + " WHERE " + this.SRID_COLUMN + " = " + srid;
            dbConnection = this.dataSource.getConnection();
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block9;
            CoordinateReferenceSystem crs = null;
            try {
                String name = result.getString(this.AUTH_NAME);
                int id = result.getInt(this.AUTH_SRID);
                crs = this.createFromAuthority(name, id);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (crs == null) {
                crs = this.createFromWKT(result);
            }
            JDBCUtils.close((Statement)statement);
            CoordinateReferenceSystem coordinateReferenceSystem = crs;
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            return coordinateReferenceSystem;
        }
        try {
            try {
                String mesg = "No row found for " + srid + " in table: " + this.TABLE_NAME;
                throw new FactoryException(mesg);
            }
            catch (SQLException sqle) {
                LOGGER.log(Level.FINE, "Error occurred while accessing the {0} table, switching to direct EPSG factory decode", this.TABLE_NAME);
                CoordinateReferenceSystem coordinateReferenceSystem = this.createFromAuthority("EPSG", srid);
                return coordinateReferenceSystem;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            JDBCUtils.close(dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    protected CoordinateReferenceSystem createFromWKT(ResultSet result) throws DataSourceException, FactoryException {
        try {
            String wkt = result.getString(this.WKT_COLUMN);
            return this.factory.createFromWKT(wkt);
        }
        catch (SQLException sqle) {
            String message = sqle.getMessage();
            throw new DataSourceException(message, (Throwable)sqle);
        }
    }

    protected CoordinateReferenceSystem createFromAuthority(String authName, int srid) throws DataSourceException, FactoryException {
        return CRS.decode((String)(authName + ":" + srid));
    }
}

