/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.referencing;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.data.postgis.PostgisTests;
import org.geotools.data.postgis.referencing.PostgisAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostgisAuthorityFactoryOnlineTest
extends TestCase {
    private String TABLE_NAME = "SPATIAL_REF_SYS";
    private String SRID_COLUMN = "SRID";

    public int getSRIDs(DataSource pool) throws Exception {
        Connection dbConnection;
        block5: {
            dbConnection = null;
            String sqlStatement = "SELECT " + this.SRID_COLUMN + " FROM " + this.TABLE_NAME;
            dbConnection = pool.getConnection();
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block5;
            int srid = result.getInt("srid");
            JDBCUtils.close((Statement)statement);
            int n = srid;
            JDBCUtils.close((Connection)dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            return n;
        }
        try {
            try {
                String mesg = "No srid column row: " + this.TABLE_NAME;
                throw new DataSourceException(mesg);
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(dbConnection, (Transaction)Transaction.AUTO_COMMIT, null);
            throw throwable;
        }
    }

    public void testCreateCRS() throws Exception {
        PostgisTests.Fixture f = PostgisTests.newFixture();
        String url = "jdbc:postgresql://" + f.host + ":" + f.port + "/" + f.database;
        ManageableDataSource pool = PostgisDataStoreFactory.getDefaultDataSource((String)f.host, (String)f.user, (String)f.password, (int)f.port, (String)f.database, (int)10, (int)2, (boolean)false);
        PostgisAuthorityFactory factory = new PostgisAuthorityFactory((DataSource)pool);
        CoordinateReferenceSystem crs = factory.createCRS(this.getSRIDs((DataSource)pool));
        PostgisAuthorityFactoryOnlineTest.assertNotNull((Object)crs);
    }
}

