/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.dem;

import java.awt.RenderingHints;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.process.dem.DEMTools;
import org.geotools.process.dem.DescribeParameter;
import org.geotools.process.dem.DescribeProcess;
import org.geotools.process.dem.DescribeResult;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEMProcessFactory
implements ProcessFactory {
    private static final String VERSION_STRING = "0.0.1";
    Class<?> TARGET = DEMTools.class;
    String namespace = "http://localhost/dem/";

    @Override
    public Process create(Name name) {
        return new ProcessInvocation(DEMTools.class, name.getLocalPart());
    }

    @Override
    public InternationalString getTitle() {
        return new SimpleInternationalString("DEM Tools");
    }

    @Override
    public InternationalString getDescription(Name name) {
        Method method = this.method(name.getLocalPart());
        if (method == null) {
            return null;
        }
        DescribeProcess info = method.getAnnotation(DescribeProcess.class);
        if (info != null) {
            return new SimpleInternationalString(info.description());
        }
        return null;
    }

    public Method method(String name) {
        Method[] methodArray = this.TARGET.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            DescribeProcess INFO = method.getAnnotation(DescribeProcess.class);
            if (INFO != null && name.equalsIgnoreCase(method.getName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<Name> getNames() {
        LinkedHashSet<Name> names = new LinkedHashSet<Name>();
        Method[] methodArray = this.TARGET.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            DescribeProcess INFO = method.getAnnotation(DescribeProcess.class);
            if (INFO != null) {
                names.add((Name)new NameImpl(this.namespace, method.getName()));
            }
            ++n2;
        }
        return names;
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo(Name name) {
        Method method = this.method(name.getLocalPart());
        LinkedHashMap input = new LinkedHashMap();
        Annotation[][] PARAM_INFO = method.getParameterAnnotations();
        Class<?>[] PARAM_TYPE = method.getParameterTypes();
        int i = 0;
        while (i < PARAM_TYPE.length) {
            Parameter<?> param = this.paramInfo(i, PARAM_TYPE[i], PARAM_INFO[i]);
            input.put(param.key, param);
            ++i;
        }
        return input;
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Name name, Map<String, Object> parameters) throws IllegalArgumentException {
        Method method = this.method(name.getLocalPart());
        LinkedHashMap result = new LinkedHashMap();
        Annotation[] annotationArray = method.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof DescribeResult) {
                DescribeResult info = (DescribeResult)annotation;
                Parameter RESULT = new Parameter(info.name(), info.type(), info.name(), info.description());
                result.put(RESULT.key, RESULT);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            Parameter VALUE = new Parameter("value", Object.class, "Undefined Value", "No description is available");
            result.put(VALUE.key, VALUE);
        }
        return result;
    }

    @Override
    public InternationalString getTitle(Name name) {
        return null;
    }

    @Override
    public String getVersion(Name name) {
        return null;
    }

    @Override
    public boolean supportsProgress(Name name) {
        return false;
    }

    public boolean isAvailable() {
        return false;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    Parameter<?> paramInfo(int i, Class<?> TYPE, Annotation[] PARAM_INFO) {
        Parameter param;
        DescribeParameter info = null;
        Annotation[] annotationArray = PARAM_INFO;
        int n = PARAM_INFO.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof DescribeParameter) {
                info = (DescribeParameter)annotation;
                break;
            }
            ++n2;
        }
        if (info != null) {
            param = new Parameter(info.name(), TYPE, info.name(), info.description());
            return param;
        }
        param = new Parameter("arg" + i, TYPE, "Argument " + i, "Input " + TYPE.getName() + " value");
        return param;
    }

    static DescribeParameter paramInfo(int i, Annotation[][] PARAM_INFO) {
        Annotation[] annotationArray = PARAM_INFO[i];
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof DescribeParameter) {
                DescribeParameter PARAMETER = (DescribeParameter)annotation;
                return PARAMETER;
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProcessInvocation
    implements Process {
        private String name;
        private Class<DEMTools> target;

        public ProcessInvocation(Class<DEMTools> target, String method) {
            this.target = target;
            this.name = method;
        }

        Method method() {
            Method[] methodArray = this.target.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (this.name.equalsIgnoreCase(method.getName())) {
                    return method;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws ProcessException {
            Method method = this.method();
            if (method == null) {
                return null;
            }
            TypeVariable<Method>[] PARAM_TYPE = method.getTypeParameters();
            Annotation[][] PARAM_INFO = method.getParameterAnnotations();
            Object[] args = new Object[PARAM_TYPE.length];
            int i = 0;
            while (i < args.length) {
                Object value;
                DescribeParameter PARAMETER = DEMProcessFactory.paramInfo(i, PARAM_INFO);
                String name = PARAMETER == null ? "arg" + i : PARAMETER.name();
                args[i] = value = input.get(name);
                ++i;
            }
            Object value = null;
            try {
                value = method.invoke(null, args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (value == null) {
                throw new IllegalArgumentException("Unable to encode null result for " + this.name);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                int i2 = 0;
                Annotation[] annotationArray = method.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    if (i2 >= values.length) break;
                    Object obj = values[i2];
                    if (annotation instanceof DescribeResult) {
                        DescribeResult RESULT = (DescribeResult)annotation;
                        if (RESULT.type().isInstance(obj)) {
                            result.put(RESULT.name(), obj);
                        } else {
                            throw new IllegalArgumentException(String.valueOf(this.name) + " unable to encode result " + obj + " as " + RESULT.type());
                        }
                    }
                    ++n2;
                }
                return result;
            }
            if (value instanceof Map) {
                return (Map)value;
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            DescribeResult RESULT = method.getAnnotation(DescribeResult.class);
            if (RESULT != null) {
                result.put(RESULT.name(), value);
            } else {
                result.put("value", value);
            }
            return null;
        }
    }
}

