/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.impl.SingleProcessFactory;
import org.geotools.process.literal.FeatureBufferProcess;
import org.geotools.text.Text;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureBufferFactory
extends SingleProcessFactory {
    static final Parameter<Feature> INPUT_A = new Parameter("input_a", Feature.class, Text.text("Input Feature"), Text.text("Feature to buffer"));
    static final Parameter<Double> INPUT_B = new Parameter("input_b", Double.class, Text.text("Buffer amount"), Text.text("Amount to buffer by"));
    static final Parameter<Feature> RESULT = new Parameter("result", Feature.class, Text.text("Buffered feature"), Text.text("Result of buffering"));
    static final Map<String, Parameter<?>> prameterInfo = new TreeMap();
    static final Map<String, Parameter<?>> resultInfo;

    static {
        prameterInfo.put(FeatureBufferFactory.INPUT_A.key, INPUT_A);
        prameterInfo.put(FeatureBufferFactory.INPUT_B.key, INPUT_B);
        resultInfo = new TreeMap();
        resultInfo.put(FeatureBufferFactory.RESULT.key, RESULT);
    }

    public FeatureBufferFactory() {
        super((Name)new NameImpl("gt", "FeatureBuffer"));
    }

    public Process create(Map<String, Object> parameters) throws IllegalArgumentException {
        return new FeatureBufferProcess(this);
    }

    @Override
    public InternationalString getDescription() {
        return Text.text("Buffers a Feature by a constant.");
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo() {
        return Collections.unmodifiableMap(prameterInfo);
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return Collections.unmodifiableMap(resultInfo);
    }

    @Override
    public InternationalString getTitle() {
        return Text.text("FeatureBuffer");
    }

    @Override
    public boolean supportsProgress() {
        return true;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public Process create() throws IllegalArgumentException {
        return new FeatureBufferProcess(this);
    }
}

