/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.impl.SingleProcessFactory;
import org.geotools.process.literal.IntersectionProcess;
import org.geotools.text.Text;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionFactory
extends SingleProcessFactory {
    static final Parameter<Geometry> GEOM1 = new Parameter("geom1", Geometry.class, Text.text("Geometry 1"), Text.text("Geometry 1 of 2 to intersect"));
    static final Parameter<Geometry> GEOM2 = new Parameter("geom2", Geometry.class, Text.text("Geometry 2"), Text.text("Geometry 2 of 2 to intersect"));
    static final Map<String, Parameter<?>> prameterInfo = new TreeMap();
    static final Parameter<Geometry> RESULT;
    static final Map<String, Parameter<?>> resultInfo;

    static {
        prameterInfo.put(IntersectionFactory.GEOM1.key, GEOM1);
        prameterInfo.put(IntersectionFactory.GEOM2.key, GEOM2);
        RESULT = new Parameter("result", Geometry.class, Text.text("Result"), Text.text("Result of Geometry1.intersect( Geometry2 )"));
        resultInfo = new TreeMap();
        resultInfo.put(IntersectionFactory.RESULT.key, RESULT);
    }

    public IntersectionFactory() {
        super((Name)new NameImpl("gt", "Intersect"));
    }

    @Override
    public Process create() throws IllegalArgumentException {
        return new IntersectionProcess(this);
    }

    @Override
    public InternationalString getDescription() {
        return Text.text("Intersection between two literal geometry");
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo() {
        return Collections.unmodifiableMap(prameterInfo);
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return Collections.unmodifiableMap(resultInfo);
    }

    @Override
    public InternationalString getTitle() {
        return Text.text("Intersection");
    }

    @Override
    public boolean supportsProgress() {
        return false;
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

