/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.feature.BufferFeatureCollectionFactory;
import org.geotools.process.feature.FeatureToFeatureProcess;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferFeatureCollectionProcess
extends FeatureToFeatureProcess {
    public BufferFeatureCollectionProcess(BufferFeatureCollectionFactory factory) {
        super(factory);
    }

    @Override
    protected void processFeature(SimpleFeature feature, Map<String, Object> input) throws Exception {
        Double buffer = (Double)input.get(BufferFeatureCollectionFactory.BUFFER.key);
        Geometry g = (Geometry)feature.getDefaultGeometry();
        if ((g = g.buffer(buffer.doubleValue())) instanceof Polygon) {
            g = g.getFactory().createMultiPolygon(new Polygon[]{(Polygon)g});
        }
        feature.setDefaultGeometry((Object)g);
    }

    @Override
    SimpleFeatureType getTargetSchema(SimpleFeatureType sourceSchema, Map<String, Object> input) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        for (AttributeDescriptor ad : sourceSchema.getAttributeDescriptors()) {
            GeometryDescriptor defaultGeometry;
            if (ad == (defaultGeometry = sourceSchema.getGeometryDescriptor())) {
                tb.add(ad.getName().getLocalPart(), MultiPolygon.class, defaultGeometry.getCoordinateReferenceSystem());
                continue;
            }
            tb.add(ad);
        }
        tb.setName(sourceSchema.getName());
        return tb.buildFeatureType();
    }
}

