/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Polygon;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.Parameter;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.impl.SingleProcessFactory;
import org.geotools.process.raster.RasterToVectorProcess;
import org.geotools.text.Text;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RasterToVectorFactory
extends SingleProcessFactory {
    private static final String VERSION_STRING = "0.0.4";
    public static final Parameter<GridCoverage2D> RASTER = new Parameter("raster", GridCoverage2D.class, Text.text("Source coverage"), Text.text("Grid coverage to vectorize"));
    public static final Parameter<Integer> BAND = new Parameter("band", Integer.class, Text.text("Band"), Text.text("Index of band to vectorize"), false, 0, 1, (Object)1, null);
    public static final Parameter<Envelope> BOUNDS = new Parameter("bounds", Envelope.class, Text.text("Bounds"), Text.text("Bounds of the area to vectorize"), false, 0, 1, null, null);
    public static final Parameter<Double> OUTSIDE = new Parameter("nodata", Double.class, Text.text("Outside values"), Text.text("Collection of Double values representing NODATA or outside"), false, 0, -1, null, null);
    public static final Parameter<Boolean> INSIDE_EDGES = new Parameter("inside", Boolean.class, Text.text("Inside edges"), Text.text("Whether to vectorize inside edges (those separating regions with non-outside values"), false, 0, 1, (Object)Boolean.FALSE, null);
    private static final Map<String, Parameter<?>> parameterInfo = new TreeMap();
    public static final Parameter<FeatureCollection> RESULT_FEATURES;
    private static final Map<String, Parameter<?>> resultInfo;

    @Override
    public RasterToVectorProcess create() {
        return new RasterToVectorProcess(this);
    }

    @Override
    public InternationalString getDescription() {
        return Text.text("Raster region to vector polygon conversion");
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo() {
        return Collections.unmodifiableMap(parameterInfo);
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return Collections.unmodifiableMap(resultInfo);
    }

    @Override
    public InternationalString getTitle() {
        return Text.text("Vectorize raster regions");
    }

    @Override
    public String getVersion() {
        return VERSION_STRING;
    }

    @Override
    public boolean supportsProgress() {
        return true;
    }

    public static SimpleFeatureType getSchema(CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("r2vPolygons");
        if (crs != null) {
            typeBuilder.setCRS(crs);
        }
        typeBuilder.add("shape", Polygon.class, (CoordinateReferenceSystem)null);
        typeBuilder.add("gridvalue", Double.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        return type;
    }

    static {
        parameterInfo.put(RasterToVectorFactory.RASTER.key, RASTER);
        parameterInfo.put(RasterToVectorFactory.BAND.key, BAND);
        parameterInfo.put(RasterToVectorFactory.BOUNDS.key, BOUNDS);
        parameterInfo.put(RasterToVectorFactory.OUTSIDE.key, OUTSIDE);
        parameterInfo.put(RasterToVectorFactory.INSIDE_EDGES.key, INSIDE_EDGES);
        resultInfo = new TreeMap();
        SimpleFeatureType schema = RasterToVectorFactory.getSchema(null);
        HashMap<String, SimpleFeatureType> metadata = new HashMap<String, SimpleFeatureType>();
        metadata.put("featureType", schema);
        RESULT_FEATURES = new Parameter("features", FeatureCollection.class, Text.text("Features"), Text.text("Vectorized region boundaries as polygon features"), metadata);
        resultInfo.put(RasterToVectorFactory.RESULT_FEATURES.key, RESULT_FEATURES);
    }
}

