/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.feature;

import java.util.HashMap;
import java.util.Map;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.process.feature.AbstractFeatureCollectionProcess;
import org.geotools.process.feature.FeatureToFeatureProcessFactory;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureToFeatureProcess
extends AbstractFeatureCollectionProcess {
    public FeatureToFeatureProcess(FeatureToFeatureProcessFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        FeatureCollection features = (FeatureCollection)input.get(FeatureToFeatureProcessFactory.FEATURES.key);
        float scale = 100.0f / (float)features.size();
        monitor.started();
        SimpleFeatureType targetSchema = this.getTargetSchema((SimpleFeatureType)features.getSchema(), input);
        DefaultFeatureCollection result = new DefaultFeatureCollection(null, targetSchema);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder((SimpleFeatureType)result.getSchema());
        FeatureIterator fi = features.features();
        try {
            int counter = 0;
            while (fi.hasNext()) {
                fb.init((SimpleFeature)fi.next());
                SimpleFeature feature = fb.buildFeature(null);
                try {
                    this.processFeature(feature, input);
                }
                catch (Exception e) {
                    monitor.exceptionOccurred((Throwable)e);
                }
                monitor.progress(scale * (float)counter++);
                result.add((Feature)feature);
            }
        }
        finally {
            features.close(fi);
        }
        monitor.complete();
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put(FeatureToFeatureProcessFactory.RESULT.key, result);
        return output;
    }

    SimpleFeatureType getTargetSchema(SimpleFeatureType sourceSchema, Map<String, Object> input) {
        return sourceSchema;
    }
}

