/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.Command;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.UnsupportedImplementationException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CRS {
    private static final Hints FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;
    private static CoordinateOperationFactory strictFactory;
    private static CoordinateOperationFactory lenientFactory;

    private CRS() {
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean longitudeFirst) throws FactoryRegistryException {
        CRSAuthorityFactory factory;
        CRSAuthorityFactory cRSAuthorityFactory = factory = longitudeFirst ? xyFactory : defaultFactory;
        if (factory == null) {
            try {
                factory = new DefaultAuthorityFactory(longitudeFirst);
                if (longitudeFirst) {
                    xyFactory = factory;
                } else {
                    defaultFactory = factory;
                }
            }
            catch (NoSuchElementException exception) {
                throw new FactoryNotFoundException(null, (Throwable)exception);
            }
        }
        return factory;
    }

    public static synchronized CoordinateOperationFactory getCoordinateOperationFactory(boolean lenient) {
        CoordinateOperationFactory factory;
        CoordinateOperationFactory coordinateOperationFactory = factory = lenient ? lenientFactory : strictFactory;
        if (factory == null) {
            Hints hints = GeoTools.getDefaultHints();
            if (lenient) {
                hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            }
            factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
            if (lenient) {
                lenientFactory = factory;
            } else {
                strictFactory = factory;
            }
        }
        return factory;
    }

    public static Version getVersion(String authority) throws FactoryRegistryException {
        Factory factory;
        Object candidate = ReferencingFactoryFinder.getCRSAuthorityFactory(authority, null);
        HashSet<Factory> guard = new HashSet<Factory>();
        while (candidate instanceof Factory && guard.add(factory = (Factory)candidate)) {
            Map hints = factory.getImplementationHints();
            Object version = hints.get(Hints.VERSION);
            if (version instanceof Version) {
                return (Version)version;
            }
            candidate = hints.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String authority) {
        return DefaultAuthorityFactory.getSupportedCodes(authority);
    }

    public static Set<String> getSupportedAuthorities(boolean returnAliases) {
        return DefaultAuthorityFactory.getSupportedAuthorities(returnAliases);
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(code, false);
    }

    public static CoordinateReferenceSystem decode(String code, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        code = code.trim().toUpperCase();
        return CRS.getAuthorityFactory(longitudeFirst).createCoordinateReferenceSystem(code);
    }

    public static CoordinateReferenceSystem parseWKT(String wkt) throws FactoryException {
        return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem crs) {
        GeographicBoundingBox bounds;
        Extent domainOfValidity;
        GeneralEnvelope envelope = null;
        GeneralEnvelope merged = null;
        if (crs != null && (domainOfValidity = crs.getDomainOfValidity()) != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (Boolean.FALSE.equals(extent.getInclusion()) || !(extent instanceof BoundingPolygon)) continue;
                for (Geometry geometry : ((BoundingPolygon)extent).getPolygons()) {
                    CoordinateReferenceSystem sourceCRS;
                    Envelope candidate = geometry.getEnvelope();
                    if (candidate == null || (sourceCRS = candidate.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(sourceCRS, crs)) continue;
                    if (envelope == null) {
                        envelope = candidate;
                        continue;
                    }
                    if (merged == null) {
                        envelope = merged = new GeneralEnvelope(envelope);
                    }
                    merged.add(envelope);
                }
            }
        }
        if (envelope == null && (bounds = CRS.getGeographicBoundingBox(crs)) != null && !Boolean.FALSE.equals(bounds.getInclusion())) {
            envelope = merged = new GeneralEnvelope(new double[]{bounds.getWestBoundLongitude(), bounds.getSouthBoundLatitude()}, new double[]{bounds.getEastBoundLongitude(), bounds.getNorthBoundLatitude()});
            SingleCRS targetCRS = CRS.getHorizontalCRS(crs);
            GeographicCRS sourceCRS = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)targetCRS);
            merged.setCoordinateReferenceSystem((CoordinateReferenceSystem)sourceCRS);
            try {
                envelope = CRS.transform(envelope, (CoordinateReferenceSystem)targetCRS);
            }
            catch (TransformException exception) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", (Exception)((Object)exception));
            }
            merged.setCoordinateReferenceSystem((CoordinateReferenceSystem)targetCRS);
        }
        return envelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Extent domainOfValidity;
        GeographicBoundingBox bounds = null;
        GeographicBoundingBoxImpl merged = null;
        if (crs != null && (domainOfValidity = crs.getDomainOfValidity()) != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (!(extent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox candidate = (GeographicBoundingBox)extent;
                if (bounds == null) {
                    bounds = candidate;
                    continue;
                }
                if (merged == null) {
                    merged = new GeographicBoundingBoxImpl(bounds);
                    bounds = merged;
                }
                merged.add(candidate);
            }
        }
        return bounds;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof SingleCRS) {
            CoordinateSystem cs = crs.getCoordinateSystem();
            int dimension = cs.getDimension();
            if (dimension == 2) {
                CoordinateReferenceSystem base = crs;
                while (base instanceof GeneralDerivedCRS) {
                    base = ((GeneralDerivedCRS)base).getBaseCRS();
                }
                if (base instanceof GeographicCRS) {
                    return (SingleCRS)crs;
                }
                if (base.getCoordinateSystem() instanceof CartesianCS) {
                    return (SingleCRS)crs;
                }
            } else if (dimension >= 3 && crs instanceof GeographicCRS) {
                CoordinateSystemAxis axis0 = null;
                CoordinateSystemAxis axis1 = null;
                int count = 0;
                block9: for (int i = 0; i < dimension; ++i) {
                    CoordinateSystemAxis axis = cs.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(axis.getDirection())) continue;
                    switch (count++) {
                        case 0: {
                            axis0 = axis;
                            continue block9;
                        }
                        case 1: {
                            axis1 = axis;
                            continue block9;
                        }
                    }
                }
                if (count == 2) {
                    GeographicCRS horizontalCRS;
                    EllipsoidalCS horizontalCS;
                    GeodeticDatum datum = ((GeographicCRS)crs).getDatum();
                    Map<String, ?> properties = CRSUtilities.changeDimensionInName((IdentifiedObject)cs, "3D", "2D");
                    try {
                        horizontalCS = ReferencingFactoryFinder.getCSFactory(null).createEllipsoidalCS(properties, axis0, axis1);
                    }
                    catch (FactoryException e) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)e);
                        horizontalCS = new DefaultEllipsoidalCS(properties, axis0, axis1);
                    }
                    properties = CRSUtilities.changeDimensionInName((IdentifiedObject)crs, "3D", "2D");
                    try {
                        horizontalCRS = ReferencingFactoryFinder.getCRSFactory(null).createGeographicCRS(properties, datum, horizontalCS);
                    }
                    catch (FactoryException e) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)e);
                        horizontalCRS = new DefaultGeographicCRS(properties, datum, horizontalCS);
                    }
                    return horizontalCRS;
                }
            }
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                SingleCRS candidate = CRS.getHorizontalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            return (ProjectedCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                ProjectedCRS candidate = CRS.getProjectedCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                VerticalCRS candidate = CRS.getVerticalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                TemporalCRS candidate = CRS.getTemporalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                Ellipsoid candidate = CRS.getEllipsoid(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object1).equals((AbstractIdentifiedObject)object2, false);
        }
        return object1 != null && object1.equals(object2);
    }

    public static String toSRS(CoordinateReferenceSystem crs) {
        if (crs != null) {
            Set identifiers = crs.getIdentifiers();
            if (identifiers.isEmpty()) {
                ReferenceIdentifier name = crs.getName();
                if (name != null) {
                    return name.toString();
                }
            } else {
                return ((ReferenceIdentifier)identifiers.iterator().next()).toString();
            }
        }
        return null;
    }

    public static String lookupIdentifier(IdentifiedObject object, boolean fullScan) throws FactoryException {
        AbstractAuthorityFactory xyFactory = (AbstractAuthorityFactory)CRS.getAuthorityFactory(true);
        IdentifiedObjectFinder finder = xyFactory.getIdentifiedObjectFinder(object.getClass());
        finder.setFullScanAllowed(fullScan);
        return finder.findIdentifier(object);
    }

    public static String lookupIdentifier(Citation authority, CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        ReferenceIdentifier id = AbstractIdentifiedObject.getIdentifier((IdentifiedObject)crs, authority);
        if (id != null) {
            return id.getCode();
        }
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(FORCE_LONGITUDE_FIRST_AXIS_ORDER)) {
            if (!Citations.identifierMatches((Citation)factory.getAuthority(), (Citation)authority) || !(factory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory f = (AbstractAuthorityFactory)factory;
            IdentifiedObjectFinder finder = f.getIdentifiedObjectFinder(crs.getClass());
            finder.setFullScanAllowed(fullScan);
            String code = finder.findIdentifier((IdentifiedObject)crs);
            if (code == null) continue;
            return code;
        }
        return null;
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        String identifier = CRS.lookupIdentifier(Citations.EPSG, crs, fullScan);
        if (identifier != null) {
            int split = identifier.lastIndexOf(58);
            String code = identifier.substring(split + 1);
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                throw new FactoryException(Errors.format((int)169, (Object)identifier), (Throwable)e);
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.findMathTransform(sourceCRS, targetCRS, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            return IdentityTransform.create(sourceCRS.getCoordinateSystem().getDimension());
        }
        CoordinateOperationFactory operationFactory = CRS.getCoordinateOperationFactory(lenient);
        return operationFactory.createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (envelope != null && targetCRS != null && (sourceCRS = envelope.getCoordinateReferenceSystem()) != null) {
            if (!CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
                CoordinateOperation operation;
                CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory(true);
                try {
                    operation = factory.createOperation(sourceCRS, targetCRS);
                }
                catch (FactoryException exception) {
                    throw new TransformException(Errors.format((int)26), (Throwable)exception);
                }
                if (!operation.getMathTransform().isIdentity()) {
                    envelope = CRS.transform(operation, envelope);
                }
            }
            assert (CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), targetCRS));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        return CRS.transform(transform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static GeneralEnvelope transform(MathTransform transform, Envelope envelope, GeneralDirectPosition targetPt) throws TransformException {
        int n;
        if (envelope == null) {
            return null;
        }
        if (transform.isIdentity()) {
            GeneralEnvelope e = new GeneralEnvelope(envelope);
            e.setCoordinateReferenceSystem(null);
            if (targetPt != null) {
                int i = envelope.getDimension();
                while (--i >= 0) {
                    targetPt.setOrdinate(i, e.getCenter(i));
                }
            }
            return e;
        }
        int sourceDim = transform.getSourceDimensions();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Errors.format((int)68, (Object)sourceDim, (Object)envelope.getDimension()));
        }
        int coordinateNumber = 0;
        GeneralEnvelope transformed = null;
        if (targetPt == null) {
            targetPt = new GeneralDirectPosition(transform.getTargetDimensions());
        }
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(sourceDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.setOrdinate(i, envelope.getMinimum(i));
        }
        block7: while (true) {
            if (targetPt != transform.transform((DirectPosition)sourcePt, (DirectPosition)targetPt)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new GeneralEnvelope(targetPt, targetPt);
            }
            n = ++coordinateNumber;
            int i2 = sourceDim;
            block8: while (true) {
                if (--i2 < 0) {
                    return transformed;
                }
                switch (n % 3) {
                    case 0: {
                        sourcePt.setOrdinate(i2, envelope.getMinimum(i2));
                        n /= 3;
                        continue block8;
                    }
                    case 1: {
                        sourcePt.setOrdinate(i2, envelope.getMaximum(i2));
                        continue block7;
                    }
                    case 2: {
                        sourcePt.setOrdinate(i2, envelope.getCenter(i2));
                        continue block7;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n);
    }

    public static GeneralEnvelope transform(CoordinateOperation operation, Envelope envelope) throws TransformException {
        CoordinateReferenceSystem targetCRS;
        CoordinateSystem cs;
        CoordinateReferenceSystem crs;
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(crs, sourceCRS)) {
            throw new MismatchedReferenceSystemException(Errors.format((int)197));
        }
        MathTransform mt = operation.getMathTransform();
        GeneralDirectPosition centerPt = new GeneralDirectPosition(mt.getTargetDimensions());
        GeneralEnvelope transformed = CRS.transform(mt, envelope, centerPt);
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null) {
            GeneralDirectPosition sourcePt = null;
            DirectPosition targetPt = null;
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                boolean b2;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null) continue;
                double min = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                double v1 = axis.getMinimumValue();
                double v2 = axis.getMaximumValue();
                boolean b1 = v1 > min && v1 < max;
                boolean bl = b2 = v2 > min && v2 < max;
                if (!b1 && !b2) continue;
                if (sourcePt == null) {
                    sourcePt = new GeneralDirectPosition(dimension);
                    for (int j = 0; j < dimension; ++j) {
                        sourcePt.setOrdinate(j, envelope.getCenter(j));
                    }
                }
                if (b1) {
                    sourcePt.setOrdinate(i, v1);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                if (b2) {
                    sourcePt.setOrdinate(i, v2);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                sourcePt.setOrdinate(i, envelope.getCenter(i));
            }
        }
        if ((targetCRS = operation.getTargetCRS()) == null) {
            return transformed;
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        GeneralEnvelope generalEnvelope = null;
        DirectPosition sourcePt = null;
        GeneralDirectPosition targetPt = null;
        int dimension = targetCS.getDimension();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis == null) continue;
            boolean testMax = false;
            do {
                double extremum;
                double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
                if (targetPt == null) {
                    try {
                        mt = mt.inverse();
                    }
                    catch (NoninvertibleTransformException exception) {
                        if (dimension >= mt.getSourceDimensions()) {
                            CRS.unexpectedException("transform", (Exception)((Object)exception));
                        }
                        return transformed;
                    }
                    targetPt = new GeneralDirectPosition(mt.getSourceDimensions());
                    for (int j = 0; j < dimension; ++j) {
                        targetPt.setOrdinate(j, centerPt.getOrdinate(j));
                    }
                    generalEnvelope = envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
                }
                targetPt.setOrdinate(i, extremum);
                try {
                    sourcePt = mt.transform(targetPt, sourcePt);
                }
                catch (TransformException e) {
                    continue;
                }
                if (!generalEnvelope.contains(sourcePt)) continue;
                transformed.add(targetPt);
            } while (testMax = !testMax);
            if (targetPt == null) continue;
            targetPt.setOrdinate(i, centerPt.getOrdinate(i));
        }
        return transformed;
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        return CRS.transform(transform, envelope, destination, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination, Point2D.Double point) throws TransformException {
        if (envelope == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            point.x = (i & 1) == 0 ? envelope.getMinX() : envelope.getMaxX();
            point.y = (i & 2) == 0 ? envelope.getMinY() : envelope.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = envelope.getCenterX();
                    break;
                }
                case 8: {
                    point.x = envelope.getCenterX();
                }
                case 4: 
                case 7: {
                    point.y = envelope.getCenterY();
                }
            }
            if (point != transform.transform((Point2D)point, (Point2D)point)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (destination != null) {
            destination.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
        } else {
            destination = XRectangle2D.createFromExtremums(xmin, ymin, xmax, ymax);
        }
        assert (destination == envelope || !(destination instanceof Rectangle2D.Double) && !(destination instanceof Rectangle2D.Float) || XRectangle2D.equalsEpsilon(destination, CRS.transform((MathTransform)transform, (Envelope)new Envelope2D(null, envelope)).toRectangle2D())) : destination;
        return destination;
    }

    public static Rectangle2D transform(CoordinateOperation operation, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        CoordinateReferenceSystem targetCRS;
        CoordinateSystem cs;
        if (envelope == null) {
            return null;
        }
        MathTransform transform = operation.getMathTransform();
        if (!(transform instanceof MathTransform2D)) {
            throw new MismatchedDimensionException(Errors.format((int)101));
        }
        MathTransform2D mt = (MathTransform2D)transform;
        Point2D.Double center = new Point2D.Double();
        destination = CRS.transform(mt, envelope, destination, center);
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null && cs.getDimension() == 2) {
            CoordinateSystemAxis axis = cs.getAxis(0);
            double min = envelope.getMinX();
            double max = envelope.getMaxX();
            Point2D.Double pt = null;
            for (int i = 0; i < 4; ++i) {
                double v;
                if (i == 2) {
                    axis = cs.getAxis(1);
                    min = envelope.getMinY();
                    max = envelope.getMaxY();
                }
                double d = v = (i & 1) == 0 ? axis.getMinimumValue() : axis.getMaximumValue();
                if (!(v > min) || !(v < max)) continue;
                if (pt == null) {
                    pt = new Point2D.Double();
                }
                if ((i & 2) == 0) {
                    pt.x = v;
                    pt.y = envelope.getCenterY();
                } else {
                    pt.x = envelope.getCenterX();
                    pt.y = v;
                }
                destination.add(mt.transform((Point2D)pt, (Point2D)pt));
            }
        }
        if ((targetCRS = operation.getTargetCRS()) == null) {
            return destination;
        }
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null || targetCS.getDimension() != 2) {
            return destination;
        }
        Point2D sourcePt = null;
        Point2D targetPt = null;
        for (int flag = 0; flag < 4; ++flag) {
            double extremum;
            int i = flag >> 1;
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis == null) continue;
            double d = extremum = (flag & 1) == 0 ? axis.getMinimumValue() : axis.getMaximumValue();
            if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
            if (targetPt == null) {
                try {
                    mt = mt.inverse();
                }
                catch (NoninvertibleTransformException exception) {
                    CRS.unexpectedException("transform", (Exception)((Object)exception));
                    return destination;
                }
                targetPt = new Point2D.Double();
            }
            switch (i) {
                case 0: {
                    targetPt.setLocation(extremum, center.y);
                    break;
                }
                case 1: {
                    targetPt.setLocation(center.x, extremum);
                    break;
                }
                default: {
                    throw new AssertionError(flag);
                }
            }
            try {
                sourcePt = mt.transform(targetPt, sourcePt);
            }
            catch (TransformException e) {
                continue;
            }
            if (!envelope.contains(sourcePt)) continue;
            destination.add(targetPt);
        }
        assert (destination == envelope || XRectangle2D.equalsEpsilon(destination, CRS.transform(operation, (Envelope)new GeneralEnvelope(envelope)).toRectangle2D())) : destination;
        return destination;
    }

    static void unexpectedException(String methodName, Exception exception) {
        Logging.unexpectedException(CRS.class, (String)methodName, (Throwable)exception);
    }

    public static void reset(String aspects) {
        StringTokenizer tokens = new StringTokenizer(aspects, ", \t\n\r\f");
        while (tokens.hasMoreTokens()) {
            String aspect = tokens.nextToken().trim();
            boolean all = aspect.equalsIgnoreCase("all");
            if (all || aspect.equalsIgnoreCase("plugins")) {
                ReferencingFactoryFinder.scanForPlugins();
            }
            if (!all && !aspect.equalsIgnoreCase("warnings")) continue;
            MapProjection.resetWarnings();
        }
    }

    public static void main(String[] args) {
        Command.execute(args);
    }

    static {
        GeoTools.addChangeListener((ChangeListener)new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    defaultFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

